<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    require '../../backend/bd/Conexion.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver lista de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    



    <title>EFAC | Información del USUARIO</title>
</head>
<body>

      <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
 <!-- SIDEBAR -->

    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
             <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li><a href="#" class="active">Información del Paciente</a></li>
            </ul>
           <br>

           <?php 
 $id = $_GET['id'];
 $sentencia = $connect->prepare("SELECT * FROM registro_estudiantes WHERE id= ?");
 $sentencia->execute([$id]);

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
   ?>
   <?php if(count($data)>0):?>
        <?php foreach($data as $d):?>
<div class="input-block">
    
    <a type="button" href="../pacientes/imprimir.php?id=<?php echo $d->id; ?>" class="button">IMPRIMIR</a>

                    <div class="wrap-line">

                                <!-- Inputs -->
        <div class="brise-input">
            
            <input type="text" value="<?php echo $d->numero_documento; ?>" name="text" readonly>
            <label>Número Documento</label>
            <span class="line"></span>
        </div>
        <div class="brise-input">
            
            <input type="text" value="<?php echo $d->nombres; ?>" name="text" readonly>
            <label>Nombres</label>
            <span class="line"></span>
        </div>

                <!-- Inputs -->
        <div class="brise-input">
            
            <input type="text" value="<?php echo $d->apellidos; ?>" name="text" readonly>
            <label>Apellidos</label>
            <span class="line"></span>
        </div>
        <div class="brise-input">
           
            <input type="text" value="<?php echo $d->direccion; ?>" name="text" readonly>
            <label>Dirección</label>
            <span class="line"></span>
        </div>

        <div class="brise-input">
          
            <input type="text" value="<?php echo $d->fecha_nacimiento; ?>" name="text" readonly>
            <label>Fecha Nacimiento</label>
            <span class="line"></span>
        </div>


        <div class="brise-input">
          
            <input type="text" value="<?php echo $d->genero; ?>" name="text" readonly>
            <label>Género</label>
            <span class="line"></span>
        </div>

                <div class="brise-input">
            
            <input type="text" value="<?php echo $d->grupo_sanguineo; ?>" name="text" readonly>
            <label>Grupo Sanguíneo</label>
            <span class="line"></span>
        </div>

        <div class="brise-input">
           
            <input type="text" value="<?php echo $d->telefono; ?>" name="text" readonly>
            <label>Teléfono</label>
            <span class="line"></span>
        </div>
                        
                    </div>

</div>

        <?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    

   
</body>
</html>


