<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver lista de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];

    // --- LOGIC TO DELETE STUDENT BEFORE QUERYING THE LIST ---
    // Capture the output (popup) so we can display it later at the bottom
    ob_start();
    include '../../backend/php/delete_patients.php'; 
    $deletePopup = ob_get_clean();
    // --------------------------------------------------------
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">

    <!-- Data Tables -->
    <link rel="stylesheet" type="text/css" href="../../backend/css/datatable.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/buttonsdataTables.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/font.css">
    
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <title>EFAC | Listado de Estudiantes</title>
</head>
<body>
    
      <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
 <!-- SIDEBAR -->

    <!-- NAVBAR -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                   <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../dashboard.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Listado de los Usuarios</a></li>
            </ul>
            <button class="button" onclick="location.href='nuevo.php'">Nuevo</button>
          <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>Estudiantes</h3>
                       
                    </div>
                    
                    <!-- Filtro por Modalidad -->
                    <div style="padding: 20px; background: white; margin-bottom: 20px; border-radius: 8px; display: flex; align-items: center; gap: 15px; flex-wrap: wrap;">
                        <div style="flex: 1; min-width: 250px;">
                            <label for="filtroModalidad" style="font-weight: 600; margin-right: 10px; color: #333;">Filtrar por Modalidad:</label>
                            <select id="filtroModalidad" style="padding: 8px 15px; border: 2px solid #e8e8e8; border-radius: 6px; font-size: 14px; min-width: 250px;">
                                <option value="">Todas las modalidades</option>
                                <?php 
                                require_once '../../backend/bd/Conexion.php';
                                // Obtener modalidades únicas
                                $modalidades = $connect->query("SELECT DISTINCT modalidad FROM patients WHERE modalidad != '' ORDER BY modalidad");
                                while($mod = $modalidades->fetch(PDO::FETCH_ASSOC)) {
                                    echo '<option value="'.htmlspecialchars($mod['modalidad']).'">'.htmlspecialchars($mod['modalidad']).'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <button id="downloadFilteredPDF" style="padding: 10px 20px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; display: flex; align-items: center; gap: 8px; transition: all 0.3s;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 20px rgba(102, 126, 234, 0.4)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';">
                            <i class='bx bxs-file-pdf' style='font-size: 18px;'></i>
                            Descargar PDF Filtrado
                        </button>
                    </div>
                    
                   <div class="table-responsive" style="overflow-x:auto;">
                       <?php 
// QUERY UPDATED: Select from 'users' table (Real Students) and LEFT JOIN 'registro_estudiantes' for extra info
// rol = 3 is Ciudadano/Estudiante
$sentencia = $connect->prepare("SELECT u.username, u.name as nombre_usuario, u.email, 
                                       re.id as id_estudiante, re.nombres, re.apellidos, re.fecha_nacimiento, re.genero, re.modalidad, re.telefono, re.estado 
                                FROM users u 
                                LEFT JOIN registro_estudiantes re ON u.id = re.user_id 
                                WHERE u.rol = 3 AND (re.estado != 'Inactivo' OR re.estado IS NULL)
                                ORDER BY u.id DESC;");
 $sentencia->execute();
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
     ?>
     <?php if(count($data)>0):?>
         <table id="example" class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Documento</th>
                    <th scope="col">Estudiante</th>
                    <th scope="col">Edad</th>
                    <th scope="col">Sexo</th>
                    <th scope="col">Modalidad</th>
                    <th scope="col">Teléfono</th>
                    <th scope="col">Estado</th>
                    <th scope="col">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($data as $d):?>
                    <?php 
                        // Calcular edad basada en fecha de nacimiento
                        $edad = '';
                        if(!empty($d->fecha_nacimiento)) {
                            $fechaNacimiento = new DateTime($d->fecha_nacimiento);
                            $hoy = new DateTime();
                            $edad = $hoy->diff($fechaNacimiento)->y;
                        }
                        
                        // Determinar nombre a mostrar
                        if (!empty($d->nombres) || !empty($d->apellidos)) {
                            $nombreMostrar = trim($d->nombres . ' ' . $d->apellidos);
                        } else {
                            $nombreMostrar = $d->nombre_usuario; // Fallback a users table
                        }
                    ?>
                    <tr data-modalidad="<?php echo htmlspecialchars($d->modalidad ?? ''); ?>">
                        <!-- Display User Data (Source of Truth) -->
                        <td scope="row" style="color: #2d3436; font-weight: 600;"><?php echo $d->username ?></td> <!-- Username/Document from Users -->
                        <td data-title="USUARIO">
                            <?php echo strtoupper($nombreMostrar) ?>
                        </td>
                        <td data-title="Edad"><?php echo $edad != '' ? $edad . ' años' : 'N/A'; ?></td>
                        <td data-title="Sexo"><?php echo !empty($d->genero) ? strtoupper($d->genero) : 'N/A'; ?></td>
                        <td data-title="Modalidad"><?php echo !empty($d->modalidad) ? strtoupper($d->modalidad) : 'N/A'; ?></td>
                        <td data-title="Teléfono"><a href="tel:<?php echo $d->telefono ?>"><?php echo !empty($d->telefono) ? $d->telefono : 'N/A'; ?></a></td>
                        
                        
                        <td data-title="Estado">
                            <?php if(isset($d->id_estudiante) && $d->id_estudiante != ''): ?>
                                <label class="switch">
                                  <!-- Nota: Estado en registro_estudiantes es 'aprobado', 'pendiente', etc. o 1/0? 
                                       El código de admin_create_student inserta 'aprobado'. 
                                       Si usas checkbox para activar/desactivar, necesitarás adaptar state.js para manejar texto o cambiar DB a int. 
                                       Asumiremos por ahora que visualmente 'aprobado' es checked. -->
                                  <input type="checkbox" id="<?=$d->id_estudiante?>" value="<?=$d->estado ?>" <?=$d->estado == 'aprobado' || $d->estado == '1' ? 'checked' : '' ;?>/> 
                                  <span class="slider"></span>
                                </label>
                            <?php else: ?>
                                <span class="badge" style="background:#f39c12; color:#fff; padding:2px 5px; border-radius:4px; font-size: 0.8em;">Sin Ficha</span>
                            <?php endif; ?>
                        </td>
                        <td style="white-space: nowrap;">
                            <?php if(isset($d->id_estudiante) && $d->id_estudiante != ''): ?>
                                <a title="Actualizar" href="../pacientes/editar.php?id=<?php echo $d->id_estudiante ?>" class="fa fa-pencil tooltip" style="margin-right: 8px;"></a>
                                <a title="Información" href="../pacientes/info.php?id=<?php echo $d->id_estudiante ?>" class="fa fa-info" style="margin-right: 8px;"></a>
                                <a title="Historial médico" href="../pacientes/historia.php?id=<?php echo $d->id_estudiante ?>" class="fa fa-stethoscope" style="margin-right: 8px;"></a>
                                
                                <form style="display: inline-block; margin: 0;" onsubmit="return confirm('Realmente desea eliminar el registro?');" method='POST' action='<?php $_SERVER['PHP_SELF'] ?>'>
                                    <input type='hidden' name='id_student_delete' value="<?php echo  $d->id_estudiante; ?>">
                                    <button name='delete_student' title="Eliminar" style="cursor: pointer; margin: 0;" class="fa fa-trash"></button>
                                </form>
                            <?php else: ?>
                                <!-- Si existe usuario pero no registro_estudiante -->
                                <span style="font-size: 0.8em; color: #7f8fa6;">--</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
            </tbody>
         </table> 
         <?php else:?>
  
    <div class="alert">
      <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
      <strong>Danger!</strong> No hay datos.
    </div>
    <?php endif; ?>
                    </div>
                </div>
            </div>  

        </main>
        <!-- MAIN -->
    </section>
    <?php 
        // Display the popup captured at the top of the file
        if(isset($deletePopup)) echo $deletePopup; 
    ?>
    <!-- NAVBAR -->
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/admin.js"></script>
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/state.js"></script>
    
    <!-- Data Tables -->
    <script type="text/javascript" src="../../backend/js/datatable.js"></script>
    <script type="text/javascript" src="../../backend/js/datatablebuttons.js"></script>
    <script type="text/javascript" src="../../backend/js/jszip.js"></script>
    <script type="text/javascript" src="../../backend/js/pdfmake.js"></script>
    <script type="text/javascript" src="../../backend/js/vfs_fonts.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonshtml5.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonsprint.js"></script>
    
    <!-- jsPDF for custom PDF generation -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.31/jspdf.plugin.autotable.min.js"></script>
    <script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
    
    // Filtro por modalidad
    $('#filtroModalidad').on('change', function() {
        var modalidadSeleccionada = $(this).val().toUpperCase();
        
        $('#example tbody tr').each(function() {
            var modalidadFila = $(this).attr('data-modalidad').toUpperCase();
            
            if (modalidadSeleccionada === '' || modalidadFila === modalidadSeleccionada) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
    
    // Generar PDF con datos filtrados
    $('#downloadFilteredPDF').on('click', function() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF('l', 'mm', 'a4'); // landscape orientation
        
        // Título
        const modalidadSeleccionada = $('#filtroModalidad').val();
        const titulo = modalidadSeleccionada ? 
            'Lista de Usuarios - Modalidad: ' + modalidadSeleccionada : 
            'Lista de Usuarios - Todas las Modalidades';
        
        doc.setFontSize(16);
        doc.text(titulo, 14, 15);
        
        // Fecha de generación
        const fecha = new Date().toLocaleDateString('es-ES', { 
            year: 'numeric', 
            month: 'long', 
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        });
        doc.setFontSize(10);
        doc.text('Generado: ' + fecha, 14, 22);
        
        // Obtener datos de filas visibles
        const tableData = [];
        $('#example tbody tr:visible').each(function() {
            const row = [];
            // Documento
            row.push($(this).find('td:eq(0)').text().trim());
            // Usuario (nombre completo)
            row.push($(this).find('td:eq(1)').text().trim());
            // Edad
            row.push($(this).find('td:eq(2)').text().trim());
            // Sexo
            row.push($(this).find('td:eq(3)').text().trim());
            // Modalidad
            row.push($(this).find('td:eq(4)').text().trim());
            // Teléfono
            row.push($(this).find('td:eq(5)').text().trim());
            // Estado
            const estado = $(this).find('td:eq(6) input[type=checkbox]').is(':checked') ? 'Activo' : 'Inactivo';
            row.push(estado);
            
            tableData.push(row);
        });
        
        // Generar tabla con autoTable
        doc.autoTable({
            head: [['Documento', 'Usuario', 'Edad', 'Sexo', 'Modalidad', 'Teléfono', 'Estado']],
            body: tableData,
            startY: 28,
            styles: { 
                fontSize: 9,
                cellPadding: 3
            },
            headStyles: {
                fillColor: [73, 104, 173],
                textColor: [255, 255, 255],
                fontStyle: 'bold'
            },
            alternateRowStyles: {
                fillColor: [245, 245, 245]
            },
            margin: { top: 28 }
        });
        
        // Agregar pie de página con total de registros
        const pageCount = doc.internal.getNumberOfPages();
        for (let i = 1; i <= pageCount; i++) {
            doc.setPage(i);
            doc.setFontSize(8);
            doc.text(
                'Total de registros: ' + tableData.length + ' | Página ' + i + ' de ' + pageCount,
                14,
                doc.internal.pageSize.height - 10
            );
        }
        
        // Descargar PDF
        const fileName = modalidadSeleccionada ? 
            'usuarios_' + modalidadSeleccionada.toLowerCase().replace(/\s+/g, '_') + '.pdf' : 
            'usuarios_todos.pdf';
        doc.save(fileName);
    });
} );
    </script>

 <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie and expiry time=1 minute
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>

<script>
// Mostrar alerta de actualización si existe
<?php if(isset($_SESSION['mensaje_actualizacion']) && isset($_SESSION['tipo_mensaje'])): ?>
    Swal.fire({
        icon: '<?php echo $_SESSION['tipo_mensaje']; ?>',
        title: '<?php echo $_SESSION['tipo_mensaje'] === 'success' ? '¡Éxito!' : 'Error'; ?>',
        text: '<?php echo $_SESSION['mensaje_actualizacion']; ?>',
        confirmButtonText: 'Aceptar',
        confirmButtonColor: '#3085d6'
    });
    <?php 
        unset($_SESSION['mensaje_actualizacion']);
        unset($_SESSION['tipo_mensaje']);
    ?>
<?php endif; ?>
</script>

</body>
</html>


