<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver lista de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    
    <!-- QR -->
     <script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.1/build/qrcode.min.js"></script>


    <title>EFAC </title>
</head>
<body>

       <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
            <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->


        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de Estudiantes</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Nuevo Estudiante</a></li>
            </ul>
           
           <!-- UNIFIED FORM -->
            <form action="../../backend/php/admin_create_student.php" enctype="multipart/form-data" method="POST" autocomplete="off" onsubmit="return validateForm()">
              <input type="hidden" name="add_student_admin" value="1">
              
              <div class="containerss">
                <h1>Registro de Nuevo Estudiante</h1>


                <!-- SECCIÓN 1: DATOS DE CUENTA (USERS) -->
                <h3><i class='bx bxs-user-account'></i> Datos de Cuenta (Acceso)</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="username"><b>Usuario</b> <span class="badge-warning">*</span></label>
                        <input type="text" name="username" placeholder="Nombre de usuario" required minlength="4">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="password"><b>Contraseña</b> <span class="badge-warning">*</span></label>
                        <input type="password" name="password" id="password" required minlength="6">
                    </div>
                     <div class="form-group" style="flex: 1;">
                        <label for="confirm_password"><b>Confirmar Contraseña</b> <span class="badge-warning">*</span></label>
                        <input type="password" name="confirm_password" id="confirm_password" required minlength="6">
                        <small id="passError" style="color: red; display: none;">Las contraseñas no coinciden</small>
                    </div>
                </div>
                <hr>

                <!-- SECCIÓN 2: INFORMACIÓN DEL PROGRAMA -->
                <h3><i class='bx bxs-bookmark'></i> Información del Programa</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="tusuario"><b>Tipo de Usuario</b> <span class="badge-warning">*</span></label>
                        <select required name="tusuario" id="tusuario">
                            <option value="">Seleccione</option>
                            <option value="Nuevo">Nuevo</option>
                            <option value="Antiguo">Antiguo</option>
                        </select>
                    </div>
                </div>
                <hr>

                <!-- SECCIÓN 3: INFORMACIÓN PERSONAL -->
                <h3><i class='bx bxs-user-detail'></i> Información Personal</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="tdocumento"><b>Tipo de Documento</b> <span class="badge-warning">*</span></label>
                        <select required name="tdocumento" id="tdocumento">
                            <option value="">Seleccione tipo de documento</option>
                            <option value="R.C">R.C - Registro Civil</option>
                            <option value="T.I">T.I - Tarjeta de Identidad</option>
                            <option value="C.C">C.C - Cédula de Ciudadanía</option>
                            <option value="PPT">PPT - Permiso por Protección Temporal</option>
                        </select>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="nhi"><b>Número de Documento</b> <span class="badge-warning">*</span></label>
                        <input type="text" placeholder="Ej: 1020304050" name="nhi" maxlength="20" required pattern="[0-9]+" title="Solo números">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="primer_nombre"><b>Primer Nombre</b> <span class="badge-warning">*</span></label>
                        <input type="text" placeholder="Primer Nombre" name="primer_nombre" required>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="segundo_nombre"><b>Segundo Nombre</b></label>
                        <input type="text" placeholder="Segundo Nombre (Opcional)" name="segundo_nombre">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="primer_apellido"><b>Primer Apellido</b> <span class="badge-warning">*</span></label>
                        <input type="text" placeholder="Primer Apellido" name="primer_apellido" required>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="segundo_apellido"><b>Segundo Apellido</b></label>
                        <input type="text" placeholder="Segundo Apellido (Opcional)" name="segundo_apellido">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="fexpedicion"><b>Fecha de Expedición</b></label>
                        <input type="date" name="fexpedicion">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="lexpedicion"><b>Lugar de Expedición</b></label>
                        <input type="text" name="lexpedicion">
                    </div>
                </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="cump"><b>Fecha de Nacimiento</b> <span class="badge-warning">*</span></label>
                        <input type="date" name="cump" required>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="gep"><b>Género</b> <span class="badge-warning">*</span></label>
                         <select required name="gep" id="gep">
                            <option value="">Seleccione</option>
                            <option value="MASCULINO">Masculino</option>
                            <option value="FEMENINO">Femenino</option>
                            <option value="LGBTIQ+">LGBTIQ+</option>
                            <option value="OTRO">Otro</option>
                        </select>
                    </div>
                </div>
                 <div class="form-group">
                    <label for="fotoperfil"><b>Foto de Perfil</b></label>
                    <input type="file" name="fotoperfil" id="fotoperfil" accept="image/*">
                    <br>
                    <img id="img-preview" src="#" alt="Vista previa" style="display:none; width: 150px; height: 150px; object-fit: cover; margin-top: 10px; border-radius: 50%; border: 3px solid #ddd;">
                </div>
                <hr>

                <!-- SECCIÓN 4: INFORMACIÓN DE CONTACTO -->
                 <h3><i class='bx bxs-phone'></i> Información de Contacto</h3>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="dip"><b>Dirección</b> <span class="badge-warning">*</span></label>
                        <input type="text" name="dip" required>
                    </div>
                     <div class="form-group" style="flex: 1;">
                        <label for="zona"><b>Zona</b> <span class="badge-warning">*</span></label>
                        <select required name="zona">
                            <option value="">Seleccione</option>
                            <option value="Urbano">Urbano</option>
                            <option value="Rural">Rural</option>
                            <option value="CentroP">Centro Poblado</option>
                        </select>
                    </div>
                </div>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                        <label for="barrio"><b>Barrio / Vereda</b></label>
                        <input type="text" name="barrio">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="telp"><b>Teléfono</b> <span class="badge-warning">*</span></label>
                        <input type="text" name="telp" required>
                    </div>
                 </div>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                         <label for="tiene_whatsapp"><b>¿Tiene WhatsApp?</b></label>
                        <select name="tiene_whatsapp">
                            <option value="SI">Sí</option>
                            <option value="NO" selected>No</option>
                        </select>
                     </div>
                     <div class="form-group" style="flex: 1;">
                        <label for="correo"><b>Correo Electrónico</b></label>
                        <input type="email" name="correo">
                     </div>
                 </div>
                 <hr>

                 <!-- SECCIÓN 5: INFORMACIÓN SOCIAL Y ACADÉMICA -->
                 <h3><i class='bx bxs-school'></i> Información Social y Académica</h3>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                      <div class="form-group" style="flex: 1;">
                        <label for="grp"><b>Grupo Sanguíneo</b></label>
                        <select name="grp">
                            <option value="">Seleccione</option>
                            <option value="A+">A+</option>
                            <option value="A-">A-</option>
                            <option value="B+">B+</option>
                            <option value="B-">B-</option>
                            <option value="AB+">AB+</option>
                            <option value="AB-">AB-</option>
                            <option value="O+">O+</option>
                            <option value="O-">O-</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="etnia"><b>Etnia</b></label>
                         <select name="etnia">
                            <option value="">Seleccione</option>
                            <option value="INDIGENA">INDIGENA</option>
                            <option value="AFROCOLOMBIANO">AFRO COLOMBIANO</option>
                            <option value="ROM-GITANO">ROM-GITANO</option>
                            <option value="PALENQUERO">PALENQUERO</option>
                            <option value="RAIZAL">RAIZAL</option>
                            <option value="NINGUNO">NINGUNO</option>
                        </select>
                    </div>
                 </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                        <label for="eps"><b>EPS</b></label>
                        <select name="eps">
                             <option value="">Seleccione</option>
                            <option value="SANITAS">SANITAS</option>
                            <option value="SALUD TOTAL">SALUD TOTAL</option>
                            <option value="Compensar">Compensar</option>
                            <option value="Nueva EPS">Nueva EPS</option>
                            <option value="Famisanar EPS">Famisanar EPS</option>
                            <option value="SISBEN">SISBEN</option>
                             <option value="OTRA">OTRA</option>
                        </select>
                     </div>
                      <div class="form-group" style="flex: 1;">
                         <label for="grupo_poblacional"><b>Grupo Poblacional</b></label>
                         <select name="grupo_poblacional">
                            <option value="Ninguno">Ninguno</option>
                            <option value="Víctima del conflicto armado">Víctima del conflicto armado</option>
                            <option value="Discapacidad">Discapacidad</option>
                            <option value="Indígena">Indígena</option>
                            <option value="Afrodescendiente">Afrodescendiente</option>
                            <option value="Otro">Otro</option>
                        </select>
                      </div>
                 </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="educacion"><b>Nivel Educativo</b></label>
                         <select name="educacion">
                            <option value="">Seleccione</option>
                            <option value="PRIMARIA">PRIMARIA</option>
                            <option value="SECUNDARIA">SECUNDARIA</option>
                            <option value="TECNICA">TECNICA</option>
                            <option value="SUPERIOR">SUPERIOR</option>
                            <option value="NINGUNO">NINGUNO</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="institucion_educativa"><b>Institución Educativa</b></label>
                        <input type="text" name="institucion_educativa" placeholder="Nombre Colegio/Institución">
                    </div>
                 </div>
                  <div class="form-group">
                        <label for="grado_actual"><b>Grado Actual</b></label>
                         <select name="grado_actual">
                            <option value="">Seleccione</option>
                            <option value="Preescolar">Preescolar</option>
                            <option value="Primero">Primero</option>
                            <option value="Segundo">Segundo</option>
                            <option value="Tercero">Tercero</option>
                            <option value="Cuarto">Cuarto</option>
                            <option value="Quinto">Quinto</option>
                            <option value="Sexto">Sexto</option>
                            <option value="Séptimo">Séptimo</option>
                            <option value="Octavo">Octavo</option>
                            <option value="Noveno">Noveno</option>
                            <option value="Décimo">Décimo</option>
                            <option value="Once">Once</option>
                            <option value="Técnico">Técnico</option>
                            <option value="Universitario">Universitario</option>
                            <option value="Otro">Otro</option>
                        </select>
                  </div>

                <hr>
                <hr>
                <!-- SECCIÓN 6: CARNET -->
                <h3><i class='bx bxs-id-card'></i> Carnetización</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap; align-items: center;">
                    <div class="form-group">
                        <label>Generar Carnet Digital</label>
                        <br>
                        <button type="button" class="btn-success" onclick="generarCarnet()" id="btnGenerarCarnet" style="padding: 10px 20px; background: #27ae60; color: white; border: none; border-radius: 5px; cursor: pointer; display: flex; align-items: center; gap: 10px;">
                            <i class='bx bx-id-card'></i> Generar y Descargar Carnet
                        </button>
                    </div>
                </div>
                
                <div id="qrCode" style="margin-top: 20px; display: none;"></div>
                <input type="hidden" id="qrInput">
                <hr>

                <div class="form-group" style="margin-top: 30px;">
                    <button type="submit" name="add_student_admin" class="registerbtn">Guardar Estudiante</button>
                </div>
            </form>
            </div>

        </main>
        
        <script>
            function validateForm() {
                var p1 = document.getElementById("password").value;
                var p2 = document.getElementById("confirm_password").value;
                if(p1 != p2) {
                    document.getElementById("passError").style.display = "block";
                    return false;
                }
                return true;
            }
        </script>
 

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
<?php include_once '../../backend/php/add_patiens.php' ?>

    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>

    <!-- Script para Barra de Progreso -->
    <style>
        .progress-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 20px;
            margin: 20px 0;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            color: white;
            transition: all 0.3s ease;
        }
        
        .progress-container.fixed {
            position: fixed;
            top: 70px;
            left: 280px;
            right: 20px;
            z-index: 1000;
            margin: 0;
            animation: slideDown 0.3s ease;
        }
        
        @keyframes slideDown {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .progress-placeholder {
            height: 0;
            transition: height 0.3s ease;
        }
        
        .progress-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .progress-title {
            font-size: 18px;
            font-weight: bold;
        }
        
        .progress-percentage {
            font-size: 28px;
            font-weight: bold;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }
        
        .progress-bar-bg {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 25px;
            height: 30px;
            overflow: hidden;
            position: relative;
        }
        
        .progress-bar-fill {
            background: linear-gradient(90deg, #27ae60, #2ecc71, #27ae60);
            background-size: 200% 100%;
            height: 100%;
            border-radius: 25px;
            transition: width 0.4s ease, background-position 0.3s ease;
            animation: shimmer 2s infinite;
            box-shadow: 0 2px 10px rgba(46, 204, 113, 0.5);
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding-right: 10px;
            width: 0%;
        }
        
        @keyframes shimmer {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        .progress-info {
            margin-top: 10px;
            text-align: center;
            font-size: 14px;
            opacity: 0.9;
        }
        
        .progress-bar-fill::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            animation: slide 2s infinite;
        }
        
        @keyframes slide {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
    </style>
    
    <script>
        // Script para actualizar la barra de progreso usando jQuery
        $(document).ready(function() {
            console.log('Iniciando barra de progreso...');
            
            // Variables para el scroll fijo
            var $progressContainer = $('.progress-container');
            var progressOffset = $progressContainer.offset().top;
            var progressHeight = $progressContainer.outerHeight();
            var isFixed = false;
            
            // Función para manejar el scroll
            $(window).scroll(function() {
                var scrollTop = $(window).scrollTop();
                
                if (scrollTop > progressOffset - 70 && !isFixed) {
                    // Fijar la barra
                    $progressContainer.addClass('fixed');
                    // Agregar placeholder para evitar saltos
                    $progressContainer.after('<div class="progress-placeholder" style="height:' + progressHeight + 'px"></div>');
                    isFixed = true;
                } else if (scrollTop <= progressOffset - 70 && isFixed) {
                    // Desfijar la barra
                    $progressContainer.removeClass('fixed');
                    $('.progress-placeholder').remove();
                    isFixed = false;
                }
            });
            
            var $form = $('form');
            var $progressBarFill = $('#progressBarFill');
            var $progressPercentage = $('#progressPercentage');
            var $fieldsCompletedSpan = $('#fieldsCompleted');
            var $totalFieldsSpan = $('#totalFields');
            
            // Obtener todos los campos requeridos excluyendo botones y el campo qrInput (que se genera automáticamente)
            var $requiredFields = $form.find('[required]').not('button, [type="submit"], [type="button"], #qrInput');
            var totalFields = $requiredFields.length;
            
            console.log('Total de campos requeridos:', totalFields);
            $totalFieldsSpan.text(totalFields);
            
            // Función para calcular el progreso
            function updateProgress() {
                var completedFields = 0;
                
                $requiredFields.each(function() {
                    var $field = $(this);
                    var fieldType = $field.attr('type');
                    var tagName = $field.prop('tagName');
                    
                    if (fieldType === 'checkbox' || fieldType === 'radio') {
                        // Para checkboxes y radios
                        if ($field.is(':checked')) {
                            completedFields++;
                        }
                    } else if (tagName === 'SELECT') {
                        // Para selects
                        var value = $field.val();
                        if (value && value !== 'Seleccione' && value.trim() !== '') {
                            completedFields++;
                        }
                    } else if (fieldType === 'file') {
                        // Para archivos
                        if ($field[0].files && $field[0].files.length > 0) {
                            completedFields++;
                        }
                    } else {
                        // Para inputs de texto, date, email, password, etc.
                        var value = $field.val();
                        if (value && value.trim() !== '') {
                            completedFields++;
                        }
                    }
                });
                
                // Calcular porcentaje
                var percentage = Math.round((completedFields / totalFields) * 100);
                
                console.log('Campos completados:', completedFields, 'de', totalFields, '(' + percentage + '%)');
                
                // Actualizar la UI
                $progressBarFill.css('width', percentage + '%');
                $progressPercentage.text(percentage + '%');
                $fieldsCompletedSpan.text(completedFields);
                
                // Cambiar color según el progreso
                if (percentage < 30) {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #e74c3c, #c0392b)');
                } else if (percentage < 70) {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #f39c12, #e67e22)');
                } else {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #27ae60, #2ecc71)');
                }
            }
            
            // Agregar listeners a todos los campos usando delegación de eventos
            $form.on('input change', '[required]', function() {
                updateProgress();
            });
            
            // También escuchar blur para asegurar que se actualice
            $form.on('blur', '[required]', function() {
                updateProgress();
            });
            
            // Calcular progreso inicial
            setTimeout(function() {
                updateProgress();
            }, 500);
            
            console.log('Barra de progreso inicializada correctamente');
        });
    </script>
    

    <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie and expiry time=1 minute
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>


<!-- Script para previsualizar la imagen -->
<script>
document.getElementById('fotoperfil').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('img-preview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    } else {
        preview.style.display = 'none';
    }
});
</script>




<!-- Script de generación Carnet Unificado -->
<script>
    async function generarCarnet() {
        const btn = document.getElementById('btnGenerarCarnet');
        const originalText = btn.innerHTML;
        
        try {
            // 1. Obtener y validar datos
            const nombre = (document.querySelector('input[name="primer_nombre"]').value + ' ' + document.querySelector('input[name="segundo_nombre"]').value).trim();
            const apellido = (document.querySelector('input[name="primer_apellido"]').value + ' ' + document.querySelector('input[name="segundo_apellido"]').value).trim();
            const documento = document.querySelector('input[name="nhi"]').value;
            const tipoDoc = document.querySelector('select[name="tdocumento"]').value;
            const modalidad = document.querySelector('select[name="grado_actual"]')?.value || 'N/A';
            const imgPreview = document.getElementById('img-preview');
            const fotoInput = document.getElementById('fotoperfil');

            if (!documento || !nombre || !apellido || !tipoDoc) {
                alert("Por favor complete toda la información personal (Nombre, Apellido, Documento) antes de generar el carnet.");
                return;
            }

            // Cambiar estado del botón
            btn.innerHTML = "<i class='bx bx-loader-alt bx-spin'></i> Generando...";
            btn.disabled = true;

            // 2. Generar QR
            const qrUrl = await new Promise((resolve, reject) => {
                QRCode.toDataURL(documento, {
                    width: 150,
                    margin: 1,
                    color: { dark: "#000000", light: "#FFFFFF" }
                }, (err, url) => err ? reject(err) : resolve(url));
            });

            // 3. Cargar imágenes
            const loadImage = (src) => new Promise((resolve, reject) => {
                const img = new Image();
                img.crossOrigin = 'anonymous';
                img.onload = () => resolve(img);
                img.onerror = () => reject(new Error(`Error cargando imagen: ${src}`));
                img.src = src;
            });

            const [carnetFrontal, carnetPosterior, qrImg] = await Promise.all([
                loadImage('../../backend/img/1-carnet.jpg'),
                loadImage('../../backend/img/2-carnet2.jpg'),
                loadImage(qrUrl)
            ]);

            // 4. Preparar canvas frontal
            const canvasFront = document.createElement('canvas');
            const ctxFront = canvasFront.getContext('2d');
            canvasFront.width = carnetFrontal.width;
            canvasFront.height = carnetFrontal.height;
            ctxFront.drawImage(carnetFrontal, 0, 0);

            // 5. Procesar foto usuario
            let fotoUsuario = null;
            try {
                let fotoSrc = '../../backend/img/foto-perfil.png'; // Default
                if (fotoInput?.files?.[0]) {
                    fotoSrc = await new Promise(r => {
                        const reader = new FileReader();
                        reader.onload = e => r(e.target.result);
                        reader.readAsDataURL(fotoInput.files[0]);
                    });
                } else if (imgPreview?.src && imgPreview.style.display !== 'none') {
                    fotoSrc = imgPreview.src;
                }
                fotoUsuario = await loadImage(fotoSrc);
            } catch (e) {
                console.warn("Usando foto por defecto", e);
                fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
            }

            if (fotoUsuario) {
                const targetW = 175, targetH = 175;
                const centerX = canvasFront.width / 2;
                const centerY = 215;
                
                // Calcular dimensiones manteniendo aspecto
                const ratio = fotoUsuario.width / fotoUsuario.height;
                let drawW = targetW, drawH = targetH;
                
                if (ratio > 1) { // Más ancha
                    drawW = targetH * ratio;
                    if (drawW > targetW) { drawW = targetW; drawH = drawW / ratio; }
                } else { // Más alta
                    drawH = targetW / ratio;
                    if (drawH > targetH) { drawH = targetH; drawW = drawH * ratio; }
                }
                
                ctxFront.save();
                ctxFront.beginPath();
                ctxFront.arc(centerX, centerY, targetW/2, 0, Math.PI * 2);
                ctxFront.closePath();
                ctxFront.clip();
                ctxFront.drawImage(fotoUsuario, centerX - drawW/2, centerY - drawH/2, drawW, drawH);
                ctxFront.restore();
            }

            // 6. Dibujar Texto
            const drawText = (text, y, fontSize = 16) => {
                ctxFront.font = `bold ${fontSize}px Arial`;
                ctxFront.fillStyle = '#000000';
                ctxFront.textAlign = 'center';
                ctxFront.fillText(text.toUpperCase(), canvasFront.width / 2, y);
            };

            const nombreCompleto = `${nombre} ${apellido}`;
            let nombreY = 340;
            // Manejo simplificado de nombre largo
            if (nombreCompleto.length > 25) {
                const words = nombreCompleto.split(' ');
                const mid = Math.ceil(words.length / 2);
                drawText(words.slice(0, mid).join(' '), nombreY, 16);
                drawText(words.slice(mid).join(' '), nombreY + 20, 16);
                nombreY += 20;
            } else {
                drawText(nombreCompleto, nombreY, 18);
            }

            drawText(`${tipoDoc}: ${documento}`, nombreY + 30, 16);
            drawText(modalidad, nombreY + 55, 14);

            // 7. Preparar canvas posterior
            const canvasBack = document.createElement('canvas');
            const ctxBack = canvasBack.getContext('2d');
            canvasBack.width = carnetPosterior.width;
            canvasBack.height = carnetPosterior.height;
            ctxBack.drawImage(carnetPosterior, 0, 0);

            // Dibujar QR
            const qrSize = 180;
            const qrX = (canvasBack.width - qrSize) / 2;
            const qrY = (canvasBack.height - qrSize) / 2 - 50;
            ctxBack.drawImage(qrImg, qrX, qrY, qrSize, qrSize);

            // 8. Combinar y Descargar
            const finalCanvas = document.createElement('canvas');
            const ctxFinal = finalCanvas.getContext('2d');
            finalCanvas.width = canvasFront.width;
            finalCanvas.height = canvasFront.height * 2 + 20;
            
            ctxFinal.drawImage(canvasFront, 0, 0);
            ctxFinal.drawImage(canvasBack, 0, canvasFront.height + 20);

            const link = document.createElement('a');
            link.download = `Carnet_${documento}.png`;
            link.href = finalCanvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

        } catch (error) {
            console.error(error);
            alert('Error generando el carnet: ' + error.message);
        } finally {
            btn.innerHTML = originalText;
            btn.disabled = false;
        }
    }
</script>

<style>
/* Convertir texto de todos los select a mayúsculas */
select, select option {
    text-transform: uppercase;
}
</style>

</body>
</html>
