<?php
ob_start();
session_start();

// Incluir sistema de control de acceso
require '../../backend/php/check_access.php';

// Verificar acceso - Solo Profesores (Rol 3)
checkAccess([4]);

require '../../backend/bd/Conexion.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <title>Dashboard Profesor | Programa Persona Mayor</title>
</head>
<body>
    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Buscar...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Salir</a></li>
                </ul>
            </div>
        </nav>

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido, <?php echo '<strong>'.htmlspecialchars($_SESSION['name']).'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="dashboard_profesor.php">Home</a></li>
                <li class="divider">/</li>
                <li><a href="#" class="active">Dashboard Profesor</a></li>
            </ul>

            <!-- Dashboard Content -->
            <div class="info-data">
                <div class="card">
                    <div class="head">
                        <div>
                            <h2>Rol: Profesor</h2>
                            <p>Panel de Control</p>
                        </div>
                        <i class='bx bx-user-circle icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            $totalCursos = $connect->query("SELECT COUNT(*) FROM cursos")->fetchColumn();
                            ?>
                            <h2><?php echo $totalCursos; ?></h2>
                            <p>Cursos Registrados</p>
                        </div>
                        <i class='bx bx-book icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            $totalAsistencias = $connect->query("SELECT COUNT(*) FROM asistencia_qr WHERE DATE(fecha) = CURDATE()")->fetchColumn();
                            ?>
                            <h2><?php echo $totalAsistencias; ?></h2>
                            <p>Asistencias Hoy</p>
                        </div>
                        <i class='bx bx-check-circle icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            $totalUsuarios = $connect->query("SELECT COUNT(*) FROM patients")->fetchColumn();
                            ?>
                            <h2><?php echo $totalUsuarios; ?></h2>
                            <p>Usuarios Totales</p>
                        </div>
                        <i class='bx bx-group icon'></i>
                    </div>
                </div>
            </div>

        </main>
    </section>

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
</body>
</html>
