<?php
    ob_start();
    session_start();
    
    // Verificar que sea un ciudadano con sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Solo ciudadanos (rol 3) pueden acceder
    if($_SESSION['rol'] != 3) {
        header('location: ../acceso_denegado.php');
        exit();
    }
    
    require '../../backend/bd/Conexion.php';
    
    // Obtener ID del paciente asociado al ciudadano
    $userId = $_SESSION['id'];
    $stmt = $connect->prepare("SELECT idpa FROM patients WHERE user_id = ?");
    $stmt->execute([$userId]);
    $patient = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$patient) {
        die("No se encontró información del paciente");
    }
    
    $patientId = $patient['idpa'];
    
    // Obtener información del paciente
    $stmtInfo = $connect->prepare("SELECT * FROM patients WHERE idpa = ?");
    $stmtInfo->execute([$patientId]);
    $patientInfo = $stmtInfo->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Mis Documentos</title>
    <style>
        .documentos-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .documento-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }
        
        .documento-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        
        .upload-area {
            border: 2px dashed #667eea;
            border-radius: 12px;
            padding: 40px;
            text-align: center;
            background: #f8f9fa;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .upload-area:hover {
            background: #e9ecef;
            border-color: #764ba2;
        }
        
        .upload-area i {
            font-size: 48px;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .btn-upload {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-upload:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }
        
        .documento-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
            margin-bottom: 10px;
        }
        
        .documento-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .documento-icon {
            font-size: 32px;
            color: #667eea;
        }
        
        .documento-actions {
            display: flex;
            gap: 10px;
        }
        
        .btn-action {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.2s;
        }
        
        .btn-view {
            background: #28a745;
            color: white;
        }
        
        .btn-delete {
            background: #dc3545;
            color: white;
        }
        
        .btn-action:hover {
            transform: scale(1.05);
        }
        
        .info-banner {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <!-- SIDEBAR -->
    <section id="sidebar">
        <a href="mostrar.php" class="brand"><i class='bx bxs-smile icon'></i> Mi Perfil</a>
        <ul class="side-menu">
            <li><a href="mostrar.php"><i class='bx bxs-user-circle icon'></i> Mi Información</a></li>
            <li><a href="documentos.php" class="active"><i class='bx bxs-file icon'></i> Mis Documentos</a></li>
            <li class="divider" data-text="Acciones"></li>
            <li><a href="../salir.php"><i class='bx bxs-log-out-circle icon'></i> Cerrar Sesión</a></li>
        </ul>
    </section>
    <!-- SIDEBAR -->

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Cerrar Sesión</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main>
            <h1 class="title">Mis Documentos</h1>
            <ul class="breadcrumbs">
                <li><a href="mostrar.php">Mi Perfil</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Documentos</a></li>
            </ul>

            <div class="documentos-container">
                <!-- Mensajes de éxito/error -->
                <?php if(isset($_SESSION['success'])): ?>
                    <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #28a745;">
                        <strong>✓ Éxito:</strong> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                    </div>
                <?php endif; ?>
                
                <?php if(isset($_SESSION['error'])): ?>
                    <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #dc3545;">
                        <strong>✗ Error:</strong> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                    </div>
                <?php endif; ?>
                
                <!-- Banner informativo -->
                <div class="info-banner">
                    <h2 style="margin: 0 0 10px 0;">📄 Gestiona tus Documentos</h2>
                    <p style="margin: 0;">Aquí puedes cargar y administrar tus documentos personales. Los archivos permitidos son: PDF, JPG, PNG (máximo 5MB)</p>
                </div>

                <!-- Área de carga -->
                <div class="documento-card">
                    <h3 style="margin-bottom: 20px;">📤 Cargar Nuevo Documento</h3>
                    <form action="../../backend/php/upload_documento_ciudadano.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="patient_id" value="<?php echo $patientId; ?>">
                        
                        <div class="upload-area" onclick="document.getElementById('fileInput').click()">
                            <i class='bx bx-cloud-upload'></i>
                            <h3>Haz clic para seleccionar un archivo</h3>
                            <p>o arrastra y suelta aquí</p>
                            <input type="file" id="fileInput" name="documento" accept=".pdf,.jpg,.jpeg,.png" style="display: none;" required>
                        </div>
                        
                        <div style="margin-top: 20px;">
                            <label style="display: block; margin-bottom: 10px; font-weight: 600;">Tipo de Documento:</label>
                            <select name="tipo_documento" required style="width: 100%; padding: 12px; border: 2px solid #e8e8e8; border-radius: 8px; font-size: 14px;">
                                <option value="">Seleccionar tipo...</option>
                                <option value="Cédula">Cédula de Ciudadanía</option>
                                <option value="Carnet EPS">Carnet EPS</option>
                                <option value="Historia EFAC">Historia EFAC</option>
                                <option value="Exámenes">Exámenes Médicos</option>
                                <option value="Receta Médica">Receta Médica</option>
                                <option value="Otro">Otro</option>
                            </select>
                        </div>
                        
                        <div style="margin-top: 20px;">
                            <label style="display: block; margin-bottom: 10px; font-weight: 600;">Descripción (opcional):</label>
                            <textarea name="descripcion" rows="3" placeholder="Agrega una descripción del documento..." style="width: 100%; padding: 12px; border: 2px solid #e8e8e8; border-radius: 8px; font-size: 14px; resize: vertical;"></textarea>
                        </div>
                        
                        <button type="submit" class="btn-upload" style="margin-top: 20px;">
                            <i class='bx bx-upload'></i> Subir Documento
                        </button>
                    </form>
                </div>

                <!-- Lista de documentos -->
                <div class="documento-card">
                    <h3 style="margin-bottom: 20px;">📋 Mis Documentos Cargados</h3>
                    
                    <?php
                    // Obtener documentos del paciente
                    $stmtDocs = $connect->prepare("SELECT * FROM patient_documents WHERE patient_id = ? ORDER BY upload_date DESC");
                    $stmtDocs->execute([$patientId]);
                    $documentos = $stmtDocs->fetchAll(PDO::FETCH_ASSOC);
                    
                    if(count($documentos) > 0):
                        foreach($documentos as $doc):
                    ?>
                        <div class="documento-item">
                            <div class="documento-info">
                                <i class='bx bxs-file-pdf documento-icon'></i>
                                <div>
                                    <h4 style="margin: 0 0 5px 0;"><?php echo htmlspecialchars($doc['tipo_documento']); ?></h4>
                                    <p style="margin: 0; color: #666; font-size: 14px;">
                                        <?php echo htmlspecialchars($doc['descripcion'] ?? 'Sin descripción'); ?>
                                    </p>
                                    <p style="margin: 5px 0 0 0; color: #999; font-size: 12px;">
                                        Subido el <?php echo date('d/m/Y H:i', strtotime($doc['upload_date'])); ?>
                                    </p>
                                </div>
                            </div>
                            <div class="documento-actions">
                                <a href="../../uploads/documentos/<?php echo $doc['file_name']; ?>" target="_blank" class="btn-action btn-view">
                                    <i class='bx bx-show'></i> Ver
                                </a>
                                <button onclick="eliminarDocumento(<?php echo $doc['id']; ?>)" class="btn-action btn-delete">
                                    <i class='bx bx-trash'></i> Eliminar
                                </button>
                            </div>
                        </div>
                    <?php 
                        endforeach;
                    else:
                    ?>
                        <div style="text-align: center; padding: 40px; color: #999;">
                            <i class='bx bx-folder-open' style="font-size: 64px; margin-bottom: 15px;"></i>
                            <p>No tienes documentos cargados aún</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
        <!-- MAIN -->
    </section>

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script>
        // Preview del archivo seleccionado
        document.getElementById('fileInput').addEventListener('change', function(e) {
            const fileName = e.target.files[0]?.name;
            if(fileName) {
                document.querySelector('.upload-area h3').textContent = 'Archivo seleccionado: ' + fileName;
            }
        });
        
        // Función para eliminar documento
        function eliminarDocumento(docId) {
            if(confirm('¿Estás seguro de que deseas eliminar este documento?')) {
                window.location.href = '../../backend/php/delete_documento_ciudadano.php?id=' + docId;
            }
        }
    </script>
</body>
</html>
