<?php
require_once('backend/bd/Conexion.php');
global $connect;

$columns_to_add = [
    'fecha_expedicion' => "DATE NULL",
    'lugar_expedicion' => "VARCHAR(100) NULL",
    'sexo' => "VARCHAR(20) NULL",
    'estado_civil' => "VARCHAR(50) NULL",
    'tiene_whatsapp' => "VARCHAR(5) DEFAULT 'NO'",
    'zona' => "VARCHAR(50) NULL",
    'sisben' => "VARCHAR(10) NULL",
    'recibe_bono' => "VARCHAR(5) NULL",
    'pensionado' => "VARCHAR(5) NULL",
    'talla_sudadera' => "VARCHAR(10) NULL",
    'talla_chaqueta' => "VARCHAR(10) NULL",
    'talla_zapatos' => "VARCHAR(10) NULL",
    'talento_fortaleza' => "VARCHAR(255) NULL",
    'observacion_salida' => "TEXT NULL",
    'vive_con' => "VARCHAR(100) NULL",
    'red_apoyo' => "VARCHAR(5) NULL",
    'nombre_cuidador' => "VARCHAR(100) NULL",
    'parentesco_cuidador' => "VARCHAR(50) NULL",
    'zona_cuidador' => "VARCHAR(50) NULL",
    'barrio_cuidador' => "VARCHAR(100) NULL",
    'direccion_cuidador' => "VARCHAR(255) NULL",
    'telefono_cuidador' => "VARCHAR(50) NULL",
    'sgsss' => "VARCHAR(50) NULL",
    'eps' => "VARCHAR(100) NULL",
    'etnia' => "VARCHAR(50) NULL",
    'nivel_educativo' => "VARCHAR(50) NULL",
    'sabe_leer_escribir' => "VARCHAR(5) DEFAULT 'SI'",
    'uso_tecnologia' => "VARCHAR(5) NULL",
    'grupo_poblacional' => "VARCHAR(100) NULL",
    'poblacion_oficio' => "VARCHAR(100) NULL"
];

echo "<h2>Iniciando migración de base de datos...</h2>";

foreach ($columns_to_add as $column => $definition) {
    try {
        $check = $connect->query("SHOW COLUMNS FROM registro_estudiantes LIKE '$column'");
        if ($check->rowCount() == 0) {
            $connect->exec("ALTER TABLE registro_estudiantes ADD $column $definition");
            echo "<p style='color: green;'>✅ Columna '$column' agregada correctamente.</p>";
        } else {
            echo "<p style='color: blue;'>ℹ️ La columna '$column' ya existe.</p>";
        }
    } catch (PDOException $e) {
        echo "<p style='color: red;'>❌ Error al agregar '$column': " . $e->getMessage() . "</p>";
    }
}

echo "<h3>Migración finalizada.</h3>";
?>
