<?php
// update_cursos_schema.php
require 'backend/bd/Conexion.php';

try {
    $sql = "ALTER TABLE cursos ADD COLUMN codigo VARCHAR(50) NULL AFTER idcurso";
    // Using simple query logic to check if column exists would be better, but for this quick task:
    // We'll try to add it, if it fails it likely exists.
    // Or we can be robust:
    
    $stmt = $connect->prepare("SHOW COLUMNS FROM cursos LIKE 'codigo'");
    $stmt->execute();
    
    if ($stmt->rowCount() == 0) {
        $connect->exec($sql);
        echo "✅ Columna 'codigo' agregada a tabla 'cursos'.";
    } else {
        echo "ℹ️ La columna 'codigo' ya existe en 'cursos'.";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
