<?php
session_start();
require_once('backend/bd/Conexion.php');
global $connect;

echo "<h1>Inscripciones a Cursos</h1>";

try {
    // Obtener todas las inscripciones con información del curso y paciente
    $stmt = $connect->prepare("
        SELECT 
            i.idins,
            i.documento,
            i.idcurso,
            i.fecha_inscripcion,
            i.state,
            c.nombre as nombre_curso,
            c.quien_lo_da as profesor,
            c.es_titulado,
            p.nompa,
            p.apepa
        FROM inscripciones i
        LEFT JOIN cursos c ON i.idcurso = c.idcurso
        LEFT JOIN patients p ON i.documento = p.numhs
        ORDER BY i.idins DESC
        LIMIT 20
    ");
    $stmt->execute();
    $inscripciones = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if(count($inscripciones) > 0) {
        echo "<h2 style='color: green;'>Total de inscripciones: " . count($inscripciones) . "</h2>";
        
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%; background: white;'>";
        echo "<tr style='background: #667eea; color: white;'>
                <th>ID</th>
                <th>Documento</th>
                <th>Nombre Ciudadano</th>
                <th>Curso</th>
                <th>Profesor</th>
                <th>Titulado</th>
                <th>Fecha Inscripción</th>
                <th>Estado</th>
              </tr>";
        
        foreach($inscripciones as $ins) {
            $estadoColor = $ins['state'] == '1' ? '#28a745' : '#dc3545';
            $estadoTexto = $ins['state'] == '1' ? 'Activo' : 'Inactivo';
            
            echo "<tr>";
            echo "<td>" . $ins['idins'] . "</td>";
            echo "<td><strong>" . $ins['documento'] . "</strong></td>";
            echo "<td>" . ($ins['nompa'] ?? 'N/A') . " " . ($ins['apepa'] ?? '') . "</td>";
            echo "<td><strong>" . ($ins['nombre_curso'] ?? 'N/A') . "</strong></td>";
            echo "<td>" . ($ins['profesor'] ?? 'N/A') . "</td>";
            echo "<td>" . ($ins['es_titulado'] ?? 'N/A') . "</td>";
            echo "<td>" . $ins['fecha_inscripcion'] . "</td>";
            echo "<td style='color: $estadoColor; font-weight: bold;'>$estadoTexto</td>";
            echo "</tr>";
        }
        
        echo "</table>";
        
        // Contar total
        $stmtCount = $connect->query("SELECT COUNT(*) as total FROM inscripciones");
        $total = $stmtCount->fetch(PDO::FETCH_ASSOC);
        echo "<h3 style='color: blue;'>Total de inscripciones en la base de datos: " . $total['total'] . "</h3>";
        
    } else {
        echo "<p style='color: red; font-size: 20px;'>No hay inscripciones registradas.</p>";
    }
    
    // Mostrar estructura de la tabla
    echo "<hr>";
    echo "<h2>Estructura de la tabla inscripciones</h2>";
    $stmt2 = $connect->query("DESCRIBE inscripciones");
    $columnas = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; background: white;'>";
    echo "<tr style='background: #764ba2; color: white;'>
            <th>Campo</th>
            <th>Tipo</th>
            <th>Null</th>
            <th>Key</th>
            <th>Default</th>
          </tr>";
    
    foreach($columnas as $col) {
        echo "<tr>";
        echo "<td>" . $col['Field'] . "</td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
        background: #f5f5f5;
    }
    table {
        margin: 20px 0;
    }
    tr:nth-child(even) {
        background: #f9f9f9;
    }
</style>
