<?php
require 'backend/bd/Conexion.php';

echo "<h2>Verificar Permisos de RABIT</h2>";

$userId = 24; // ID de RABIT

$stmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
$stmt->execute([$userId]);
$permisos = $stmt->fetch(PDO::FETCH_ASSOC);

if($permisos) {
    echo "<div style='background: #e6f7ee; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h3 style='color: #155724;'>✅ Permisos encontrados para RABIT (ID: $userId)</h3>";
    echo "</div>";
    
    echo "<h3>Permisos de Historia EFAC:</h3>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #667eea; color: white;'>";
    echo "<th>Permiso</th><th>Valor</th><th>Estado</th>";
    echo "</tr>";
    
    $permisosHistoria = [
        'historia_riesgo_social_ver',
        'historia_riesgo_social_modificar',
        'historia_salud_oral_ver',
        'historia_salud_oral_modificar',
        'historia_salud_mental_ver',
        'historia_salud_mental_modificar',
        'historia_medicamentos_ver',
        'historia_medicamentos_modificar',
        'historia_signos_vitales_ver',
        'historia_signos_vitales_modificar',
        'historia_diagnostico_ver',
        'historia_diagnostico_modificar',
        'historia_antecedentes_ver',
        'historia_antecedentes_modificar',
        'historia_examenes_ver',
        'historia_examenes_modificar',
        'historia_fisioterapia_ver',
        'historia_fisioterapia_modificar'
    ];
    
    foreach($permisosHistoria as $perm) {
        $valor = isset($permisos[$perm]) ? $permisos[$perm] : 'NO EXISTE';
        $estado = $valor === 1 ? '✅ HABILITADO' : ($valor === 0 ? '❌ DESHABILITADO' : '⚠️ COLUMNA NO EXISTE');
        $color = $valor === 1 ? '#d4edda' : ($valor === 0 ? '#f8d7da' : '#fff3cd');
        
        echo "<tr style='background: $color;'>";
        echo "<td><strong>$perm</strong></td>";
        echo "<td>$valor</td>";
        echo "<td>$estado</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<h3 style='margin-top: 30px;'>Todos los permisos:</h3>";
    echo "<pre>";
    print_r($permisos);
    echo "</pre>";
    
} else {
    echo "<div style='background: #f8d7da; padding: 20px; border-radius: 8px;'>";
    echo "<h3 style='color: #721c24;'>❌ No se encontraron permisos para RABIT</h3>";
    echo "</div>";
}

echo "<div style='margin-top: 20px;'>";
echo "<a href='frontend/medicos/editar_menu.php?id=24' style='padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Editar Permisos de RABIT</a>";
echo "</div>";
?>
