<?php
/**
 * Script para actualizar automáticamente los enlaces al dashboard
 * Reemplaza ../admin/escritorio.php por ../dashboard.php en archivos del frontend
 * Ejecutar desde: http://localhost/hogar_abuelos/actualizar_enlaces_dashboard.php
 */

set_time_limit(300); // 5 minutos

echo "<!DOCTYPE html>";
echo "<html><head>";
echo "<meta charset='UTF-8'>";
echo "<style>
    body { font-family: Arial; padding: 20px; background: #f5f5f5; }
    .container { max-width: 1200px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    h1 { color: #667eea; border-bottom: 3px solid #667eea; padding-bottom: 10px; }
    h2 { color: #764ba2; margin-top: 30px; }
    .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #28a745; }
    .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #dc3545; }
    .warning { background: #fff3cd; color: #856404; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #ffc107; }
    .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #17a2b8; }
    .file-list { max-height: 400px; overflow-y: auto; background: #f8f9fa; padding: 15px; border-radius: 6px; margin: 10px 0; }
    .file-item { padding: 8px; border-bottom: 1px solid #dee2e6; font-family: monospace; font-size: 13px; }
    table { width: 100%; border-collapse: collapse; margin: 15px 0; }
    th { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px; text-align: left; }
    td { padding: 10px; border-bottom: 1px solid #ddd; }
    tr:hover { background: #f8f9fc; }
    .btn { display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 6px; margin: 5px; }
    .btn:hover { background: #764ba2; }
    code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; font-family: monospace; }
    .progress { background: #e9ecef; border-radius: 4px; height: 30px; margin: 20px 0; }
    .progress-bar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); height: 100%; border-radius: 4px; text-align: center; line-height: 30px; color: white; font-weight: bold; transition: width 0.3s; }
</style>";
echo "</head><body>";
echo "<div class='container'>";

echo "<h1>🔄 Actualizar Enlaces de Dashboard</h1>";

// Directorios a procesar
$directorios = [
    'frontend/pacientes',
    'frontend/medicos',
    'frontend/citas',
    'frontend/cursos',
    'frontend/recursos',
    'frontend/ajustes',
    'frontend/asistencia',
    'frontend/profile',
    'frontend/actividades',
    'frontend/acerca'
];

// Archivos a excluir
$excluidos = [
    'frontend/admin/escritorio.php',
    'frontend/dashboard.php',
    'frontend/login.php'
];

$totalArchivos = 0;
$archivosModificados = 0;
$reemplazosRealizados = 0;
$errores = [];
$detalles = [];

// Función recursiva para obtener archivos PHP
function obtenerArchivos($directorio, &$archivos = []) {
    if (!is_dir($directorio)) return $archivos;
    
    $items = scandir($directorio);
    foreach ($items as $item) {
        if ($item == '.' || $item == '..') continue;
        
        $ruta = $directorio . '/' . $item;
        if (is_dir($ruta)) {
            obtenerArchivos($ruta, $archivos);
        } elseif (pathinfo($ruta, PATHINFO_EXTENSION) === 'php') {
            $archivos[] = $ruta;
        }
    }
    return $archivos;
}

echo "<h2>1. Escaneando Directorios</h2>";
echo "<div class='info'>";
echo "<p>Buscando archivos PHP en los siguientes directorios:</p>";
echo "<ul>";
foreach ($directorios as $dir) {
    echo "<li><code>$dir</code></li>";
}
echo "</ul>";
echo "</div>";

// Recopilar todos los archivos
$archivos = [];
foreach ($directorios as $dir) {
    if (is_dir($dir)) {
        obtenerArchivos($dir, $archivos);
    }
}

$totalArchivos = count($archivos);

echo "<div class='success'>";
echo "✅ Encontrados <strong>$totalArchivos</strong> archivos PHP para procesar";
echo "</div>";

echo "<h2>2. Procesando Archivos</h2>";

foreach ($archivos as $archivo) {
    // Verificar si está excluido
    $esExcluido = false;
    foreach ($excluidos as $excluido) {
        if (strpos($archivo, str_replace('/', DIRECTORY_SEPARATOR, $excluido)) !== false) {
            $esExcluido = true;
            break;
        }
    }
    
    if ($esExcluido) {
        $detalles[] = [
            'archivo' => $archivo,
            'estado' => 'excluido',
            'reemplazos' => 0
        ];
        continue;
    }
    
    // Leer contenido del archivo
    $contenidoOriginal = file_get_contents($archivo);
    if ($contenidoOriginal === false) {
        $errores[] = "No se pudo leer: $archivo";
        continue;
    }
    
    // Realizar reemplazos
    $contenidoNuevo = $contenidoOriginal;
    $reemplazosEnArchivo = 0;
    
    // Reemplazo 1: ../admin/escritorio.php → ../dashboard.php
    $temp = str_replace('../admin/escritorio.php', '../dashboard.php', $contenidoNuevo, $count1);
    $reemplazosEnArchivo += $count1;
    $contenidoNuevo = $temp;
    
    // Reemplazo 2: admin/escritorio.php → dashboard.php (para casos sin ../)
    $temp = str_replace('admin/escritorio.php', 'dashboard.php', $contenidoNuevo, $count2);
    $reemplazosEnArchivo += $count2;
    $contenidoNuevo = $temp;
    
    // Si hubo cambios, guardar el archivo
    if ($contenidoNuevo !== $contenidoOriginal) {
        if (file_put_contents($archivo, $contenidoNuevo) !== false) {
            $archivosModificados++;
            $reemplazosRealizados += $reemplazosEnArchivo;
            $detalles[] = [
                'archivo' => $archivo,
                'estado' => 'modificado',
                'reemplazos' => $reemplazosEnArchivo
            ];
        } else {
            $errores[] = "No se pudo escribir: $archivo";
            $detalles[] = [
                'archivo' => $archivo,
                'estado' => 'error',
                'reemplazos' => 0
            ];
        }
    } else {
        $detalles[] = [
            'archivo' => $archivo,
            'estado' => 'sin cambios',
            'reemplazos' => 0
        ];
    }
}

// Calcular progreso
$porcentaje = $totalArchivos > 0 ? round(($archivosModificados / $totalArchivos) * 100) : 0;

echo "<div class='progress'>";
echo "<div class='progress-bar' style='width: $porcentaje%;'>$porcentaje%</div>";
echo "</div>";

echo "<h2>3. Resumen de Resultados</h2>";

echo "<table>";
echo "<tr><th>Métrica</th><th>Valor</th></tr>";
echo "<tr><td>Archivos procesados</td><td><strong>$totalArchivos</strong></td></tr>";
echo "<tr><td>Archivos modificados</td><td><strong style='color: #28a745;'>$archivosModificados</strong></td></tr>";
echo "<tr><td>Reemplazos realizados</td><td><strong style='color: #667eea;'>$reemplazosRealizados</strong></td></tr>";
echo "<tr><td>Errores</td><td><strong style='color: #dc3545;'>" . count($errores) . "</strong></td></tr>";
echo "</table>";

if ($archivosModificados > 0) {
    echo "<div class='success'>";
    echo "<h3>🎉 ¡Actualización Completada!</h3>";
    echo "<p><strong>$archivosModificados</strong> archivos fueron actualizados exitosamente.</p>";
    echo "<p><strong>$reemplazosRealizados</strong> reemplazos de enlaces al dashboard.</p>";
    echo "</div>";
}

// Mostrar errores si los hay
if (count($errores) > 0) {
    echo "<h2>⚠️ Errores Encontrados</h2>";
    echo "<div class='error'>";
    foreach ($errores as $error) {
        echo "<p>$error</p>";
    }
    echo "</div>";
}

// Detalles de archivos modificados
$modificados = array_filter($detalles, function($d) { return $d['estado'] === 'modificado'; });
if (count($modificados) > 0) {
    echo "<h2>✅ Archivos Modificados (" . count($modificados) . ")</h2>";
    echo "<div class='file-list'>";
    echo "<table style='width: 100%;'>";
    echo "<tr><th>Archivo</th><th>Reemplazos</th></tr>";
    foreach ($modificados as $detalle) {
        echo "<tr>";
        echo "<td><code>" . htmlspecialchars($detalle['archivo']) . "</code></td>";
        echo "<td style='text-align: center;'><strong>" . $detalle['reemplazos'] . "</strong></td>";
        echo "</tr>";
    }
    echo "</table>";
    echo "</div>";
}

// Archivos sin cambios
$sinCambios = array_filter($detalles, function($d) { return $d['estado'] === 'sin cambios'; });
if (count($sinCambios) > 0) {
    echo "<h2>ℹ️ Archivos Sin Cambios (" . count($sinCambios) . ")</h2>";
    echo "<div class='info'>";
    echo "<p>Estos archivos ya estaban actualizados o no contenían enlaces al dashboard antiguo.</p>";
    echo "<div class='file-list'>";
    foreach (array_slice($sinCambios, 0, 20) as $detalle) {
        echo "<div class='file-item'>" . htmlspecialchars($detalle['archivo']) . "</div>";
    }
    if (count($sinCambios) > 20) {
        echo "<div class='file-item'>... y " . (count($sinCambios) - 20) . " más</div>";
    }
    echo "</div>";
    echo "</div>";
}

echo "<div style='margin-top: 30px; text-align: center;'>";
echo "<a href='frontend/dashboard.php' class='btn'>Ir al Dashboard</a>";
echo "<a href='debug_permisos_enfermeria.php' class='btn' style='background: #17a2b8;'>Ver Debug de Permisos</a>";
echo "<a href='actualizar_enlaces_dashboard.php' class='btn' style='background: #6c757d;'>Ejecutar Nuevamente</a>";
echo "</div>";

echo "<div style='margin-top: 30px; padding: 20px; background: #f8f9fc; border-radius: 8px;'>";
echo "<h3>📋 Próximos Pasos</h3>";
echo "<ol>";
echo "<li><strong>Prueba el sistema:</strong> Inicia sesión con un usuario de enfermería y verifica que el dashboard funcione</li>";
echo "<li><strong>Verifica los enlaces:</strong> Haz clic en 'Dashboard', el logo, y los breadcrumbs</li>";
echo "<li><strong>Revisa la consola del navegador:</strong> Asegúrate de que no haya errores JavaScript</li>";
echo "<li><strong>Lee la documentación:</strong> Consulta <code>SOLUCION_DASHBOARD.md</code> para más detalles</li>";
echo "</ol>";
echo "</div>";

echo "</div>";
echo "</body></html>";
?>
