<?php
// ==========================================
// 2. MODIFICACIONES EN EL ARCHIVO add_patiens.php
// ==========================================

require_once('../../backend/bd/Conexion.php'); 
global $connect;

// Habilitar reporte de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar conexión a la base de datos
if (!$connect) {
    die(json_encode(['status' => 'error', 'message' => 'Error de conexión a la base de datos']));
}

require_once __DIR__.'/../../vendor/autoload.php';
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
// Variables para almacenar el mensaje de alerta
$alert_type = '';
$alert_title = '';
$alert_message = '';
// Directorio de carga de fotos de perfil (definido temprano para uso posterior)
$upload_dir = '../../uploads/fotos_perfil/';

if(isset($_POST['add_patiens'])) {
    // Recibir y limpiar datos del formulario (todos los campos existentes)
    $numhs = trim($_POST['nhi']);
    $nompa = strtoupper(trim($_POST['namp']));
    $apepa = strtoupper(trim($_POST['apep']));  
    $direc = strtoupper(trim($_POST['dip']));
    $sex = strtoupper(trim($_POST['gep']));
    $grup = strtoupper(trim($_POST['grp']));
    $phon = trim($_POST['telp']);
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $cump = trim($_POST['cump']);
    $modalidad = strtoupper(trim($_POST['modalidad']));
    $tusuario = strtoupper(trim($_POST['tusuario']));
    $tdocumento = strtoupper(trim($_POST['tdocumento']));
    $fexpedicion_input = trim($_POST['fexpedicion']);
    // Convertir fecha de YYYY-MM-DD a DD/MM/YYYY para mantener consistencia en BD
    if (!empty($fexpedicion_input) && strpos($fexpedicion_input, '-') !== false) {
        $fecha_parts = explode('-', $fexpedicion_input);
        if (count($fecha_parts) == 3) {
            $fexpedicion = $fecha_parts[2] . '/' . $fecha_parts[1] . '/' . $fecha_parts[0];
        } else {
            $fexpedicion = $fexpedicion_input;
        }
    } else {
        $fexpedicion = $fexpedicion_input;
    }
    $lexpedicion = strtoupper(trim($_POST['lexpedicion']));
    $ecivil = strtoupper(trim($_POST['ecivil']));
    $zona = strtoupper(trim($_POST['zona']));
    $barrio = strtoupper(trim($_POST['barrio']));
    $correo = trim($_POST['correo']);
    $rbono = trim($_POST['rbono'] ?? '');
    $sisben = trim($_POST['sisben'] ?? '');
    $pensionado = trim($_POST['pensionado'] ?? '');
    $tsudadera = trim($_POST['tsudadera'] ?? '');
    $tchaqueta = trim($_POST['tchaqueta'] ?? '');
    $tzapatos = trim($_POST['tzapatos'] ?? '');
    $talentof = trim($_POST['talentof'] ?? '');
    $observacionsalida = trim($_POST['observacionsalida'] ?? '');
    $vivecomp = trim($_POST['vivecomp'] ?? '');
    $redapoyo = trim($_POST['redapoyo'] ?? '');
    $cuidador = trim($_POST['cuidador'] ?? '');
    $pcuidador = trim($_POST['pcuidador'] ?? '');
    $zcuidador = trim($_POST['zcuidador'] ?? '');
    $bvccuidador = trim($_POST['bvccuidador'] ?? '');
    $dcuidador = trim($_POST['dcuidador'] ?? '');
    $tcuidador = trim($_POST['tcuidador'] ?? '');
    $sgsss = trim($_POST['sgsss'] ?? '');
    $eps = trim($_POST['eps'] ?? '');
    $etnia = trim($_POST['etnia'] ?? '');
    $educacion = trim($_POST['educacion'] ?? '');
    $leer = trim($_POST['leer'] ?? '');
    $utecnologia = trim($_POST['utecnologia'] ?? '');
    $poblaciond = trim($_POST['poblaciond'] ?? '');
    $poblacionoficio = trim($_POST['poblacionoficio'] ?? '');
    $qrInput = trim($_POST['qrInput'] ?? '');

    $state = 1; // Estado activo por defecto

    // ============================================
    // PROCESAR FOTO DE PERFIL
    // ============================================
    $fotoperfil = null;
    $upload_error = false;

    if(isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] == 0) {
        $file = $_FILES['fotoperfil'];
        
        // Validar tipo de archivo
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        if(!in_array($file['type'], $allowed_types)) {
            $alert_type = 'error';
            $alert_title = 'Error';
            $alert_message = 'Tipo de archivo no permitido. Solo se permiten imágenes (JPEG, PNG, GIF).';
            $upload_error = true;
        }
        
        // Validar tamaño (máximo 2MB)
        if($file['size'] > 2 * 1024 * 1024) {
            $alert_type = 'error';
            $alert_title = 'Error';
            $alert_message = 'La imagen es demasiado grande. Máximo 2MB permitido.';
            $upload_error = true;
        }
        
        if(!$upload_error) {
            // Crear directorio si no existe
            if(!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            
            // Generar nombre único para el archivo
            $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
            $fotoperfil = $numhs . '_' . time() . '.' . $file_extension;
            $upload_path = $upload_dir . $fotoperfil;
            
            // Mover archivo subido
            if(!move_uploaded_file($file['tmp_name'], $upload_path)) {
                $alert_type = 'error';
                $alert_title = 'Error';
                $alert_message = 'Error al subir la imagen.';
                $upload_error = true;
                $fotoperfil = null;
            }
        }
    } else {
        // Foto opcional: no marcar error si no se adjunta
        $fotoperfil = null;
        $upload_error = false;
    }

    // Validación básica
    if(empty($numhs) || empty($nompa)) {
        $alert_type = 'error';
        $alert_title = 'Error';
        $alert_message = 'Número de historia y nombre son obligatorios';
    } else if(strlen($correo) > 70) {
        $alert_type = 'error';
        $alert_title = 'Error';
        $alert_message = 'El correo electrónico no puede tener más de 70 caracteres';
    } else if(strlen($qrInput) > 150) {
        $alert_type = 'error';
        $alert_title = 'Error';
        $alert_message = 'El texto del QR no puede tener más de 150 caracteres';
    } else if(!$upload_error) {
        // Verificar si el paciente ya existe
        $sql = "SELECT COUNT(*) FROM patients WHERE numhs = :numhs";
        $stmt = $connect->prepare($sql);
        $stmt->bindParam(':numhs', $numhs);

        if (!$stmt->execute()) {
            $alert_type = 'error';
            $alert_title = 'Error';
            $alert_message = 'Error al verificar Usuario existente';
        } else if ($stmt->fetchColumn() > 0) {  
            $alert_type = 'error';
            $alert_title = 'Usuario existente';
            $alert_message = 'Ya existe un Usuario registrado con el documento '.$numhs.'. No se puede registrar nuevamente.';
            
            // Eliminar la imagen subida si el usuario ya existe
            if($fotoperfil && file_exists($upload_dir . $fotoperfil)) {
                unlink($upload_dir . $fotoperfil);
            }
        } else {
            // Insertar nuevo paciente (INCLUYENDO fotoperfil)
            $sql = "INSERT INTO patients (
                numhs, nompa, apepa, direc, sex, grup, phon, tiene_whatsapp, cump, modalidad, tusuario,
                tdocumento, fexpedicion, lexpedicion, ecivil, zona, barrio, correo, rbono,
                sisben, pensionado, tsudadera, tchaqueta, tzapatos, talentof, observacionsalida,
                vivecomp, redapoyo, cuidador, pcuidador, zcuidador, bvccuidador, dcuidador,
                tcuidador, sgsss, eps, etnia, educacion, leer, utecnologia, poblaciond, 
                poblacionoficio, qrInput, fotoperfil, state
            ) VALUES (
                :numhs, :nompa, :apepa, :direc, :sex, :grup, :phon, :tiene_whatsapp, :cump, :modalidad, :tusuario,
                :tdocumento, :fexpedicion, :lexpedicion, :ecivil, :zona, :barrio, :correo, :rbono,
                :sisben, :pensionado, :tsudadera, :tchaqueta, :tzapatos, :talentof, :observacionsalida,
                :vivecomp, :redapoyo, :cuidador, :pcuidador, :zcuidador, :bvccuidador, :dcuidador,
                :tcuidador, :sgsss, :eps, :etnia, :educacion, :leer, :utecnologia, :poblaciond,
                :poblacionoficio, :qrInput, :fotoperfil, :state
            )";

            $stmt = $connect->prepare($sql);
            
            // Bind de parámetros (INCLUYENDO fotoperfil)
            $params = [
                ':numhs' => $numhs,
                ':nompa' => $nompa,
                ':apepa' => $apepa,
                ':direc' => $direc,
                ':sex' => $sex,
                ':grup' => $grup,
                ':phon' => $phon,
                ':tiene_whatsapp' => $tiene_whatsapp,
                ':cump' => $cump,
                ':modalidad' => $modalidad,
                ':tusuario' => $tusuario,
                ':tdocumento' => $tdocumento,
                ':fexpedicion' => $fexpedicion,
                ':lexpedicion' => $lexpedicion,
                ':ecivil' => $ecivil,
                ':zona' => $zona,
                ':barrio' => $barrio,
                ':correo' => $correo,
                ':rbono' => $rbono,
                ':sisben' => $sisben,
                ':pensionado' => $pensionado,
                ':tsudadera' => $tsudadera,
                ':tchaqueta' => $tchaqueta,
                ':tzapatos' => $tzapatos,
                ':talentof' => $talentof,
                ':observacionsalida' => $observacionsalida,
                ':vivecomp' => $vivecomp,
                ':redapoyo' => $redapoyo,
                ':cuidador' => $cuidador,
                ':pcuidador' => $pcuidador,
                ':zcuidador' => $zcuidador,
                ':bvccuidador' => $bvccuidador,
                ':dcuidador' => $dcuidador,
                ':tcuidador' => $tcuidador,
                ':sgsss' => $sgsss,
                ':eps' => $eps,
                ':etnia' => $etnia,
                ':educacion' => $educacion,
                ':leer' => $leer,
                ':utecnologia' => $utecnologia,
                ':poblaciond' => $poblaciond,
                ':poblacionoficio' => $poblacionoficio,
                ':qrInput' => $qrInput ?: "Usuario: $nompa $apepa\nDOCUMENTO: $numhs",
                ':fotoperfil' => $fotoperfil, // NUEVO CAMPO
                ':state' => $state
            ];

            foreach ($params as $key => $value) {
                $stmt->bindValue($key, $value);
            }
        }
    }
}
?>

<?php if (!empty($alert_message)): ?>
<!-- Incluir SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        Swal.fire({
            icon: "<?php echo $alert_type; ?>",
            title: "<?php echo str_replace('"', '\"', $alert_title); ?>",
            text: "<?php echo str_replace('"', '\"', $alert_message); ?>"
        });
    });
</script>
<?php endif; ?>

<?php
// ==========================================
// 3. MODIFICACIÓN DEL SCRIPT QR PARA INCLUIR FOTO
// ==========================================
?>

<script>
    // Variable para almacenar el QR generado
    let currentQR = null;

    // Función para generar QR
    function generateQR() {
        const documento = document.querySelector('input[name="nhi"]').value;
        const nombre = document.querySelector('input[name="namp"]').value;
        const apellido = document.querySelector('input[name="apep"]').value;
        const tipoDoc = document.querySelector('select[name="tdocumento"]').value;

        if (!documento || !nombre || !apellido) {
            alert("Por favor complete documento, nombre y apellido primero");
            return;
        }

        document.getElementById('qrInput').value = documento;
        const qrContainer = document.getElementById("qrCode");
        qrContainer.innerHTML = "<p>Generando QR...</p>";

        // Generar URL completa para el QR que incluye la cedula
        const qrURL = `https://hogar_abuelos.n8nsibate.shop/ubicacion_abuelos/ubicar_abuelos.php?cedula=${documento}`;
        
        QRCode.toDataURL(qrURL, {
            width: 150,
            margin: 1,
            color: { dark: "#000000", light: "#FFFFFF" }
        }, function(error, url) {
            if (error) {
                qrContainer.innerHTML = "<p style='color:red;'>Error al generar QR</p>";
                return;
            }

            currentQR = url;
            
            qrContainer.innerHTML = `
                <div style="border:1px solid #ddd;padding:10px;display:inline-block;background:white;">
                    <div style="text-align:left;margin-bottom:5px;">
                        <p style="margin:2px 0;font-size:14px;"><strong>Nombre:</strong> ${nombre} ${apellido}</p>
                        <p style="margin:2px 0;font-size:14px;"><strong>${tipoDoc}:</strong> ${documento}</p>
                    </div>
                    <img src="${url}" alt="Código QR" style="width:150px;">
                </div>`;
            
            document.getElementById('downloadQRBtn').style.display = 'inline-block';
        });
    }

    // Función para descargar QR con o sin foto del usuario
    document.getElementById('downloadQRBtn').addEventListener('click', async function() {
        if (!currentQR) return;
        
        const nombre = document.querySelector('input[name="namp"]').value;
        const apellido = document.querySelector('input[name="apep"]').value;
        const documento = document.querySelector('input[name="nhi"]').value;
        const tipoDoc = document.querySelector('select[name="tdocumento"]').value;
        const modalidad = document.querySelector('select[name="modalidad"]')?.value || 'N/A';
        const fotoInput = document.getElementById('fotoperfil');

        // Función para cargar una imagen
        function loadImage(src) {
            return new Promise((resolve, reject) => {
                const img = new Image();
                img.onload = () => resolve(img);
                img.onerror = reject;
                img.src = src;
            });
        }

        // Función para generar el carnet completo
        async function generarCarnet() {
            try {
                // Cargar las imágenes del carnet
                const [carnetFrontal, carnetPosterior] = await Promise.all([
                    loadImage('../../backend/img/1-carnet.jpg'),
                    loadImage('../../backend/img/2-carnet2.jpg')
                ]);

                // Crear canvas para la cara frontal
                const canvasFront = document.createElement('canvas');
                const ctxFront = canvasFront.getContext('2d');
                canvasFront.width = carnetFrontal.width;
                canvasFront.height = carnetFrontal.height;
                
                // Dibujar la imagen del carnet frontal
                ctxFront.drawImage(carnetFrontal, 0, 0);
                
                // Procesar foto (cargada o predeterminada)
                let fotoUsuario = null;
                if (fotoInput.files && fotoInput.files[0]) {
                    try {
                        const fotoData = await new Promise((resolve) => {
                            const reader = new FileReader();
                            reader.onload = (e) => resolve(e.target.result);
                            reader.readAsDataURL(fotoInput.files[0]);
                        });
                        fotoUsuario = await loadImage(fotoData);
                    } catch (error) {
                        console.warn('No se pudo cargar la foto del usuario, usando foto predeterminada:', error);
                        try {
                            fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
                        } catch (defaultError) {
                            console.warn('No se pudo cargar la foto predeterminada:', defaultError);
                        }
                    }
                } else {
                    // Si no hay foto cargada, usar la predeterminada
                    try {
                        fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
                    } catch (defaultError) {
                        console.warn('No se pudo cargar la foto predeterminada:', defaultError);
                    }
                }
                
                // Dibujar foto si existe
                if (fotoUsuario) {
                    // Dibujar la foto del usuario centrada
                    const targetWidth = 175;  // Ancho deseado para la foto
                    const targetHeight = 175; // Alto deseado para la foto
                    const centerX = 178;      // Centro X del área de la foto
                    const centerY = 210;      // Centro Y del área de la foto

                    // Calcular dimensiones manteniendo el aspecto
                    const imgAspect = fotoUsuario.width / fotoUsuario.height;
                    let drawWidth, drawHeight, drawX, drawY;

                    if (imgAspect > 1) {
                        // Imagen más ancha que alta
                        drawHeight = targetHeight;
                        drawWidth = drawHeight * imgAspect;
                        if (drawWidth > targetWidth) {
                            drawWidth = targetWidth;
                            drawHeight = drawWidth / imgAspect;
                        }
                    } else {
                        // Imagen más alta que ancha
                        drawWidth = targetWidth;
                        drawHeight = drawWidth / imgAspect;
                        if (drawHeight > targetHeight) {
                            drawHeight = targetHeight;
                            drawWidth = drawHeight * imgAspect;
                        }
                    }

                    // Calcular posición para centrar
                    drawX = centerX - (drawWidth / 2);
                    drawY = centerY - (drawHeight / 2);

                    // Dibujar la imagen directamente sin clip
                    ctxFront.drawImage(fotoUsuario, drawX, drawY, drawWidth, drawHeight);
                }
                
                // Función para dividir texto en múltiples líneas
                function wrapText(context, text, x, y, maxWidth, lineHeight) {
                    const words = text.split(' ');
                    let line = '';
                    let currentY = y;
                    
                    for (let n = 0; n < words.length; n++) {
                        const testLine = line + words[n] + ' ';
                        const metrics = context.measureText(testLine);
                        const testWidth = metrics.width;
                        
                        if (testWidth > maxWidth && n > 0) {
                            context.fillText(line, x, currentY);
                            line = words[n] + ' ';
                            currentY += lineHeight;
                        } else {
                            line = testLine;
                        }
                    }
                    context.fillText(line, x, currentY);
                    return currentY;
                }
                
                // Agregar datos del usuario (siempre se agregan, con o sin foto)
                ctxFront.fillStyle = '#000000';
                
                // Ajustar el tamaño de la fuente según la longitud del nombre
                const nombreCompleto = `${nombre} ${apellido}`.toUpperCase();
                let fontSize = 18;
                if (nombreCompleto.length > 30) {
                    fontSize = 14;
                } else if (nombreCompleto.length > 25) {
                    fontSize = 16;
                }
                
                ctxFront.font = `bold ${fontSize}px Arial`;
                ctxFront.textAlign = 'center';
                
                // Usar wrapText para dividir el nombre en múltiples líneas si es necesario
                const maxWidth = 320; // Ancho máximo disponible
                const lineHeight = fontSize + 4; // Espaciado entre líneas
                const startY = 340; // Posición Y inicial
                
                // wrapText retorna la última posición Y usada
                const lastNameY = wrapText(ctxFront, nombreCompleto, canvasFront.width / 2, startY, maxWidth, lineHeight);
                
                // Ajustar el documento también - centrado (con espacio dinámico después del nombre)
                const cedulaY = lastNameY + 30; // 30px de separación desde la última línea del nombre
                ctxFront.font = 'bold 16px Arial';
                ctxFront.fillStyle = '#000000'; // Color negro
                ctxFront.textAlign = 'center';
                ctxFront.fillText(`${tipoDoc.toUpperCase()}: ${documento}`, canvasFront.width / 2, cedulaY);
                
                // Modalidad debajo del documento - centrada (con espacio dinámico)
                const modalidadY = cedulaY + 25; // 25px de separación desde la cédula
                ctxFront.font = 'bold 14px Arial';
                ctxFront.fillStyle = '#000000'; // Color negro
                ctxFront.textAlign = 'center';
                ctxFront.fillText(`${modalidad}`.toUpperCase(), canvasFront.width / 2, modalidadY);
                
                // Crear canvas para la cara posterior
                const canvasBack = document.createElement('canvas');
                const ctxBack = canvasBack.getContext('2d');
                canvasBack.width = carnetPosterior.width;
                canvasBack.height = carnetPosterior.height;
                
                // Dibujar la imagen del carnet posterior
                ctxBack.drawImage(carnetPosterior, 0, 0);
                
                // Cargar y dibujar el QR
                const qrImg = await loadImage(currentQR);
                const qrSize = 180;
                const qrX = (canvasBack.width - qrSize) / 2;
                const qrY = (canvasBack.height - qrSize) / 2 - 50; // Subir el QR 50 píxeles
                ctxBack.drawImage(qrImg, qrX, qrY, qrSize, qrSize);
                
                // Crear canvas final para combinar ambas caras
                const finalCanvas = document.createElement('canvas');
                const ctxFinal = finalCanvas.getContext('2d');
                finalCanvas.width = canvasFront.width;
                finalCanvas.height = canvasFront.height * 2 + 20;
                
                // Dibujar ambas caras
                ctxFinal.drawImage(canvasFront, 0, 0);
                ctxFinal.drawImage(canvasBack, 0, canvasFront.height + 20);
                
                // Descargar el carnet
                const link = document.createElement('a');
                link.download = `Carnet_${nombre}_${apellido}.png`;
                link.href = finalCanvas.toDataURL('image/png');
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                
            } catch (error) {
                console.error('Error al generar el carnet:', error);
                alert('Error al generar el carnet. Por favor, inténtelo de nuevo.');
            }
        }

        // Ejecutar la generación del carnet
        await generarCarnet();
    });
</script>

<style>
/* Convertir texto de todos los select a mayúsculas */
select, select option {
    text-transform: uppercase;
}
</style>