<?php
session_start();

echo "<h1>Debug de Sesión</h1>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<hr>";
echo "<h2>Verificación de hasModulePermission:</h2>";

require 'backend/php/check_access.php';

$modules = ['dashboard', 'remisiones', 'usuarios', 'cursos', 'asistencia', 'profesionales', 'recursos', 'ajustes', 'acerca', 'reportes'];

echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>Módulo</th><th>Resultado</th></tr>";
foreach($modules as $module) {
    $result = hasModulePermission($module) ? '✅ SÍ' : '❌ NO';
    $color = hasModulePermission($module) ? 'lightgreen' : 'lightcoral';
    echo "<tr style='background: $color;'><td>$module</td><td>$result</td></tr>";
}
echo "</table>";

echo "<hr>";
echo "<h2>Verificación Manual:</h2>";

if(isset($_SESSION['has_custom_permissions'])) {
    echo "<p><strong>has_custom_permissions:</strong> " . ($_SESSION['has_custom_permissions'] ? 'true' : 'false') . "</p>";
    
    if($_SESSION['has_custom_permissions'] && isset($_SESSION['menu_permissions'])) {
        echo "<h3>Permisos en sesión:</h3>";
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Módulo</th><th>Valor</th></tr>";
        foreach($_SESSION['menu_permissions'] as $key => $value) {
            if($key != 'id' && $key != 'user_id') {
                echo "<tr><td>$key</td><td>$value</td></tr>";
            }
        }
        echo "</table>";
    }
} else {
    echo "<p style='color: red;'><strong>NO tiene has_custom_permissions en sesión</strong></p>";
    echo "<p>Esto significa que está usando permisos por rol</p>";
}
?>
