<?php
ob_start();
session_start();

if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1){
    header('location: ../login.php');
    exit();
}

require '../../backend/bd/Conexion.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    <title>Crear Profesional Completo</title>
    
    <style>
        .section-divider {
            margin: 30px 0;
            padding: 15px;
            background: #f8f9fc;
            border-left: 4px solid #667eea;
            border-radius: 4px;
        }
        .section-divider h3 {
            margin: 0;
            color: #667eea;
        }
        .permissions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 15px;
            margin-top: 15px;
        }
        .permission-card {
            background: white;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #e8e8e8;
        }
        .permission-card h4 {
            margin: 0 0 10px 0;
            color: #333;
        }
        .submenu-list {
            margin-left: 28px;
            border-left: 2px solid #e8e8e8;
            padding-left: 10px;
            margin-top: 10px;
        }
        .checkbox-label {
            display: flex;
            align-items: center;
            cursor: pointer;
            margin-bottom: 8px;
        }
        .checkbox-label input {
            margin-right: 8px;
        }
        
        /* Mejora de inputs con labels arriba */
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        .form-group input[type="text"],
        .form-group input[type="email"],
        .form-group input[type="password"],
        .form-group input[type="date"],
        .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e8e8e8;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: white;
            margin: 0;
        }
        .form-group input[type="text"]:focus,
        .form-group input[type="email"]:focus,
        .form-group input[type="password"]:focus,
        .form-group input[type="date"]:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <section id="content">
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Profile</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                </ul>
            </div>
        </nav>

        <main>
            <h1 class="title">Crear Profesional Completo</h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="mostrar.php">Profesionales</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Crear Completo</a></li>
            </ul>

            <div class="data">
                <div class="content-data">
                    <form id="formCompleto" method="POST" style="padding: 20px;">
                        
                        <!-- SECCIÓN 1: DATOS PERSONALES -->
                        <div class="section-divider">
                            <h3>👤 Datos Personales</h3>
                        </div>
                        
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="ceddoc">Cédula</label>
                                <input type="text" id="ceddoc" name="ceddoc" required placeholder="Ingrese la cédula">
                            </div>
                            
                            <div class="form-group">
                                <label for="nodoc">Nombre</label>
                                <input type="text" id="nodoc" name="nodoc" required placeholder="Ingrese el nombre">
                            </div>
                            
                            <div class="form-group">
                                <label for="apdoc">Apellido</label>
                                <input type="text" id="apdoc" name="apdoc" required placeholder="Ingrese el apellido">
                            </div>
                            
                            <div class="form-group">
                                <label for="sexd">Sexo</label>
                                <select id="sexd" name="sexd" required>
                                    <option value="">Seleccione...</option>
                                    <option value="Masculino">Masculino</option>
                                    <option value="Femenino">Femenino</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="phd">Teléfono</label>
                                <input type="text" id="phd" name="phd" required placeholder="Ingrese el teléfono">
                            </div>
                            
                            <div class="form-group">
                                <label for="direcd">Dirección</label>
                                <input type="text" id="direcd" name="direcd" required placeholder="Ingrese la dirección">
                            </div>
                            
                            <div class="form-group">
                                <label for="nacd">Fecha de Nacimiento</label>
                                <input type="date" id="nacd" name="nacd" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="nomesp">Especialidad</label>
                                <select id="nomesp" name="nomesp" required>
                                    <option value="">Seleccione...</option>
                                    <option value="Cardiología">Cardiología</option>
                                    <option value="Dermatología">Dermatología</option>
                                    <option value="Endocrinología">Endocrinología</option>
                                    <option value="Gastroenterología">Gastroenterología</option>
                                    <option value="Geriatría">Geriatría</option>
                                    <option value="Medicina General">Medicina General</option>
                                    <option value="Neurología">Neurología</option>
                                    <option value="Neumología">Neumología</option>
                                    <option value="Oftalmología">Oftalmología</option>
                                    <option value="Psiquiatría">Psiquiatría</option>
                                    <option value="Traumatología">Traumatología</option>
                                    <option value="Urología">Urología</option>
                                </select>
                            </div>
                        </div>

                        <!-- SECCIÓN 2: DATOS DE ACCESO -->
                        <div class="section-divider">
                            <h3>🔐 Datos de Acceso al Sistema</h3>
                        </div>
                        
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="username">Usuario</label>
                                <input type="text" id="username" name="username" required placeholder="Ingrese el usuario">
                            </div>
                            
                            <div class="form-group">
                                <label for="email">Correo Electrónico</label>
                                <input type="email" id="email" name="email" required placeholder="ejemplo@correo.com">
                            </div>
                            
                            <div class="form-group">
                                <label for="password">Contraseña</label>
                                <input type="password" id="password" name="password" required placeholder="Ingrese la contraseña">
                            </div>
                            
                            <div class="form-group">
                                <label for="rol">Rol</label>
                                <select name="rol" id="rol" required>
                                    <option value="">Seleccione...</option>
                                    <option value="1">Administrador</option>
                                    <option value="3">Profesor</option>
                                    <option value="4">Psicólogo</option>
                                    <option value="5">Fisioterapeuta</option>
                                    <option value="6">Enfermería</option>
                                </select>
                            </div>
                        </div>

                        <!-- SECCIÓN 3: PERMISOS DE MENÚ -->
                        <div class="section-divider">
                            <h3>📋 Permisos de Menú</h3>
                            <p style="margin: 5px 0 0 0; color: #666; font-size: 14px;">
                                Seleccione qué módulos y submenús verá este usuario
                            </p>
                        </div>
                        
                        <div class="permissions-grid">
                            <!-- Dashboard -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_dashboard" value="1" checked>
                                    <strong>📊 Dashboard</strong>
                                </label>
                            </div>

                            <!-- Remisiones -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_remisiones" value="1">
                                    <strong>📋 Remisiones</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_remisiones_todas" value="1">
                                        <span>Todas las Remisiones</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_remisiones_nueva" value="1">
                                        <span>Nueva</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_remisiones_calendario" value="1">
                                        <span>Calendario</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Usuarios -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_usuarios" value="1">
                                    <strong>👥 Usuarios</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_usuarios_lista" value="1">
                                        <span>Lista de Usuarios</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_usuarios_historial" value="1">
                                        <span>Historial de los Usuarios</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_usuarios_documentos" value="1">
                                        <span>Documentos</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Cursos -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_cursos" value="1">
                                    <strong>📚 Cursos</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_cursos_registro" value="1">
                                        <span>Registro Cursos</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_cursos_inscripcion" value="1">
                                        <span>Inscripción Cursos</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_cursos_asistencia" value="1">
                                        <span>Asistencia</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Asistencia -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_asistencia" value="1">
                                    <strong>📅 Asistencia</strong>
                                </label>
                            </div>

                            <!-- Profesionales -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_profesionales" value="1">
                                    <strong>👨‍⚕️ Profesionales</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_profesionales_lista" value="1">
                                        <span>Lista de Profesionales</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_profesionales_historial" value="1">
                                        <span>Historial de los Profesionales</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Recursos -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_recursos" value="1">
                                    <strong>👥 Recursos Humanos</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_recursos_enfermera" value="1">
                                        <span>Enfermera</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_recursos_laboratorios" value="1">
                                        <span>Laboratorios</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Ajustes -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_ajustes" value="1">
                                    <strong>⚙️ Ajustes</strong>
                                </label>
                                <div class="submenu-list">
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_ajustes_config" value="1">
                                        <span>Ajustes</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_ajustes_idioma" value="1">
                                        <span>Idioma</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_ajustes_base_datos" value="1">
                                        <span>Base de datos</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Acerca de -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_acerca" value="1" checked>
                                    <strong>ℹ️ Acerca de</strong>
                                </label>
                            </div>

                            <!-- Reportes -->
                            <div class="permission-card">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="perm_reportes" value="1">
                                    <strong>📊 Reportes</strong>
                                </label>
                            </div>
                        </div>

                        <!-- SECCIÓN 4: PERMISOS DE HISTORIA (Solo para roles 4, 5, 6) -->
                        <div id="permisos-historia" style="display: none;">
                            <div class="section-divider">
                                <h3>🔒 Permisos de Historia Clínica</h3>
                                <p style="margin: 5px 0 0 0; color: #666; font-size: 14px;">
                                    Seleccione qué secciones del historial puede ver y modificar
                                </p>
                            </div>
                            
                            <div class="permissions-grid">
                                <!-- Valoración del Riesgo -->
                                <div class="permission-card">
                                    <h4>📋 Valoración del Riesgo Social</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_valoracion" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_valoracion" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Tamizaje Salud Oral -->
                                <div class="permission-card">
                                    <h4>🦷 Tamizaje Salud Oral</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_salud_oral" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_salud_oral" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Tamizaje Salud Mental -->
                                <div class="permission-card">
                                    <h4>🧠 Tamizaje Salud Mental</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_salud_mental" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_salud_mental" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Medicamentos -->
                                <div class="permission-card">
                                    <h4>💊 Medicamentos</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_medicamentos" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_medicamentos" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Signos Vitales -->
                                <div class="permission-card">
                                    <h4>💓 Signos Vitales</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_signos" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_signos" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Diagnóstico -->
                                <div class="permission-card">
                                    <h4>🩺 Diagnóstico Médico</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_diagnostico" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_diagnostico" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Antecedentes -->
                                <div class="permission-card">
                                    <h4>📝 Antecedentes</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_antecedentes" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_antecedentes" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Exámenes -->
                                <div class="permission-card">
                                    <h4>🔬 Exámenes</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_examenes" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_examenes" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Fisioterapia -->
                                <div class="permission-card">
                                    <h4>🏃 Fisioterapia</h4>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_view_fisioterapia" value="1">
                                        <span>Puede ver</span>
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" name="perm_edit_fisioterapia" value="1">
                                        <span>Puede modificar</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr style="margin: 30px 0;">
                        
                        <button type="submit" name="crear_completo" class="registerbtn">
                            💾 Crear Profesional Completo
                        </button>
                    </form>
                </div>
            </div>
        </main>
    </section>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.js"></script>
    
    <script>
        // Toggle sidebar
        const toggleSidebar = document.querySelector('.toggle-sidebar');
        const sidebar = document.getElementById('sidebar');
        
        if(toggleSidebar) {
            toggleSidebar.addEventListener('click', function() {
                sidebar.classList.toggle('hide');
            });
        }
    </script>
    
    <script>
        // Mostrar/ocultar permisos de historia según el rol
        document.getElementById('rol').addEventListener('change', function() {
            const rol = this.value;
            const permisosHistoria = document.getElementById('permisos-historia');
            
            if(rol == '4' || rol == '5' || rol == '6') {
                permisosHistoria.style.display = 'block';
            } else {
                permisosHistoria.style.display = 'none';
            }
        });

        // Enviar formulario con AJAX
        document.getElementById('formCompleto').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            formData.append('crear_completo', '1'); // Agregar el parámetro necesario
            
            fetch('../../backend/php/crear_profesional_completo.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    swal('¡Éxito!', data.message, 'success').then(() => {
                        window.location.href = 'mostrar.php';
                    });
                } else {
                    swal('Error', data.message, 'error');
                }
            })
            .catch(error => {
                swal('Error', 'Hubo un problema al crear el profesional', 'error');
                console.error('Error:', error);
            });
        });
    </script>
</body>
</html>
