<?php
ob_start();
session_start();

// Incluir sistema de control de acceso
require '../../backend/php/check_access.php';

// Verificar acceso - Solo Enfermería (Rol 6)
checkAccess([6]);

require '../../backend/bd/Conexion.php';

// Crear tabla user_permissions si no existe
try {
    $createTable = "CREATE TABLE IF NOT EXISTS `user_permissions` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` INT(11) NOT NULL,
        `view_valoracion_riesgo` TINYINT(1) DEFAULT 0,
        `edit_valoracion_riesgo` TINYINT(1) DEFAULT 0,
        `view_signos_vitales` TINYINT(1) DEFAULT 0,
        `edit_signos_vitales` TINYINT(1) DEFAULT 0,
        `view_medicamentos` TINYINT(1) DEFAULT 0,
        `edit_medicamentos` TINYINT(1) DEFAULT 0,
        `view_diagnostico` TINYINT(1) DEFAULT 0,
        `edit_diagnostico` TINYINT(1) DEFAULT 0,
        `view_antecedentes` TINYINT(1) DEFAULT 0,
        `edit_antecedentes` TINYINT(1) DEFAULT 0,
        `view_examenes` TINYINT(1) DEFAULT 0,
        `edit_examenes` TINYINT(1) DEFAULT 0,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_id` (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $connect->exec($createTable);
} catch(PDOException $e) {
    // Tabla ya existe o error al crear
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <title>Dashboard Enfermería | Programa Persona Mayor</title>
</head>
<body>
    <!-- SIDEBAR -->
    <section id="sidebar">
        <a href="dashboard_enfermeria.php" class="brand">
            <i class='bx bxs-heart icon'></i> Programa Persona Mayor
        </a>
        <ul class="side-menu">
            <li><a href="dashboard_enfermeria.php" class="active"><i class='bx bxs-dashboard icon'></i> Dashboard</a></li>
            <li class="divider" data-text="Módulos">Módulos</li>
            
            <!-- Usuarios -->
            <li>
                <a href="#"><i class='bx bxs-user icon'></i> Usuarios <i class='bx bx-chevron-right icon-right'></i></a>
                <ul class="side-dropdown">
                    <li><a href="../pacientes/mostrar.php">Lista de Usuarios</a></li>
                    <li><a href="../pacientes/historial.php">Historial de Usuarios</a></li>
                </ul>
            </li>

            <!-- Asistencia -->
            <li>
                <a href="../asistencia/Asistencia.php"><i class='bx bxs-check-circle icon'></i> Asistencia</a>
            </li>

            <!-- Acerca de -->
            <li><a href="../acerca/mostrar.php"><i class='bx bxs-info-circle icon'></i> Acerca de</a></li>
        </ul>
    </section>

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Buscar...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Salir</a></li>
                </ul>
            </div>
        </nav>

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido, <?php echo '<strong>'.htmlspecialchars($_SESSION['name']).'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="dashboard_enfermeria.php">Home</a></li>
                <li class="divider">/</li>
                <li><a href="#" class="active">Dashboard Enfermería</a></li>
            </ul>

            <!-- Dashboard Content -->
            <div class="info-data">
                <div class="card">
                    <div class="head">
                        <div>
                            <h2>Rol: Enfermería</h2>
                            <p>Panel de Control</p>
                        </div>
                        <i class='bx bx-plus-medical icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            $totalUsuarios = $connect->query("SELECT COUNT(*) FROM patients")->fetchColumn();
                            ?>
                            <h2><?php echo $totalUsuarios; ?></h2>
                            <p>Usuarios Totales</p>
                        </div>
                        <i class='bx bx-group icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            $totalAsistencias = $connect->query("SELECT COUNT(*) FROM asistencia_qr WHERE DATE(fecha) = CURDATE()")->fetchColumn();
                            ?>
                            <h2><?php echo $totalAsistencias; ?></h2>
                            <p>Asistencias Hoy</p>
                        </div>
                        <i class='bx bx-check-circle icon'></i>
                    </div>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <?php
                            // Contar usuarios registrados (pacientes)
                            $totalPacientes = $connect->query("SELECT COUNT(*) FROM patients")->fetchColumn();
                            ?>
                            <h2><?php echo $totalPacientes; ?></h2>
                            <p>Usuarios Registrados</p>
                        </div>
                        <i class='bx bx-file-blank icon'></i>
                    </div>
                </div>
            </div>

            <!-- Accesos Rápidos -->
            <div class="data" style="margin-top: 30px;">
                <div class="content-data">
                    <div class="head">
                        <h3>Accesos Rápidos</h3>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; padding: 20px;">
                        <a href="../pacientes/mostrar.php" style="text-decoration: none;">
                            <div style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 30px; border-radius: 12px; color: white; text-align: center; transition: transform 0.3s;">
                                <i class='bx bx-user' style="font-size: 48px; margin-bottom: 15px;"></i>
                                <h4>Ver Usuarios</h4>
                                <p style="font-size: 14px; margin-top: 10px;">Lista de usuarios del programa</p>
                            </div>
                        </a>
                        <a href="../pacientes/historial.php" style="text-decoration: none;">
                            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 30px; border-radius: 12px; color: white; text-align: center; transition: transform 0.3s;">
                                <i class='bx bx-file-blank' style="font-size: 48px; margin-bottom: 15px;"></i>
                                <h4>Historial Clínico</h4>
                                <p style="font-size: 14px; margin-top: 10px;">Ver y gestionar historiales</p>
                            </div>
                        </a>
                        <a href="../asistencia/Asistencia.php" style="text-decoration: none;">
                            <div style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); padding: 30px; border-radius: 12px; color: white; text-align: center; transition: transform 0.3s;">
                                <i class='bx bx-qr-scan' style="font-size: 48px; margin-bottom: 15px;"></i>
                                <h4>Tomar Asistencia</h4>
                                <p style="font-size: 14px; margin-top: 10px;">Registrar asistencia con QR</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Permisos del Usuario -->
            <div class="data" style="margin-top: 30px;">
                <div class="content-data">
                    <div class="head">
                        <h3><i class='bx bx-shield-quarter'></i> Mis Permisos de Acceso</h3>
                    </div>
                    <div style="padding: 20px;">
                        <?php
                        // Obtener permisos específicos del usuario
                        $userId = $_SESSION['id'];
                        $stmt = $connect->prepare("SELECT * FROM user_permissions WHERE user_id = ?");
                        $stmt->execute([$userId]);
                        $permissions = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                        if(!$permissions) {
                            // Permisos por defecto para enfermería
                            $permissions = [
                                'view_valoracion_riesgo' => 1,
                                'edit_valoracion_riesgo' => 0,
                                'view_signos_vitales' => 1,
                                'edit_signos_vitales' => 1,
                                'view_medicamentos' => 1,
                                'edit_medicamentos' => 1,
                                'view_diagnostico' => 1,
                                'edit_diagnostico' => 0
                            ];
                        }
                        ?>
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
                            <div style="background: <?php echo $permissions['view_valoracion_riesgo'] ? '#e6f7ee' : '#fee'; ?>; padding: 15px; border-radius: 8px; border-left: 4px solid <?php echo $permissions['view_valoracion_riesgo'] ? '#28a745' : '#c33'; ?>;">
                                <h4 style="margin-bottom: 5px;">📋 Valoración del Riesgo Social</h4>
                                <p style="font-size: 13px; color: #666;">
                                    <?php if($permissions['view_valoracion_riesgo']): ?>
                                        ✅ Puede ver
                                        <?php if($permissions['edit_valoracion_riesgo']): ?>
                                            | ✏️ Puede modificar
                                        <?php else: ?>
                                            | 🔒 Solo lectura
                                        <?php endif; ?>
                                    <?php else: ?>
                                        ❌ Sin acceso
                                    <?php endif; ?>
                                </p>
                            </div>
                            
                            <div style="background: <?php echo $permissions['view_signos_vitales'] ? '#e6f7ee' : '#fee'; ?>; padding: 15px; border-radius: 8px; border-left: 4px solid <?php echo $permissions['view_signos_vitales'] ? '#28a745' : '#c33'; ?>;">
                                <h4 style="margin-bottom: 5px;">💓 Signos Vitales</h4>
                                <p style="font-size: 13px; color: #666;">
                                    <?php if($permissions['view_signos_vitales']): ?>
                                        ✅ Puede ver
                                        <?php if($permissions['edit_signos_vitales']): ?>
                                            | ✏️ Puede modificar
                                        <?php else: ?>
                                            | 🔒 Solo lectura
                                        <?php endif; ?>
                                    <?php else: ?>
                                        ❌ Sin acceso
                                    <?php endif; ?>
                                </p>
                            </div>
                            
                            <div style="background: <?php echo $permissions['view_medicamentos'] ? '#e6f7ee' : '#fee'; ?>; padding: 15px; border-radius: 8px; border-left: 4px solid <?php echo $permissions['view_medicamentos'] ? '#28a745' : '#c33'; ?>;">
                                <h4 style="margin-bottom: 5px;">💊 Medicamentos</h4>
                                <p style="font-size: 13px; color: #666;">
                                    <?php if($permissions['view_medicamentos']): ?>
                                        ✅ Puede ver
                                        <?php if($permissions['edit_medicamentos']): ?>
                                            | ✏️ Puede modificar
                                        <?php else: ?>
                                            | 🔒 Solo lectura
                                        <?php endif; ?>
                                    <?php else: ?>
                                        ❌ Sin acceso
                                    <?php endif; ?>
                                </p>
                            </div>
                            
                            <div style="background: <?php echo $permissions['view_diagnostico'] ? '#e6f7ee' : '#fee'; ?>; padding: 15px; border-radius: 8px; border-left: 4px solid <?php echo $permissions['view_diagnostico'] ? '#28a745' : '#c33'; ?>;">
                                <h4 style="margin-bottom: 5px;">🩺 Diagnóstico Médico</h4>
                                <p style="font-size: 13px; color: #666;">
                                    <?php if($permissions['view_diagnostico']): ?>
                                        ✅ Puede ver
                                        <?php if($permissions['edit_diagnostico']): ?>
                                            | ✏️ Puede modificar
                                        <?php else: ?>
                                            | 🔒 Solo lectura
                                        <?php endif; ?>
                                    <?php else: ?>
                                        ❌ Sin acceso
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </section>

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
</body>
</html>
