<?php
/**
 * Script para limpiar validaciones duplicadas o antiguas
 * que puedan haber quedado después de la actualización
 */

set_time_limit(300);

echo "<h2>🧹 Limpieza de Validaciones Duplicadas</h2>";

$directories = [
    'frontend/acerca',
    'frontend/actividades',
    'frontend/ajustes',
    'frontend/asistencia',
    'frontend/citas',
    'frontend/cursos',
    'frontend/medicos',
    'frontend/pacientes',
    'frontend/recursos'
];

$archivosLimpiados = 0;
$errores = [];

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Procesando archivos...</h3>";

foreach($directories as $dir) {
    if(!is_dir($dir)) continue;
    
    $files = glob($dir . '/*.php');
    
    foreach($files as $file) {
        $content = file_get_contents($file);
        if($content === false) continue;
        
        $modificado = false;
        
        // Buscar validaciones antiguas DESPUÉS de check_access.php
        if(strpos($content, 'check_access.php') !== false) {
            
            // Patrón 1: if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1)
            $patron1 = '/if\s*\(\s*!\s*isset\s*\(\s*\$_SESSION\[\'rol\'\]\s*\)\s*\|\|\s*\$_SESSION\[\'rol\'\]\s*!=\s*1\s*\)\s*\{\s*header\s*\([^)]+\);\s*exit\(\);\s*\}/s';
            if(preg_match($patron1, $content)) {
                $content = preg_replace($patron1, '', $content);
                $modificado = true;
            }
            
            // Patrón 2: Variante sin exit()
            $patron2 = '/if\s*\(\s*!\s*isset\s*\(\s*\$_SESSION\[\'rol\'\]\s*\)\s*\|\|\s*\$_SESSION\[\'rol\'\]\s*!=\s*1\s*\)\s*\{\s*header\s*\([^)]+\);\s*\$id\s*=\s*\$_SESSION\[\'id\'\];\s*\}/s';
            if(preg_match($patron2, $content)) {
                $content = preg_replace($patron2, '', $content);
                $modificado = true;
            }
            
            // Patrón 3: checkAccess con roles específicos (excepto en dashboards)
            if(strpos($file, 'dashboard') === false) {
                $patron3 = '/checkAccess\s*\(\s*\[\s*\d+\s*\]\s*\);/';
                if(preg_match($patron3, $content)) {
                    $content = preg_replace($patron3, '// checkAccess removido - se usa hasModulePermission', $content);
                    $modificado = true;
                }
            }
        }
        
        if($modificado) {
            // Crear backup
            $backupFile = $file . '.backup_limpieza_' . date('Ymd_His');
            copy($file, $backupFile);
            
            // Guardar
            if(file_put_contents($file, $content) !== false) {
                $archivosLimpiados++;
                echo "<p style='color: #28a745;'>✅ Limpiado: <code>$file</code></p>";
            } else {
                $errores[] = "No se pudo guardar: $file";
            }
        }
    }
}

echo "</div>";

echo "<div style='background: #d4edda; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745;'>";
echo "<h3 style='margin-top: 0;'>📊 Resumen</h3>";
echo "<ul>";
echo "<li><strong>✅ Archivos limpiados:</strong> $archivosLimpiados</li>";
echo "<li><strong>❌ Errores:</strong> " . count($errores) . "</li>";
echo "</ul>";

if(count($errores) > 0) {
    echo "<h4>Errores:</h4><ul>";
    foreach($errores as $error) {
        echo "<li style='color: #721c24;'>$error</li>";
    }
    echo "</ul>";
}

echo "<p style='margin-top: 20px;'>";
echo "<a href='frontend/admin/escritorio.php' style='padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Ir al Dashboard</a>";
echo "</p>";

echo "</div>";
?>
