<?php
/**
 * Ver logs de envío de correo
 */
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Logs de Correo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; font-family: monospace; }
        .log-success { color: green; }
        .log-error { color: red; }
        .log-info { color: blue; }
        pre { background: #f5f5f5; padding: 20px; border-radius: 5px; max-height: 600px; overflow-y: auto; }
    </style>
</head>
<body>
    <div class="container">
        <h2>📋 Logs de Envío de Correo</h2>
        <p class="text-muted">Últimas 50 líneas del log de PHP</p>
        
        <div class="mb-3">
            <a href="?refresh=1" class="btn btn-primary">🔄 Actualizar</a>
            <a href="historial_ubicaciones.php" class="btn btn-secondary">← Volver</a>
        </div>
        
        <pre><?php
        $log_file = 'C:\wamp64\logs\php_error.log';
        
        if (file_exists($log_file)) {
            $lines = file($log_file);
            $last_lines = array_slice($lines, -50);
            
            foreach ($last_lines as $line) {
                if (stripos($line, 'correo') !== false || stripos($line, 'mail') !== false || stripos($line, 'smtp') !== false) {
                    if (stripos($line, 'exitosamente') !== false || stripos($line, '✅') !== false) {
                        echo '<span class="log-success">' . htmlspecialchars($line) . '</span>';
                    } elseif (stripos($line, 'error') !== false || stripos($line, 'failed') !== false) {
                        echo '<span class="log-error">' . htmlspecialchars($line) . '</span>';
                    } else {
                        echo '<span class="log-info">' . htmlspecialchars($line) . '</span>';
                    }
                }
            }
            
            echo "\n\n--- Todas las líneas recientes ---\n\n";
            echo htmlspecialchars(implode('', $last_lines));
        } else {
            echo "⚠️ No se encontró el archivo de log en: $log_file\n";
            echo "Ubicaciones posibles:\n";
            echo "- C:\\wamp64\\logs\\php_error.log\n";
            echo "- " . ini_get('error_log') . "\n";
        }
        ?></pre>
    </div>
</body>
</html>
