<?php
/**
 * Script para verificar permisos de un usuario
 * Acceder desde: http://localhost/hogar_abuelos/verificar_permisos.php?username=jrubiano
 */

require 'backend/bd/Conexion.php';

$username = isset($_GET['username']) ? $_GET['username'] : '';

if(empty($username)) {
    echo "<div style='font-family: Arial; padding: 40px; max-width: 600px; margin: 50px auto; background: #fff3cd; border-radius: 12px; border-left: 5px solid #ffc107;'>";
    echo "<h2 style='color: #856404;'>⚠️ Ingresa un nombre de usuario</h2>";
    echo "<p>Agrega ?username=NOMBRE_USUARIO a la URL</p>";
    echo "<p>Ejemplo: verificar_permisos.php?username=jrubiano</p>";
    echo "</div>";
    exit;
}

try {
    // Buscar usuario
    $stmt = $connect->prepare("SELECT id, username, name, rol FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$user) {
        echo "<div style='font-family: Arial; padding: 40px; max-width: 600px; margin: 50px auto; background: #fee; border-radius: 12px; border-left: 5px solid #c33;'>";
        echo "<h2 style='color: #c33;'>❌ Usuario no encontrado</h2>";
        echo "<p>El usuario <strong>{$username}</strong> no existe en la base de datos.</p>";
        echo "</div>";
        exit;
    }
    
    // Verificar permisos en menu_permissions
    echo "<h2>Permisos en menu_permissions:</h2>";
    $stmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
    $stmt->execute([$user['id']]);
    $perms = $stmt->fetch(PDO::FETCH_ASSOC);

    if($perms) {
        echo "<p style='color: green;'><strong>✅ Tiene registro de permisos personalizados</strong></p>";
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Módulo</th><th>Valor</th><th>Estado</th></tr>";
        foreach($perms as $key => $value) {
            if($key != 'id' && $key != 'user_id') {
                $estado = $value == 1 ? '✅ Habilitado' : '❌ Deshabilitado';
                $color = $value == 1 ? 'lightgreen' : 'lightcoral';
                echo "<tr style='background: $color;'>";
                echo "<td><strong>$key</strong></td>";
                echo "<td>$value</td>";
                echo "<td>$estado</td>";
                echo "</tr>";
            }
        }
        echo "</table>";
    
    if(!$perms) {
        echo "<div style='background: #fee; padding: 20px; border-radius: 8px; border-left: 4px solid #c33;'>";
        echo "<p style='margin: 0; color: #721c24;'><strong>⚠️ Este usuario NO tiene permisos configurados en la tabla user_permissions</strong></p>";
        echo "<p style='margin: 10px 0 0 0; color: #721c24;'>Esto significa que se le aplicarán permisos por defecto según su rol.</p>";
        echo "</div>";
        
        echo "<div style='margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 8px; border-left: 4px solid #ffc107;'>";
        echo "<p style='margin: 0; color: #856404;'><strong>💡 Solución:</strong> Edita el usuario desde medicos/crear.php y configura sus permisos.</p>";
        echo "</div>";
    } else {
        echo "<table style='width: 100%; border-collapse: collapse;'>";
        echo "<thead><tr style='background: #667eea; color: white;'>";
        echo "<th style='padding: 12px; text-align: left;'>Sección</th>";
        echo "<th style='padding: 12px; text-align: center;'>Ver</th>";
        echo "<th style='padding: 12px; text-align: center;'>Editar</th>";
        echo "</tr></thead><tbody>";
        
        $sections = [
            'valoracion_riesgo' => 'Valoración del Riesgo Social',
            'signos_vitales' => 'Signos Vitales',
            'medicamentos' => 'Medicamentos',
            'diagnostico' => 'Diagnóstico Médico',
            'antecedentes' => 'Antecedentes',
            'examenes' => 'Exámenes'
        ];
        
        $i = 0;
        foreach($sections as $key => $name) {
            $viewKey = 'view_' . $key;
            $editKey = 'edit_' . $key;
            $canView = isset($perms[$viewKey]) && $perms[$viewKey] == 1;
            $canEdit = isset($perms[$editKey]) && $perms[$editKey] == 1;
            
            $bgColor = $i % 2 == 0 ? '#f8f9fc' : 'white';
            echo "<tr style='background: {$bgColor};'>";
            echo "<td style='padding: 12px;'><strong>{$name}</strong></td>";
            echo "<td style='padding: 12px; text-align: center;'>" . ($canView ? "✅ Sí" : "❌ No") . "</td>";
            echo "<td style='padding: 12px; text-align: center;'>" . ($canEdit ? "✅ Sí" : "❌ No") . "</td>";
            echo "</tr>";
            $i++;
        }
        
        echo "</tbody></table>";
    }
    
    echo "<div style='margin-top: 30px; text-align: center;'>";
    echo "<a href='frontend/medicos/mostrar.php' style='display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600; margin-right: 10px;'>Ver Profesionales</a>";
    echo "<a href='frontend/pacientes/historial.php' style='display: inline-block; background: #6c757d; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600;'>Ver Historial</a>";
    echo "</div>";
    
    echo "</div>";
    echo "</body></html>";
    
} catch(PDOException $e) {
    echo "<div style='font-family: Arial; padding: 40px; max-width: 600px; margin: 50px auto; background: #fee; border-radius: 12px; border-left: 5px solid #c33;'>";
    echo "<h2 style='color: #c33;'>❌ Error</h2>";
    echo "<pre style='background: white; padding: 15px; border-radius: 8px;'>{$e->getMessage()}</pre>";
    echo "</div>";
}
?>
