<?php
/**
 * Script para reemplazar sidebars estáticos por el sidebar dinámico
 * IMPORTANTE: Este script modificará archivos. Se crearán backups automáticamente.
 */

set_time_limit(300); // 5 minutos
ini_set('memory_limit', '256M');

echo "<h2>🔄 Actualización Masiva de Sidebars</h2>";
echo "<p>Este script reemplazará todos los sidebars estáticos por el sidebar dinámico basado en permisos.</p>";

// Directorios a procesar
$directories = [
    'frontend/acerca',
    'frontend/actividades',
    'frontend/admin',
    'frontend/ajustes',
    'frontend/asistencia',
    'frontend/citas',
    'frontend/cursos',
    'frontend/medicos',
    'frontend/pacientes',
    'frontend/profesionales',
    'frontend/profile',
    'frontend/recursos'
];

$archivosModificados = 0;
$archivosOmitidos = 0;
$errores = [];

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Procesando archivos...</h3>";

foreach($directories as $dir) {
    if(!is_dir($dir)) {
        echo "<p style='color: #ffc107;'>⚠️ Directorio no encontrado: $dir</p>";
        continue;
    }
    
    $files = glob($dir . '/*.php');
    
    foreach($files as $file) {
        $filename = basename($file);
        
        // Leer contenido del archivo
        $content = file_get_contents($file);
        
        if($content === false) {
            $errores[] = "No se pudo leer: $file";
            continue;
        }
        
        // Verificar si tiene sidebar estático
        if(strpos($content, '<section id="sidebar">') === false) {
            continue; // No tiene sidebar, omitir
        }
        
        // Verificar si ya tiene el sidebar dinámico
        if(strpos($content, "include '../../backend/php/sidebar_menu.php'") !== false ||
           strpos($content, 'include "../../backend/php/sidebar_menu.php"') !== false) {
            $archivosOmitidos++;
            echo "<p style='color: #6c757d;'>⏭️ Ya actualizado: <code>$file</code></p>";
            continue;
        }
        
        // Crear backup
        $backupFile = $file . '.backup_' . date('Ymd_His');
        if(!copy($file, $backupFile)) {
            $errores[] = "No se pudo crear backup de: $file";
            continue;
        }
        
        // Buscar y reemplazar el sidebar completo
        // Patrón: desde <section id="sidebar"> hasta </section> (el primero)
        $pattern = '/<section id="sidebar">.*?<\/section>\s*(?:<!--\s*SIDEBAR\s*-->)?/s';
        
        // Determinar la ruta correcta según el nivel de carpetas
        $includePath = "'../../backend/php/sidebar_menu.php'";
        
        $replacement = "<!-- SIDEBAR DINÁMICO -->\n    <?php include $includePath; ?>";
        
        $newContent = preg_replace($pattern, $replacement, $content, 1);
        
        if($newContent === null || $newContent === $content) {
            $errores[] = "No se pudo reemplazar sidebar en: $file";
            unlink($backupFile); // Eliminar backup si no se modificó
            continue;
        }
        
        // Guardar el archivo modificado
        if(file_put_contents($file, $newContent) === false) {
            $errores[] = "No se pudo guardar: $file";
            // Restaurar desde backup
            copy($backupFile, $file);
            continue;
        }
        
        $archivosModificados++;
        echo "<p style='color: #28a745;'>✅ Actualizado: <code>$file</code></p>";
        echo "<p style='color: #6c757d; margin-left: 30px; font-size: 12px;'>Backup: <code>$backupFile</code></p>";
    }
}

echo "</div>";

// Resumen
echo "<div style='background: " . (count($errores) > 0 ? '#fff3cd' : '#d4edda') . "; padding: 20px; border-radius: 8px; border-left: 4px solid " . (count($errores) > 0 ? '#ffc107' : '#28a745') . ";'>";
echo "<h3 style='margin-top: 0;'>📊 Resumen de la Actualización</h3>";
echo "<ul style='font-size: 16px;'>";
echo "<li><strong>✅ Archivos actualizados:</strong> $archivosModificados</li>";
echo "<li><strong>⏭️ Archivos omitidos (ya actualizados):</strong> $archivosOmitidos</li>";
echo "<li><strong>❌ Errores:</strong> " . count($errores) . "</li>";
echo "</ul>";

if(count($errores) > 0) {
    echo "<h4>Detalles de errores:</h4>";
    echo "<ul>";
    foreach($errores as $error) {
        echo "<li style='color: #721c24;'>$error</li>";
    }
    echo "</ul>";
}

echo "</div>";

if($archivosModificados > 0) {
    echo "<div style='background: #e7f3ff; padding: 20px; border-radius: 8px; margin-top: 20px;'>";
    echo "<h3 style='color: #004085;'>🎉 ¡Actualización Completada!</h3>";
    echo "<p style='color: #004085;'>";
    echo "Se han actualizado <strong>$archivosModificados archivos</strong>. ";
    echo "Ahora todas las páginas usarán el sidebar dinámico basado en permisos.<br><br>";
    echo "<strong>Importante:</strong> Se han creado backups de todos los archivos modificados. ";
    echo "Si algo no funciona correctamente, puedes restaurar los archivos desde los backups.";
    echo "</p>";
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='debug_login.php' style='padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; display: inline-block; margin-right: 10px;'>Ver Permisos de Usuarios</a>";
    echo "<a href='frontend/admin/escritorio.php' style='padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Ir al Dashboard</a>";
    echo "</div>";
}

// Listar backups creados
if($archivosModificados > 0) {
    echo "<div style='margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px;'>";
    echo "<h3>📦 Archivos de Backup Creados</h3>";
    echo "<p style='color: #666; font-size: 14px;'>Si necesitas restaurar algún archivo, puedes usar estos backups:</p>";
    echo "<details>";
    echo "<summary style='cursor: pointer; color: #667eea; font-weight: bold;'>Ver lista de backups</summary>";
    echo "<ul style='font-family: monospace; font-size: 12px; margin-top: 10px;'>";
    
    foreach($directories as $dir) {
        $backups = glob($dir . '/*.backup_*');
        foreach($backups as $backup) {
            echo "<li>$backup</li>";
        }
    }
    
    echo "</ul>";
    echo "</details>";
    echo "</div>";
}
?>
