<?php
require 'backend/bd/Conexion.php';

echo "<h1>Creando tabla de permisos de menú...</h1>";

try {
    $createTable = "CREATE TABLE IF NOT EXISTS `menu_permissions` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` INT(11) NOT NULL,
        `dashboard` TINYINT(1) DEFAULT 1,
        `remisiones` TINYINT(1) DEFAULT 0,
        `usuarios` TINYINT(1) DEFAULT 0,
        `cursos` TINYINT(1) DEFAULT 0,
        `asistencia` TINYINT(1) DEFAULT 0,
        `profesionales` TINYINT(1) DEFAULT 0,
        `recursos` TINYINT(1) DEFAULT 0,
        `ajustes` TINYINT(1) DEFAULT 0,
        `acerca` TINYINT(1) DEFAULT 1,
        `reportes` TINYINT(1) DEFAULT 0,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_id` (`user_id`),
        FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    $connect->exec($createTable);
    echo "<p style='color: green;'>✅ Tabla menu_permissions creada correctamente</p>";
    
    // Mostrar estructura
    echo "<h2>Estructura de la tabla:</h2>";
    $columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_ASSOC);
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Default</th></tr>";
    foreach($columns as $col) {
        echo "<tr>";
        echo "<td><strong>{$col['Field']}</strong></td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2 style='color: green;'>✅ ¡LISTO!</h2>";
    echo "<p>Ahora puedes configurar permisos de menú para cada usuario.</p>";
    echo "<a href='frontend/medicos/mostrar.php' style='display: inline-block; padding: 10px 20px; background: blue; color: white; text-decoration: none; border-radius: 5px;'>Ir a Profesionales</a>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
