<?php
session_start();
require '../bd/Conexion.php';

header('Content-Type: application/json');

// Debug: Log para ver qué se recibe
error_log("POST data: " . print_r($_POST, true));

if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1){
    echo json_encode(['success' => false, 'message' => 'No autorizado']);
    exit();
}

if(isset($_POST['crear_completo'])) {
    try {
        // Verificar que las tablas existan
        $tables = ['doctor', 'users', 'menu_permissions', 'user_permissions'];
        foreach($tables as $table) {
            $check = $connect->query("SHOW TABLES LIKE '$table'");
            if($check->rowCount() == 0) {
                echo json_encode(['success' => false, 'message' => "Tabla $table no existe. Ejecuta los scripts de configuración primero."]);
                exit();
            }
        }
        
        $connect->beginTransaction();
        
        // 1. INSERTAR EN TABLA DOCTOR
        $ceddoc = $_POST['ceddoc'];
        $nodoc = $_POST['nodoc'];
        $apdoc = $_POST['apdoc'];
        $nomesp = $_POST['nomesp'];
        $direcd = $_POST['direcd'];
        $sexd = $_POST['sexd'];
        $phd = $_POST['phd'];
        $nacd = $_POST['nacd'];
        $username = $_POST['username'];
        $email = $_POST['email'];
        $password = md5($_POST['password']);
        $rol = $_POST['rol'];
        
        $insertDoctor = $connect->prepare("INSERT INTO doctor (
            ceddoc, nodoc, apdoc, nomesp, direcd, sexd, phd, nacd, 
            corr, username, password, rol, state, fere
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, NOW())");
        
        $insertDoctor->execute([
            $ceddoc, $nodoc, $apdoc, $nomesp, $direcd, $sexd, $phd, $nacd,
            $email, $username, $password, $rol
        ]);
        
        // 2. INSERTAR EN TABLA USERS
        $insertUser = $connect->prepare("INSERT INTO users (
            username, name, email, password, rol, created_at
        ) VALUES (?, ?, ?, ?, ?, NOW())");
        
        $fullName = $nodoc . ' ' . $apdoc;
        $insertUser->execute([$username, $fullName, $email, $password, $rol]);
        
        $newUserId = $connect->lastInsertId();
        
        // 3. INSERTAR PERMISOS DE MENÚ (Solo columnas básicas)
        // Verificar qué columnas existen en la tabla
        $columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_COLUMN);
        
        // Columnas básicas que siempre deben existir
        $basicColumns = ['user_id', 'dashboard', 'remisiones', 'usuarios', 'cursos', 'asistencia', 'profesionales', 'recursos', 'ajustes', 'acerca', 'reportes'];
        
        // Construir INSERT dinámicamente solo con columnas que existen
        $insertColumns = [];
        $insertValues = [];
        $insertParams = [$newUserId];
        
        $insertColumns[] = 'user_id';
        $insertValues[] = '?';
        
        // Mapeo completo de permisos (incluye módulos y submenús)
        $permMap = [
            // Módulos principales
            'dashboard' => 'perm_dashboard',
            'remisiones' => 'perm_remisiones',
            'usuarios' => 'perm_usuarios',
            'cursos' => 'perm_cursos',
            'asistencia' => 'perm_asistencia',
            'profesionales' => 'perm_profesionales',
            'recursos' => 'perm_recursos',
            'ajustes' => 'perm_ajustes',
            'acerca' => 'perm_acerca',
            'reportes' => 'perm_reportes',
            
            // Submenús de Remisiones
            'remisiones_todas' => 'perm_remisiones_todas',
            'remisiones_nueva' => 'perm_remisiones_nueva',
            'remisiones_calendario' => 'perm_remisiones_calendario',
            
            // Submenús de Usuarios
            'usuarios_lista' => 'perm_usuarios_lista',
            'usuarios_historial' => 'perm_usuarios_historial',
            'usuarios_documentos' => 'perm_usuarios_documentos',
            
            // Submenús de Cursos
            'cursos_registro' => 'perm_cursos_registro',
            'cursos_inscripcion' => 'perm_cursos_inscripcion',
            'cursos_asistencia' => 'perm_cursos_asistencia',
            
            // Submenús de Profesionales
            'profesionales_lista' => 'perm_profesionales_lista',
            'profesionales_historial' => 'perm_profesionales_historial',
            
            // Submenús de Recursos
            'recursos_enfermera' => 'perm_recursos_enfermera',
            'recursos_laboratorios' => 'perm_recursos_laboratorios',
            
            // Submenús de Ajustes
            'ajustes_config' => 'perm_ajustes_config',
            'ajustes_idioma' => 'perm_ajustes_idioma',
            'ajustes_base_datos' => 'perm_ajustes_base_datos'
        ];
        
        foreach($permMap as $column => $postKey) {
            if(in_array($column, $columns)) {
                $insertColumns[] = $column;
                $insertValues[] = '?';
                $insertParams[] = isset($_POST[$postKey]) ? 1 : 0;
            }
        }
        
        $sql = "INSERT INTO menu_permissions (" . implode(', ', $insertColumns) . ") VALUES (" . implode(', ', $insertValues) . ")";
        $insertMenuPerms = $connect->prepare($sql);
        $insertMenuPerms->execute($insertParams);
        
        // 4. INSERTAR PERMISOS DE HISTORIA (Solo para roles 4, 5, 6)
        if($rol == 4 || $rol == 5 || $rol == 6) {
            // Verificar si las columnas de fisioterapia existen
            $columns = $connect->query("SHOW COLUMNS FROM user_permissions")->fetchAll(PDO::FETCH_COLUMN);
            $hasFisioterapia = in_array('view_fisioterapia', $columns) && in_array('edit_fisioterapia', $columns);
            
            if($hasFisioterapia) {
                // Incluir permisos de fisioterapia
                $insertHistoriaPerms = $connect->prepare("INSERT INTO user_permissions (
                    user_id, view_valoracion_riesgo, edit_valoracion_riesgo,
                    view_salud_oral, edit_salud_oral, view_salud_mental, edit_salud_mental,
                    view_medicamentos, edit_medicamentos, view_signos_vitales, edit_signos_vitales,
                    view_diagnostico, edit_diagnostico, view_antecedentes, edit_antecedentes,
                    view_examenes, edit_examenes, view_fisioterapia, edit_fisioterapia
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                
                $insertHistoriaPerms->execute([
                    $newUserId,
                    isset($_POST['perm_view_valoracion']) ? 1 : 0,
                    isset($_POST['perm_edit_valoracion']) ? 1 : 0,
                    isset($_POST['perm_view_salud_oral']) ? 1 : 0,
                    isset($_POST['perm_edit_salud_oral']) ? 1 : 0,
                    isset($_POST['perm_view_salud_mental']) ? 1 : 0,
                    isset($_POST['perm_edit_salud_mental']) ? 1 : 0,
                    isset($_POST['perm_view_medicamentos']) ? 1 : 0,
                    isset($_POST['perm_edit_medicamentos']) ? 1 : 0,
                    isset($_POST['perm_view_signos']) ? 1 : 0,
                    isset($_POST['perm_edit_signos']) ? 1 : 0,
                    isset($_POST['perm_view_diagnostico']) ? 1 : 0,
                    isset($_POST['perm_edit_diagnostico']) ? 1 : 0,
                    isset($_POST['perm_view_antecedentes']) ? 1 : 0,
                    isset($_POST['perm_edit_antecedentes']) ? 1 : 0,
                    isset($_POST['perm_view_examenes']) ? 1 : 0,
                    isset($_POST['perm_edit_examenes']) ? 1 : 0,
                    isset($_POST['perm_view_fisioterapia']) ? 1 : 0,
                    isset($_POST['perm_edit_fisioterapia']) ? 1 : 0
                ]);
            } else {
                // Sin permisos de fisioterapia (por si la tabla no está actualizada)
                $insertHistoriaPerms = $connect->prepare("INSERT INTO user_permissions (
                    user_id, view_valoracion_riesgo, edit_valoracion_riesgo,
                    view_salud_oral, edit_salud_oral, view_salud_mental, edit_salud_mental,
                    view_medicamentos, edit_medicamentos, view_signos_vitales, edit_signos_vitales,
                    view_diagnostico, edit_diagnostico, view_antecedentes, edit_antecedentes,
                    view_examenes, edit_examenes
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                
                $insertHistoriaPerms->execute([
                    $newUserId,
                    isset($_POST['perm_view_valoracion']) ? 1 : 0,
                    isset($_POST['perm_edit_valoracion']) ? 1 : 0,
                    isset($_POST['perm_view_salud_oral']) ? 1 : 0,
                    isset($_POST['perm_edit_salud_oral']) ? 1 : 0,
                    isset($_POST['perm_view_salud_mental']) ? 1 : 0,
                    isset($_POST['perm_edit_salud_mental']) ? 1 : 0,
                    isset($_POST['perm_view_medicamentos']) ? 1 : 0,
                    isset($_POST['perm_edit_medicamentos']) ? 1 : 0,
                    isset($_POST['perm_view_signos']) ? 1 : 0,
                    isset($_POST['perm_edit_signos']) ? 1 : 0,
                    isset($_POST['perm_view_diagnostico']) ? 1 : 0,
                    isset($_POST['perm_edit_diagnostico']) ? 1 : 0,
                    isset($_POST['perm_view_antecedentes']) ? 1 : 0,
                    isset($_POST['perm_edit_antecedentes']) ? 1 : 0,
                    isset($_POST['perm_view_examenes']) ? 1 : 0,
                    isset($_POST['perm_edit_examenes']) ? 1 : 0
                ]);
            }
        }
        
        $connect->commit();
        
        echo json_encode([
            'success' => true,
            'message' => 'Profesional creado exitosamente con todos sus permisos'
        ]);
        
    } catch(PDOException $e) {
        $connect->rollBack();
        echo json_encode([
            'success' => false,
            'message' => 'Error al crear profesional: ' . $e->getMessage()
        ]);
    }
} else {
    // Mostrar qué parámetros se recibieron
    $receivedParams = array_keys($_POST);
    echo json_encode([
        'success' => false,
        'message' => 'Solicitud inválida. Parámetros recibidos: ' . implode(', ', $receivedParams),
        'debug' => $_POST
    ]);
}
?>
