<?php
// Archivo para inscribir al ciudadano en un curso
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['inscribir_curso'])) {
    $cedula = $_SESSION['email'];
    $idcurso = trim($_POST['idcurso']);
    
    try {
        // Verificar si ya está inscrito
        $check = $connect->prepare("SELECT COUNT(*) FROM inscripciones WHERE documento = :cedula AND idcurso = :idcurso");
        $check->execute([':cedula' => $cedula, ':idcurso' => $idcurso]);
        $existe = $check->fetchColumn();
        
        if($existe > 0) {
            echo '<div class="alert alert-error">
                <strong>¡Atención!</strong> Ya estás inscrito en este curso.
            </div>';
        } else {
            // Realizar la inscripción
            $insertar = $connect->prepare("INSERT INTO inscripciones (documento, idcurso) VALUES (:cedula, :idcurso)");
            $resultado = $insertar->execute([':cedula' => $cedula, ':idcurso' => $idcurso]);
            
            if($resultado) {
                // Obtener el nombre del curso
                $curso_stmt = $connect->prepare("SELECT nombre FROM cursos WHERE idcurso = :idcurso");
                $curso_stmt->execute([':idcurso' => $idcurso]);
                $curso = $curso_stmt->fetch(PDO::FETCH_ASSOC);
                
                echo '<div class="alert alert-success">
                    <strong>¡Inscripción Exitosa!</strong><br>
                    Te has inscrito correctamente en el curso: <strong>' . htmlspecialchars($curso['nombre']) . '</strong>
                </div>';
                
                // Recargar la página después de 2 segundos
                echo '<script>
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                </script>';
            } else {
                echo '<div class="alert alert-error">
                    <strong>Error!</strong> No se pudo completar la inscripción. Por favor, intenta nuevamente.
                </div>';
            }
        }
    } catch(PDOException $e) {
        echo '<div class="alert alert-error">
            <strong>Error!</strong> ' . $e->getMessage() . '
        </div>';
    }
}
?>
