<?php
session_start();
require '../bd/Conexion.php';

// Verificar que sea un ciudadano
if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 3) {
    header('location: ../../frontend/acceso_denegado.php');
    exit();
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['documento'])) {
    $patientId = $_POST['patient_id'];
    $tipoDocumento = $_POST['tipo_documento'];
    $descripcion = $_POST['descripcion'] ?? '';
    
    // Verificar que el paciente pertenece al usuario
    $stmt = $connect->prepare("SELECT idpa FROM patients WHERE idpa = ? AND user_id = ?");
    $stmt->execute([$patientId, $_SESSION['id']]);
    if(!$stmt->fetch()) {
        die("Acceso denegado");
    }
    
    $file = $_FILES['documento'];
    $fileName = $file['name'];
    $fileTmpName = $file['tmp_name'];
    $fileSize = $file['size'];
    $fileError = $file['error'];
    
    // Validar archivo
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $allowed = ['pdf', 'jpg', 'jpeg', 'png'];
    
    if(!in_array($fileExt, $allowed)) {
        $_SESSION['error'] = "Solo se permiten archivos PDF, JPG y PNG";
        header('location: ../../frontend/profile/documentos.php');
        exit();
    }
    
    if($fileSize > 5242880) { // 5MB
        $_SESSION['error'] = "El archivo no puede superar los 5MB";
        header('location: ../../frontend/profile/documentos.php');
        exit();
    }
    
    if($fileError !== 0) {
        $_SESSION['error'] = "Error al subir el archivo";
        header('location: ../../frontend/profile/documentos.php');
        exit();
    }
    
    // Crear directorio si no existe
    $uploadDir = '../../uploads/documentos/';
    if(!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    
    // Generar nombre único
    $newFileName = 'doc_' . $patientId . '_' . time() . '.' . $fileExt;
    $uploadPath = $uploadDir . $newFileName;
    
    // Mover archivo
    if(move_uploaded_file($fileTmpName, $uploadPath)) {
        // Crear tabla si no existe
        try {
            $createTable = "CREATE TABLE IF NOT EXISTS `patient_documents` (
                `id` INT(11) NOT NULL AUTO_INCREMENT,
                `patient_id` INT(11) NOT NULL,
                `tipo_documento` VARCHAR(100) NOT NULL,
                `descripcion` TEXT,
                `file_name` VARCHAR(255) NOT NULL,
                `upload_date` DATETIME DEFAULT CURRENT_TIMESTAMP,
                `uploaded_by` INT(11) NOT NULL,
                PRIMARY KEY (`id`),
                KEY `patient_id` (`patient_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            $connect->exec($createTable);
        } catch(PDOException $e) {
            // Tabla ya existe
        }
        
        // Guardar en base de datos
        $stmt = $connect->prepare("INSERT INTO patient_documents (patient_id, tipo_documento, descripcion, file_name, uploaded_by) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$patientId, $tipoDocumento, $descripcion, $newFileName, $_SESSION['id']]);
        
        $_SESSION['success'] = "Documento subido exitosamente";
    } else {
        $_SESSION['error'] = "Error al guardar el archivo";
    }
}

header('location: ../../frontend/profile/documentos.php');
exit();
?>
