<?php
/**
 * Script para crear la tabla asistencia_cursos
 * Esta tabla será exclusiva para el registro de asistencia de cursos
 * Ejecutar UNA SOLA VEZ desde el navegador
 */

require 'backend/bd/Conexion.php';

try {
    // Verificar si la tabla ya existe
    $checkTable = $connect->query("SHOW TABLES LIKE 'asistencia_cursos'");
    
    if ($checkTable->rowCount() == 0) {
        // Crear la tabla asistencia_cursos
        $createTable = "
        CREATE TABLE IF NOT EXISTS `asistencia_cursos` (
            `id` INT NOT NULL AUTO_INCREMENT,
            `documento` VARCHAR(20) NOT NULL COMMENT 'Documento del usuario',
            `nompa` VARCHAR(100) DEFAULT NULL COMMENT 'Nombre del usuario',
            `apepa` VARCHAR(100) DEFAULT NULL COMMENT 'Apellido del usuario',
            `idcurso` INT NOT NULL COMMENT 'ID del curso',
            `fecha` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            INDEX `idx_documento` (`documento`),
            INDEX `idx_idcurso` (`idcurso`),
            INDEX `idx_fecha` (`fecha`)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci 
        COMMENT='Tabla de asistencia exclusiva para cursos';
        ";
        
        $connect->exec($createTable);
        
        echo "<div style='font-family: Arial; padding: 20px;'>";
        echo "<h2 style='color: #28a745;'>✅ Tabla 'asistencia_cursos' creada exitosamente</h2>";
        echo "<p style='font-size: 16px;'>El sistema de asistencia de cursos ahora está completamente separado del sistema de asistencia normal.</p>";
        echo "<ul style='font-size: 14px; line-height: 2;'>";
        echo "<li><strong>Asistencia Normal:</strong> Usa la tabla <code>asistencia_qr</code></li>";
        echo "<li><strong>Asistencia de Cursos:</strong> Usa la tabla <code>asistencia_cursos</code></li>";
        echo "</ul>";
        echo "<p style='background: #fff3cd; padding: 10px; border-left: 4px solid #ffc107;'>";
        echo "⚠️ <strong>Importante:</strong> Los registros de asistencia de cursos ahora se guardarán en la nueva tabla. Los registros antiguos siguen en <code>asistencia_qr</code>.";
        echo "</p>";
        echo "<br><a href='frontend/cursos/Asistencia.php' style='background: #4968ad; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Ir a Asistencia de Cursos</a>";
        echo "</div>";
        
    } else {
        echo "<div style='font-family: Arial; padding: 20px;'>";
        echo "<h2 style='color: #17a2b8;'>ℹ️ La tabla 'asistencia_cursos' ya existe</h2>";
        echo "<p>El sistema de asistencia de cursos ya está configurado correctamente.</p>";
        echo "<br><a href='frontend/cursos/Asistencia.php' style='background: #4968ad; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Ir a Asistencia de Cursos</a>";
        echo "</div>";
    }
    
} catch (PDOException $e) {
    echo "<div style='font-family: Arial; padding: 20px;'>";
    echo "<h2 style='color: #dc3545;'>❌ Error al crear la tabla</h2>";
    echo "<p style='background: #f8d7da; padding: 10px; border-left: 4px solid #dc3545;'>";
    echo "Error: " . $e->getMessage();
    echo "</p>";
    echo "</div>";
}
?>
