<?php
/**
 * Script para crear la tabla user_permissions
 * Ejecutar este archivo una sola vez desde el navegador
 */

require '../backend/bd/Conexion.php';

try {
    // Crear tabla user_permissions
    $sql = "CREATE TABLE IF NOT EXISTS `user_permissions` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` INT(11) NOT NULL,
        `view_valoracion_riesgo` TINYINT(1) DEFAULT 0,
        `edit_valoracion_riesgo` TINYINT(1) DEFAULT 0,
        `view_signos_vitales` TINYINT(1) DEFAULT 0,
        `edit_signos_vitales` TINYINT(1) DEFAULT 0,
        `view_medicamentos` TINYINT(1) DEFAULT 0,
        `edit_medicamentos` TINYINT(1) DEFAULT 0,
        `view_diagnostico` TINYINT(1) DEFAULT 0,
        `edit_diagnostico` TINYINT(1) DEFAULT 0,
        `view_antecedentes` TINYINT(1) DEFAULT 0,
        `edit_antecedentes` TINYINT(1) DEFAULT 0,
        `view_examenes` TINYINT(1) DEFAULT 0,
        `edit_examenes` TINYINT(1) DEFAULT 0,
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_id` (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $connect->exec($sql);
    
    echo "<div style='font-family: Arial; padding: 40px; max-width: 600px; margin: 50px auto; background: #e6f7ee; border-radius: 12px; border-left: 5px solid #28a745;'>";
    echo "<h2 style='color: #28a745; margin-bottom: 15px;'>✅ ¡Tabla Creada Exitosamente!</h2>";
    echo "<p style='color: #333; line-height: 1.6;'>La tabla <strong>user_permissions</strong> ha sido creada correctamente en la base de datos.</p>";
    echo "<p style='color: #666; font-size: 14px; margin-top: 20px;'>Ahora puedes:</p>";
    echo "<ul style='color: #666; line-height: 2;'>";
    echo "<li>✓ Crear usuarios con permisos personalizados</li>";
    echo "<li>✓ Acceder al historial clínico con control de permisos</li>";
    echo "<li>✓ Ver el dashboard de enfermería con permisos</li>";
    echo "</ul>";
    echo "<div style='margin-top: 30px; padding: 15px; background: #fff3cd; border-radius: 8px; border-left: 4px solid #ffc107;'>";
    echo "<p style='margin: 0; color: #856404; font-size: 14px;'><strong>Nota:</strong> Puedes eliminar este archivo (crear_tabla_permisos.php) después de ejecutarlo.</p>";
    echo "</div>";
    echo "<div style='margin-top: 20px; text-align: center;'>";
    echo "<a href='frontend/medicos/crear.php' style='display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600;'>Ir a Crear Perfil</a>";
    echo "</div>";
    echo "</div>";
    
    // Mostrar estructura de la tabla
    echo "<div style='font-family: Arial; padding: 40px; max-width: 800px; margin: 20px auto; background: white; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1);'>";
    echo "<h3 style='color: #667eea; margin-bottom: 20px;'>📋 Estructura de la Tabla</h3>";
    
    $columns = $connect->query("DESCRIBE user_permissions");
    echo "<table style='width: 100%; border-collapse: collapse;'>";
    echo "<thead><tr style='background: #f8f9fc;'>";
    echo "<th style='padding: 12px; text-align: left; border-bottom: 2px solid #667eea;'>Campo</th>";
    echo "<th style='padding: 12px; text-align: left; border-bottom: 2px solid #667eea;'>Tipo</th>";
    echo "<th style='padding: 12px; text-align: left; border-bottom: 2px solid #667eea;'>Nulo</th>";
    echo "<th style='padding: 12px; text-align: left; border-bottom: 2px solid #667eea;'>Clave</th>";
    echo "</tr></thead><tbody>";
    
    while($col = $columns->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr style='border-bottom: 1px solid #e8e8e8;'>";
        echo "<td style='padding: 10px;'><strong>{$col['Field']}</strong></td>";
        echo "<td style='padding: 10px; color: #666;'>{$col['Type']}</td>";
        echo "<td style='padding: 10px; color: #666;'>{$col['Null']}</td>";
        echo "<td style='padding: 10px; color: #666;'>{$col['Key']}</td>";
        echo "</tr>";
    }
    echo "</tbody></table>";
    echo "</div>";
    
} catch(PDOException $e) {
    echo "<div style='font-family: Arial; padding: 40px; max-width: 600px; margin: 50px auto; background: #fee; border-radius: 12px; border-left: 5px solid #c33;'>";
    echo "<h2 style='color: #c33; margin-bottom: 15px;'>❌ Error al Crear la Tabla</h2>";
    echo "<p style='color: #333;'><strong>Mensaje de error:</strong></p>";
    echo "<pre style='background: white; padding: 15px; border-radius: 8px; overflow-x: auto;'>{$e->getMessage()}</pre>";
    echo "<p style='color: #666; margin-top: 20px;'>Por favor, verifica:</p>";
    echo "<ul style='color: #666; line-height: 2;'>";
    echo "<li>Que la conexión a la base de datos sea correcta</li>";
    echo "<li>Que tengas permisos para crear tablas</li>";
    echo "<li>Que la base de datos exista</li>";
    echo "</ul>";
    echo "</div>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Tabla de Permisos</title>
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
</head>
<body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; margin: 0; padding: 20px;">
</body>
</html>
