<?php
// Incluir sistema de control de acceso (ya incluye session_start en Conexion.php)
require '../../backend/php/check_access.php';

// Verificar que tenga permiso para el módulo "acerca"
if(!hasModulePermission('acerca')) {
    header('location: ../acceso_denegado.php');
    exit;
}

$id = $_SESSION['id'];

require '../../backend/bd/Conexion.php';

$alertMessage = '';
$alertType = '';

if (isset($_POST['add_curso'])) {
    $nombre = trim(htmlspecialchars($_POST['nombre']));
    $quien_lo_da = trim(htmlspecialchars($_POST['quien_lo_da']));
    $es_titulado = trim(htmlspecialchars($_POST['es_titulado']));
    $en_que = !empty($_POST['en_que']) ? trim(htmlspecialchars($_POST['en_que'])) : null;

    $verificar = $connect->prepare("SELECT * FROM cursos WHERE nombre = :nombre AND quien_lo_da = :quien_lo_da");
    $verificar->bindParam(':nombre', $nombre);
    $verificar->bindParam(':quien_lo_da', $quien_lo_da);
    $verificar->execute();

    if ($verificar->rowCount() > 0) {
        $alertType = 'warning';
        $alertMessage = 'Ya existe un curso con ese nombre y profesor.';
    } else {
        try {
            $stmt = $connect->prepare("INSERT INTO cursos (nombre, quien_lo_da, es_titulado, en_que)
                                       VALUES (:nombre, :quien_lo_da, :es_titulado, :en_que)");
            $stmt->bindParam(':nombre', $nombre);
            $stmt->bindParam(':quien_lo_da', $quien_lo_da);
            $stmt->bindParam(':es_titulado', $es_titulado);
            $stmt->bindParam(':en_que', $en_que);

            if ($stmt->execute()) {
                $alertType = 'success';
                $alertMessage = 'El curso se guardó exitosamente.';
            } else {
                $alertType = 'error';
                $alertMessage = 'Hubo un error al registrar el curso.';
            }
        } catch (PDOException $e) {
            $alertType = 'error';
            $alertMessage = 'Error de servidor: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Programa Persona Mayor | Registro de Cursos</title>
</head>
<body>
    <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            
            <span class="divider"></span>
            <div class="profile">
                <img src="/logosecg.png" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Profile</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Acerca de</a></li>
            </ul>
            <br>
            
            <div class="images-container">
                <div class="">
                    <img src="../../backend/img/logosecg.png" />
                    <H1>DESARROLLADO POR EL ING. JHON RUBIANO </H1>
                    <H2>CONTACTAR AL 3229060608</H2>
                </div>
            </div>
        </main>
        <!-- MAIN -->
    </section>
    <!-- NAVBAR -->

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
</body>
</html> 