<?php
session_start();

// Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar permisos
    if(!hasModulePermission('cursos') && !hasSubmenuPermission('cursos_inscripcion')){
        header('location: ../acceso_denegado.php');
        exit;
    }

require '../../backend/bd/Conexion.php';

$alertMessage = '';
$alertType = '';
$nombres = '';
$apellidos = ''; // Variable para el apellido
$documento_valido = false;
$documento = isset($_POST['documento']) ? $_POST['documento'] : '';

// Manejar solicitud AJAX para búsqueda de USUARIO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax']) && $_POST['ajax'] === 'buscar_paciente') {
    header('Content-Type: application/json');
    $response = ['success' => false, 'nombres' => '', 'apellidos' => '', 'message' => ''];
    
    if (!empty($_POST['documento'])) {
        $documento = $_POST['documento'];
        
        if (!preg_match('/^\d+$/', $documento)) {
            $response['message'] = 'El documento debe contener solo números';
            echo json_encode($response);
            exit;
        }
        
        try {
            $buscar = $connect->prepare("SELECT nompa, apepa FROM patients WHERE numhs = :documento LIMIT 1");
            $buscar->bindParam(':documento', $documento, PDO::PARAM_STR);
            
            if ($buscar->execute()) {
                if ($buscar->rowCount() > 0) {
                    $fila = $buscar->fetch(PDO::FETCH_ASSOC);
                    $response = [
                        'success' => true,
                        'nombres' => $fila['nompa'],
                        'apellidos' => $fila['apepa'], // Incluimos el apellido
                        'message' => ''
                    ];
                } else {
                    $response['message'] = 'No se encontró USUARIO con ese documento.';
                }
            }
        } catch (PDOException $e) {
            $response['message'] = 'Error en la base de datos: ' . $e->getMessage();
            error_log("Error al buscar USUARIO: " . $e->getMessage());
        }
    } else {
        $response['message'] = 'Documento no proporcionado';
    }
    
    echo json_encode($response);
    exit;
}

// Procesar inscripción a curso
if (isset($_POST['inscribir'])) {
    $documento = $_POST['documento'];
    $idcurso = $_POST['idcurso'];

    // Verificar si el usuario existe
    $verificar_paciente = $connect->prepare("SELECT idpa FROM patients WHERE numhs = :documento LIMIT 1");
    $verificar_paciente->bindParam(':documento', $documento);
    $verificar_paciente->execute();

    if ($verificar_paciente->rowCount() === 0) {
        $alertType = 'error';
        $alertMessage = 'El usuario no existe en la base de datos.';
    } else {
        // Verificar si ya está inscrito
        $verificar_inscripcion = $connect->prepare("SELECT * FROM inscripciones WHERE documento = :documento AND idcurso = :idcurso");
        $verificar_inscripcion->bindParam(':documento', $documento);
        $verificar_inscripcion->bindParam(':idcurso', $idcurso);
        $verificar_inscripcion->execute();

        if ($verificar_inscripcion->rowCount() > 0) {
            $alertType = 'warning';
            $alertMessage = 'Este usuario ya está inscrito en el curso seleccionado.';
        } else {
            // Realizar la inscripción
            $insertar = $connect->prepare("INSERT INTO inscripciones (documento, idcurso) VALUES (:documento, :idcurso)");
            $insertar->bindParam(':documento', $documento);
            $insertar->bindParam(':idcurso', $idcurso);

            if ($insertar->execute()) {
                $alertType = 'success';
                $alertMessage = 'Inscripción realizada correctamente.';
                // Limpiar campos
                $nombres = '';
                $apellidos = ''; // Limpiamos también el apellido
                $documento = '';
            } else {
                $alertType = 'error';
                $alertMessage = 'Error al realizar la inscripción.';
            }
        }
    }
}

// Obtener lista de cursos disponibles
$cursos = $connect->query("SELECT idcurso, nombre FROM cursos ORDER BY nombre")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Inscripción a Cursos</title>
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .loading {
            display: none;
            color: #666;
            font-size: 0.875rem;
            margin-top: 5px;
        }
        #nombres, #apellidos {
            background-color: #f8f9fa;
            cursor: not-allowed;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .btn {
            transition: all 0.3s ease;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        /* Estilos para el fondo gris y contenido blanco como en el primer documento */
        #content {
            background-color: #f5f5f5;
        }
        
        form.form {
            background-color: #fff;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-width: 800px;
            margin: 0 auto;
        }
        
        main {
            padding: 24px;
        }
        
        .btn {
            background-color:rgb(37, 102, 167);
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-weight: 600;
        }
        
        .btn:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }
        
        input[type="text"], select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
        }
        
        /* Estilos de la barra lateral y navegación similares al primer documento */
        #sidebar {
            background-color:rgb(255, 255, 255);
        }
        
        #sidebar .side-menu > li > a:hover {
            background-color: #eaeaea;
            color:rgb(98, 165, 241);
        }
        
        #sidebar .side-menu > li > a.active {
            background-color: #eaeaea;
            color: #3c91e6;
        }
    </style>
</head>
<body>


      <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
 <!-- SIDEBAR -->
<section id="content">
    <nav>
        <i class='bx bx-menu toggle-sidebar'></i>
        <form action="#">
            <div class="form-group">
                <input type="text" placeholder="Buscar...">
                <i class='bx bx-search icon'></i>
            </div>
        </form>
        <span class="divider"></span>
        <div class="profile">
            <img src="../../backend/img/user-default.png" alt="User Avatar">
            <ul class="profile-link">
                <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Cerrar sesión</a></li>
            </ul>
        </div>
    </nav>

    <main>
        <h1 class="title">Inscripción a Cursos</h1>
        <ul class="breadcrumbs">
            <li><a href="../admin/escritorio.php">Home</a></li>
            <li class="divider">/</li>
            <li><a href="#" class="active">Inscripción Cursos</a></li>
        </ul>

        <div class="containerss">
            <form method="POST" class="form" autocomplete="off" id="inscripcionForm">
                <div class="form-group">
                    <label for="documento">Documento del Usuario:</label>
                    <input type="text" id="documento" name="documento" 
                           placeholder="Ingrese número de documento" 
                           value="<?php echo htmlspecialchars($documento); ?>" 
                           required autocomplete="off">
                    <div id="loading" class="loading">Buscando usuario...</div>
                </div>

                <div class="form-group">
                    <label for="nombres">Nombre del Usuario:</label>
                    <input type="text" id="nombres" name="nombres" 
                           value="<?php echo htmlspecialchars($nombres); ?>" 
                           readonly>
                </div>

                <div class="form-group">
                    <label for="apellidos">Apellido del Usuario:</label>
                    <input type="text" id="apellidos" name="apellidos" 
                           value="<?php echo htmlspecialchars(isset($apellidos) ? $apellidos : ''); ?>" 
                           readonly>
                </div>

                <div class="form-group">
                    <label for="idcurso">Seleccionar Curso:</label>
                    <select name="idcurso" id="idcurso" class="form-select" required>
                        <option value="">-- Seleccione un curso --</option>
                        <?php foreach ($cursos as $curso): ?>
                            <option value="<?php echo $curso['idcurso']; ?>">
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <button type="submit" name="inscribir" class="registerbtn" <?php echo empty($nombres) ? 'disabled' : ''; ?>>
                    Inscribir
                </button>
            </form>
        </div>
    </main>
</section>

<script src="../../backend/js/admin.js"></script>
<script>

$(document).ready(function() {
    var debounceTimer;
    var lastDocumento = '';
    var alertaShown = false; // Para controlar las alertas
    
    // Buscar automáticamente al ingresar documento
    $('#documento').on('input', function() {
        var documento = $(this).val().trim();
        clearTimeout(debounceTimer);
        
        // Resetear el flag cuando cambia el documento
        if (documento !== lastDocumento) {
            alertaShown = false;
        }
        
        // Evitar búsquedas repetidas para el mismo documento
        if (documento === lastDocumento && documento.length > 0) {
            return;
        }
        
        lastDocumento = documento;
        
        debounceTimer = setTimeout(function() {
            // Limpiar campos si está vacío
            if (documento.length === 0) {
                $('#nombres').val('');
                $('#apellidos').val('');
                $('[name="inscribir"]').prop('disabled', true);
                $('#loading').hide();
                return;
            }
            
            // Validar que solo contenga números
            if (!/^\d+$/.test(documento)) {
                $('#nombres').val('');
                $('#apellidos').val('');
                $('[name="inscribir"]').prop('disabled', true);
                $('#loading').hide();
                // No mostrar alerta mientras está escribiendo
                return;
            }
            
            // Buscar solo si tiene al menos 4 dígitos
            if (documento.length >= 4) {
                $('#loading').show();
                
                $.ajax({
                    url: window.location.href,
                    method: 'POST',
                    data: { 
                        documento: documento,
                        ajax: 'buscar_paciente'
                    },
                    dataType: 'json',
                    success: function(response) {
                        $('#loading').hide();
                        if (response.success) {
                            $('#nombres').val(response.nombres);
                            $('#apellidos').val(response.apellidos);
                            $('[name="inscribir"]').prop('disabled', false);
                            alertaShown = false;
                        } else {
                            $('#nombres').val('');
                            $('#apellidos').val('');
                            $('[name="inscribir"]').prop('disabled', true);
                            // Solo mostrar alerta una vez y si el documento tiene longitud completa
                            if (response.message && documento.length >= 7 && !alertaShown) {
                                alertaShown = true;
                                Swal.fire({
                                    icon: 'warning',
                                    title: 'Usuario no encontrado',
                                    text: response.message,
                                    confirmButtonText: 'Aceptar'
                                });
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#loading').hide();
                        if (!alertaShown) {
                            alertaShown = true;
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Error al conectar con el servidor',
                                confirmButtonText: 'Aceptar'
                            });
                        }
                    }
                });
            } else {
                $('#loading').hide();
                $('#nombres').val('');
                $('#apellidos').val('');
                $('[name="inscribir"]').prop('disabled', true);
            }
        }, 800);
    });
    
    // Mostrar alertas si existen
    <?php if (!empty($alertMessage)): ?>
    Swal.fire({
        icon: '<?php echo $alertType; ?>',
        title: '<?php echo ($alertType == 'success' ? '¡Éxito!' : ($alertType == 'warning' ? 'Atención' : 'Error')); ?>',
        text: '<?php echo $alertMessage; ?>',
        confirmButtonText: 'Aceptar'
    }).then((result) => {
        if (result.isConfirmed && '<?php echo $alertType; ?>' === 'success') {
            $('#inscripcionForm')[0].reset();
            $('#nombres').val('');
            $('#apellidos').val('');
            $('[name="inscribir"]').prop('disabled', true);
        }
    });
    <?php endif; ?>
});
</script>
</body>
</html>