<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver lista de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    



    <title>Clínica Salud | Información del USUARIO</title>
</head>
<body>

      <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
 <!-- SIDEBAR -->

    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
             <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de los Usuarios</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Información del USUARIO</a></li>
            </ul>
           
           <!-- multistep form -->
<?php 
require '../../backend/bd/Conexion.php';
 $id = $_GET['id'];
 $sentencia = $connect->prepare("SELECT * FROM patients  WHERE idpa= '$id';");
 $sentencia->execute();

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
   ?>
   <?php if(count($data)>0):?>
        <?php foreach($data as $d):?>
<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off" onsubmit="return validacion()">
  <div class="containerss">
    <h1>Información del USUARIO</h1>

    <hr>

    <label for="email"><b>Documento del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled placeholder="ejm: ASCS855CS74" value="<?php echo $d->numhs; ?>" name="nhi" maxlength="14" required>

    <label for="psw"><b>Nombre del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled placeholder="ejm: Juan Raul" value="<?php echo $d->nompa; ?>" name="namp" required>

    <label for="psw"><b>Apellido del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled placeholder="ejm: Ramirez Requena" value="<?php echo $d->apepa; ?>" name="apep" required>

    <label for="psw"><b>Dirección del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled placeholder="ejm: calle los medanos" value="<?php echo $d->direc; ?>" name="dip" required>

    <label for="psw"><b>Género del USUARIO</b></label><span class="badge-warning">*</span>
    <select required name="gep" id="gep" disabled>
        <option><?php echo $d->sex; ?></option>
        
    </select>

    <label for="psw"><b>Grupo sanguíneo del USUARIO</b></label><span class="badge-warning">*</span>
    <select required name="grp" id="grp" disabled>
        <option><?php echo $d->grup; ?></option>
       
    </select>

    <label for="psw"><b>Teléfono del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled maxlength="13" value="<?php echo $d->phon; ?>"  placeholder="ejm: +51 999 888 111" name="telp" required>

    <label for="psw"><b>Fecha de nacimiento del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="date" disabled  value="<?php echo $d->cump; ?>" name="cump" required>

    <label for="psw"><b>Correo del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled value="<?php echo $d->corr; ?>" name="corr" required>

    <label for="psw"><b>Usuario del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" disabled value="<?php echo $d->username; ?>" name="username" required>

    <hr>
   
   
  </div>
  
</form>

        <?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    

   
</body>
</html>


