<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver lista de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    
    <!-- QR -->
     <script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.1/build/qrcode.min.js"></script>


    <title>Programa Persona Mayor </title>
</head>
<body>

       <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
            <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de los Usuarios</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Nuevos Usuarios</a></li>
            </ul>
           
           <!-- multistep form -->


<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off" onsubmit="return validacion()">
  <div class="containerss">
    <h1>Nuevo Usuario</h1>
    <div class="alert-danger">
  <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
  <strong>Importante!</strong> Es importante rellenar los campos con &nbsp;<span class="badge-warning">*</span>
</div>
    
    <!-- Barra de Progreso -->
    <div class="progress-container">
        <div class="progress-header">
            <span class="progress-title">Progreso del Formulario</span>
            <span class="progress-percentage" id="progressPercentage">0%</span>
        </div>
        <div class="progress-bar-bg">
            <div class="progress-bar-fill" id="progressBarFill"></div>
        </div>
        <div class="progress-info">
            <span id="fieldsCompleted">0</span> de <span id="totalFields">0</span> campos completados
        </div>
    </div>
    
    <hr>
   
    <label for="psw"><b>modalidad</b></label><span class="badge-warning">*</span>
    <select required name="modalidad" id="modalidad">
        <option>Seleccione</option>
        <option value="Centro día La paz ">Centro día La paz </option>
        <option value="Centro día Bradamonte ">Centro día Bradamonte </option>
        <option value="Centro día Neruda G1">Centro día Neruda G1 </option>
        <option value="Centro día Neruda G2">Centro día Neruda G2 </option>
        <option value="Satélite san Miguel">Satélite san Miguel </option>
        <option value="Satélite perico">Satélite perico</option>
        <option value="Club Santa Isabel ">Club Santa Isabel</option>
        <option value="Club Renacer">Club Renacer </option>
        <option value="Club San José ">Club San José  </option>
        <option value="Club San Benito">Club San Benito  </option>
        <option value="Club San Rafael">Club San Rafael  </option>
        <option value="RAD"> RAD </option>
    </select>
   


    <label for="psw"><b>Tipo de Usuario</b></label><span class="badge-warning">*</span>
    <select required name="tusuario" id="tusuario">
        <option>Seleccione</option>
        <option value="Antiguo">Antiguo</option>
        <option value="Nuevo">Nuevo</option>
        
    </select>  

    <label for="psw"><b>Nombres del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Juan Raul" name="namp" required>

    <label for="psw"><b>Apellido del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Ramirez Requena" name="apep" required>

    <label for="psw"><b>Tipó de Documento</b></label><span class="badge-warning">*</span>
    <select required name="tdocumento" id="tdocumento">
        <option>Seleccione</option>
        <option value="C.C">C.C</option>
        <option value="C.E">C.E</option>
        <option value="SIN ID">SIN ID</option>
    </select>  

    <label for="email"><b>Documento de identidad</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: 77114578" name="nhi" maxlength="10" required>
    
    <label for="psw"><b>Fecha de Expedición</b></label><span class="badge-warning">*</span>
    <input type="date" name="fexpedicion" required>

    <label for="psw"><b>Lugar Expedición</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Bogota" name="lexpedicion" required>

    <label for="psw"><b>Fecha de nacimiento del usuario</b></label><span class="badge-warning">*</span>
    <input type="date" name="cump" required>

    <label for="fotoperfil"><b>Foto de Perfil</b></label><span class="badge-info"> (Opcional)</span>
    <input type="file" name="fotoperfil" id="fotoperfil" accept="image/*">
    <div id="preview-foto" style="margin-top: 10px;">
        <img id="img-preview" src="" alt="Vista previa" style="max-width: 200px; max-height: 200px; display: none; border: 2px solid #27ae60; border-radius: 8px;">
    </div>


    <label for="psw"><b>Grupo sanguíneo del usuario</b></label><span class="badge-warning">*</span>
    <select required name="grp" id="grp">
        <option>Seleccione</option>
        <option value="A+">A+</option>
        <option value="A-">A-</option>
        <option value="O+">O+</option>
        <option value="O-">O-</option>
        <option value="B+">B+</option>
        <option value="B-">B-</option>
        <option value="AB+">AB-</option>
        <option value="AB-">AB-</option>

    </select>
   
    <label for="psw"><b>Estado Civil</b></label><span class="badge-warning">*</span>
    <select required name="ecivil" id="ecivil">
        <option>Seleccione</option>
        <option value="casado">Casado</option>
        <option value="soltero">Soltero</option>
        <option value="Viudos">Viudos</option>
        <option value="Union Libre">Union Libre</option>
    </select>

    <label for="psw"><b>Género del usuario</b></label><span class="badge-warning">*</span>
    <select required name="gep" id="gep">
        <option>Seleccione</option>
        <option value="Masculino">Masculino</option>
        <option value="Femenino">Femenino</option>
        <option value="Bisexual">Bisexual</option>
        <option value="Intersexual">Intersexual</option>
    </select>

    <hr>

    <label for="psw"><b>ZONA</b></label><span class="badge-warning">*</span>
    <select required name="zona" id="zona">
        <option>Seleccione</option>
        <option value="Urbana">Urbana</option>
        <option value="Rural">Rural</option>
        <option value="Centro Poblado">Centro Poblado</option>
    </select>  

    <label for="psw"><b>BARRIO</b></label><span class="badge-warning">*</span>
    <select required name="barrio" id="barrio">
        <option>Seleccione</option>
                <option value="la paz">La Paz</option>
                <option value="san jorge">San Jorge</option>
                <option value="san josé">San José</option>
                <option value="santa teresa">Santa Teresa</option>
                <option value="san rafael">San Rafael</option>
                <option value="el carmen">El Carmen</option>
                <option value="san martín">San Martín</option>
                <option value="villas de santa ana">Villas de Santa Ana</option>
                <option value="san juan">San Juan</option>
                <option value="santa isabel">Santa Isabel</option>
                <option value="el progreso">El Progreso</option>
                <option value="la inmaculada">La Inmaculada</option>
                <option value="balcones de san josé">Balcones de San José</option>
                <option value="el mirador">El Mirador</option>
                <option value="la reserva">La Reserva</option>
                <option value="parques del muña">Parques del Muña</option>
                <option value="garcía">García</option>
                <option value="pablo neruda">Pablo Neruda</option>
                <option value="alto charco">Alto Charco</option>
                <option value="bradamonte">Bradamonte</option>
                <option value="chacua">Chacua</option>
                <option value="las delicias">Las Delicias</option>
                <option value="el peñón">El Peñón</option>
                <option value="la unión">La Unión</option>
                <option value="el perico">El Perico</option>
                <option value="romeral">Romeral</option>
                <option value="san benito">San Benito</option>
                <option value="san eugenio">San Eugenio</option>
                <option value="san fortunato">San Fortunato</option>
                <option value="san miguel">San Miguel</option>
                <option value="san rafael rural">San Rafael Rural</option>
                <option value="usaba">Usaba</option>

    </select>  

   <label for="psw"><b>Dirección del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: calle los medanos" name="dip" required>

    <label for="psw"><b>Teléfono del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" maxlength="13" placeholder="ejm: +51 999 888 111" name="telp" required>

    <label for="psw"><b>¿El usuario tiene WhatsApp?</b></label><span class="badge-warning">*</span>
    <select required name="tiene_whatsapp" id="tiene_whatsapp">
        <option value="">Seleccione</option>
        <option value="SI">Sí</option>
        <option value="NO">No</option>
    </select>

    <label for="email"><b>correo</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="correo" name="correo" maxlength="70" required>
    
    <hr>

    <label for="psw"><b>sisben</b></label><span class="badge-warning">*</span>
    <select required name="sisben" id="sisben">
        <option>Seleccione</option>
        <option value="A1">A1</option>
        <option value="A2">A2</option>
        <option value="A3">A3</option>
        <option value="A4">A4</option>
        <option value="A5">A5</option>
        <option value="B1">B1</option>
        <option value="B2">B2</option>
        <option value="B3">B3</option>
        <option value="B4">B4</option>
        <option value="B5">B5</option>
        <option value="B6">B6</option>
        <option value="B7">B7</option>
        <option value="C1">C1</option>
        <option value="C2">C2</option>
        <option value="C3">C3</option>
        <option value="C4">C4</option>
        <option value="C5">C5</option>
        <option value="C6">C6</option>
        <option value="C7">C7</option>
        <option value="C8">C8</option>
        <option value="C9">C9</option>
        <option value="10">10</option>
        <option value="C11">C11</option>
        <option value="C12">C12</option>
        <option value="C13">C13</option>
        <option value="C14">C14</option>
        <option value="C15">C15</option>
        <option value="C16">C16</option>
        <option value="C17">C17</option>
        <option value="C18">C18</option>
        <option value="D1">D1</option>
        <option value="D2">D2</option>
        <option value="D3">D3</option>
        <option value="D4">D4</option>
        <option value="D5">D5</option>
        <option value="D6">D6</option>
        <option value="D7">D7</option>
        <option value="D8">D8</option>
        <option value="D9">D9</option>
        <option value="D10">D10</option>
        <option value="D11">D11</option>
        <option value="D12">D12</option>
        <option value="D13">D13</option>
        <option value="D14">D14</option>
        <option value="D15">D15</option>
        <option value="D16">D16</option>
        <option value="D17">D17</option>
        <option value="D18">D18</option>
        <option value="D19">D19</option>
        <option value="D20">D20</option>
        <option value="D21">D21</option>
    </select>  

    <label for="psw"><b>Recibe Bono</b></label><span class="badge-warning">*</span>
    <select required name="rbono" id="rbono">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    
    <label for="psw"><b>pensionado</b></label><span class="badge-warning">*</span>
    <select required name="pensionado" id="pensionado">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>Talla sudadera</b></label><span class="badge-warning">*</span>
    <select required name="tsudadera" id="tsudadera">
        <option>Seleccione</option>
        <option value="S">S</option>
        <option value="M">M</option>        
        <option value="L">L</option>        
        <option value="x">X</option>        
        <option value="xS">XS</option>        
        <option value="xL">XL</option>        
    </select>


    <label for="psw"><b>Talla chaqueta</b></label><span class="badge-warning">*</span>
    <select required name="tchaqueta" id="tchaqueta">
        <option>Seleccione</option>
        <option value="S">S</option>
        <option value="M">M</option>        
        <option value="L">L</option>        
        <option value="x">X</option>        
        <option value="xS">XS</option>        
        <option value="xL">XL</option>        
    </select>


    <label for="email"><b>Talla zapatos</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="tzapatos" name="tzapatos" maxlength="8" required>

    

    
   
    <hr>

    <label for="email"><b>¿ CUAL CONSIDERA USTED QUE ES SU MAYOR FORTALEZA O TALENTO ?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="talentof" name="talentof" maxlength="30" required>

    <label for="psw"><b>EL ADULTO MAYOR INGRESA Y SE VA SOLO DE PROGRAMA</b></label><span class="badge-warning">*</span>
    <select required name="rbono" id="rbono">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

   
    <label for="email"><b>¿Con quien Vive?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="vivecomp" name="vivecomp" maxlength="30" required>
   

    <label for="psw"><b>¿La persona Mayor considera que posee red de apoyo?</b></label><span class="badge-warning">*</span>
    <select required name="redapoyo" id="redapoyo">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <hr>

    <label for="email"><b>Nombre  y apellido del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="cuidador" name="cuidador" maxlength="30" required>
    <hr>

    <label for="psw"><b>Parentesco del Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="pcuidador" id="pcuidador">
        <option>Seleccione</option>
        <option value="CÓNYUGE y/o COMPAÑERO">ACÓNYUGE y/o COMPAÑERO</option>
        <option value="Hijo">Hijo</option>
        <option value="Familia">Familia</option>
        <option value="Vecinoamigo">Vecino o Amigo</option>
        <option value="Institucional">Institucional</option>
    </select>

    <label for="psw"><b>Zona Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="zcuidador" id="zcuidador">
        <option>Seleccione</option>
        <option value="Urbano">Urbano</option>
        <option value="Rural">Rural</option>
        <option value="CentroP">Centro Poblado</option>
    </select>

    <label for="psw"><b>Barrio, Vereda, Centro Poblado del cuidador</b></label><span class="badge-warning">*</span>
    <select required name="bvccuidador" id="bvccuidador">
        <option>Seleccione</option>
         <option value="la paz">La Paz</option>
                <option value="san jorge">San Jorge</option>
                <option value="san josé">San José</option>
                <option value="santa teresa">Santa Teresa</option>
                <option value="san rafael">San Rafael</option>
                <option value="el carmen">El Carmen</option>
                <option value="san martín">San Martín</option>
                <option value="villas de santa ana">Villas de Santa Ana</option>
                <option value="san juan">San Juan</option>
                <option value="santa isabel">Santa Isabel</option>
                <option value="el progreso">El Progreso</option>
                <option value="la inmaculada">La Inmaculada</option>
                <option value="balcones de san josé">Balcones de San José</option>
                <option value="el mirador">El Mirador</option>
                <option value="la reserva">La Reserva</option>
                <option value="parques del muña">Parques del Muña</option>
                <option value="garcía">García</option>
                <option value="pablo neruda">Pablo Neruda</option>
                <option value="alto charco">Alto Charco</option>
                <option value="bradamonte">Bradamonte</option>
                <option value="chacua">Chacua</option>
                <option value="las delicias">Las Delicias</option>
                <option value="el peñón">El Peñón</option>
                <option value="la unión">La Unión</option>
                <option value="el perico">El Perico</option>
                <option value="romeral">Romeral</option>
                <option value="san benito">San Benito</option>
                <option value="san eugenio">San Eugenio</option>
                <option value="san fortunato">San Fortunato</option>
                <option value="san miguel">San Miguel</option>
                <option value="san rafael rural">San Rafael Rural</option>
                <option value="usaba">Usaba</option>
    </select>

    <label for="email"><b>Direccion del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="dcuidador" name="dcuidador" maxlength="30" required>
    
    <label for="email"><b>Telefono Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="tcuidador" name="tcuidador" maxlength="30" required>
    <hr>

    <label for="psw"><b>Que SGSSS</b></label><span class="badge-warning">*</span>
    <select required name="sgsss" id="sgsss">
        <option>Seleccione</option>
        <option value="Contributivo">Contributivo</option>
        <option value="Subsidiado">Subsidiado</option>
        <option value="Regimen Especial">Regimen Especial</option>
        <option value="No Asegurado">No Asegurado</option>
    </select>

    <label for="psw"><b>Que EPS</b></label><span class="badge-warning">*</span>
    <select required name="eps" id="eps">
        <option>Seleccione</option>
        <option value="SANITAS">SANITAS</option>
        <option value="SALUD TOTAL">SALUD TOTAL</option>
        <option value="Compensar">Compensar</option>
        <option value="Cruz verde">Cruz verde</option>
        <option value="Nueva EPS">Nueva EPS</option>
        <option value="Coosalud EPS-S">Coosalud EPS-S</option>
        <option value="Mutual SER">Mutual SER</option>
        <option value="Salud MIA">Salud MIA</option>
        <option value="Aliansalud EPS">Aliansalud EPS</option>
        <option value="Salud Total EPS S.A.">Salud Total EPS S.A.</option>
        <option value="EPS Sanitas">EPS Sanitas</option>
        <option value="EPS Sura">EPS Sura</option>
        <option value="Famisanar EPS">Famisanar EPS</option>
        <option value="Servicio Occidental de Salud EPS – SOS">Servicio Occidental de Salud EPS – SOS</option>
        <option value="Comfenalco Valle">Comfenalco Valle</option>
        <option value="Compensar EPS">Compensar EPS</option>
        <option value="Empresas Públicas de Medellín EPM">Empresas Públicas de Medellín EPM</option>
        <option value="Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia">Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia</option>
        <option value="Cajacopi Atlántico">Cajacopi Atlántico</option>
        <option value="Capresoca EPS">Capresoca EPS</option>
        <option value="Comfachocó">Comfachocó</option>
        <option value="Comfaoriente">Comfaoriente</option>
        <option value="EPS Familiar de Colombia">EPS Familiar de Colombia</option>
        <option value="Asmet Salud EPS">Asmet Salud EPS</option>
        <option value="Emssanar E.S.S.">Emssanar E.S.S.</option>
        <option value="Capital Salud EPS-S">Capital Salud EPS-S</option>
        <option value="Savia Salud EPS">Savia Salud EPS</option>
        <option value="Dusakawi EPSI">Dusakawi EPSI</option>
        <option value="Asociación Indígena del Cauca EPSI">Asociación Indígena del Cauca EPSI</option>
        <option value="Anas Wayuu EPSI">Anas Wayuu EPSI</option>
        <option value="Mallamas EPSI">Mallamas EPSI</option>
        <option value="Pijaos Salud EPSI">Pijaos Salud EPSI</option>
    </select>

    <label for="psw"><b>Que ETNIA</b></label><span class="badge-warning">*</span>
    <select required name="etnia" id="etnia">
        <option>Seleccione</option>
        <option value="INDIGENA">INDIGENA</option>
        <option value="AFROCOLOMBIANO">AFRO COLOMBIANO</option>
        <option value="ROM-GITANO">ROM-GITANO</option>
        <option value="PALENQUERO">PALENQUERO</option>
        <option value="RAIZAL">RAIZAL</option>
        <option value="NINGUNO">NINGUNO</option>
    </select>

    <label for="psw"><b>Nivel Maximo Alcanzado</b></label><span class="badge-warning">*</span>
    <select required name="educacion" id="educacion">
        <option>Seleccione</option>
        <option value="PRIMARIA">PRIMARIA</option>
        <option value="SECUNDARIA">SECUNDARIA</option>
        <option value="TECNICA">TECNICA</option>
        <option value="SUPERIOR">SUPERIOR </option>
        <option value="NINGUNO">NINGUNO </option>
    </select>

    <label for="psw"><b>Sabe leer y escribir</b></label><span class="badge-warning">*</span>
    <select required name="leer" id="leer">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace uso de las tecnologias?</b></label><span class="badge-warning">*</span>
    <select required name="utecnologia" id="utecnologia">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace parte de una poblaciòn diferencial o de inclusion?</b></label><span class="badge-warning">*</span>
    <select required name="poblaciond" id="poblaciond">
        <option>Seleccione</option>
        <option value="discapacidad">discapacidad</option>
        <option value="situacion_especial">en situaciòn de proteccion especial</option>        
        <option value="desplazada">poblacion desplazada</option>
        <option value="vulnerable">En SItuaciòn de Vulneración</option>
        <option value="cuidado_terceros">Persona que se encuentra al cuidado de tercero</option>
        <option value="abandono">Situaciòn de abandono</option>
        <option value="habitante calle">Habitante de calle</option>
        <option value="victima">Victima del conflicto armado</option>
        <option value="Reinsertado">Reinsertado</option>
        <option value="ninguno">ninguno</option>
    </select>

    <label for="psw"><b>¿Hace parte de poblacion diferencial por oficio?</b></label><span class="badge-warning">*</span>
    <select required name="poblacionoficio" id="poblacionoficio">
        <option>Seleccione</option>
        <option value="Reciclador">Reciclador</option>
        <option value="Bodegueros">Pequños Bodegueros</option>        
        <option value="vendedor">Vendedor Ambulante</option>
        <option value="ninguno">ninguno</option>
    </select>

    <hr>

    
    <!-- Sección QR -->
<label for="qrInput"><b>Genera tu Carnet</b></label><span class="badge-warning">*</span>
<div style="display: flex; align-items: center;">
    <input type="text" placeholder="qrInput" name="qrInput" id="qrInput" maxlength="8" required readonly>
    <button type="button" onclick="generateQR()" style="margin-left: 10px; padding: 5px 10px;">Generar QR</button>
</div>
<div id="qrCode" style="margin-top: 10px; text-align: center; font-family: Arial, sans-serif;"></div>

<!-- Botón de descarga (oculto inicialmente) -->
<button type="button" id="downloadQRBtn" style="display: none; margin: 10px 0; padding: 8px 15px; background: #27ae60; color: white; border: none; border-radius: 4px; cursor: pointer;">
    <i class='bx bx-download'></i> Descargar QR
</button>

<button type="submit" name="add_patiens" class="registerbtn">Guardar</button>
</form>
 

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
<?php include_once '../../backend/php/add_patiens.php' ?>

    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>

    <!-- Script para Barra de Progreso -->
    <style>
        .progress-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 20px;
            margin: 20px 0;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            color: white;
            transition: all 0.3s ease;
        }
        
        .progress-container.fixed {
            position: fixed;
            top: 70px;
            left: 280px;
            right: 20px;
            z-index: 1000;
            margin: 0;
            animation: slideDown 0.3s ease;
        }
        
        @keyframes slideDown {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .progress-placeholder {
            height: 0;
            transition: height 0.3s ease;
        }
        
        .progress-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .progress-title {
            font-size: 18px;
            font-weight: bold;
        }
        
        .progress-percentage {
            font-size: 28px;
            font-weight: bold;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }
        
        .progress-bar-bg {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 25px;
            height: 30px;
            overflow: hidden;
            position: relative;
        }
        
        .progress-bar-fill {
            background: linear-gradient(90deg, #27ae60, #2ecc71, #27ae60);
            background-size: 200% 100%;
            height: 100%;
            border-radius: 25px;
            transition: width 0.4s ease, background-position 0.3s ease;
            animation: shimmer 2s infinite;
            box-shadow: 0 2px 10px rgba(46, 204, 113, 0.5);
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding-right: 10px;
            width: 0%;
        }
        
        @keyframes shimmer {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        .progress-info {
            margin-top: 10px;
            text-align: center;
            font-size: 14px;
            opacity: 0.9;
        }
        
        .progress-bar-fill::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            animation: slide 2s infinite;
        }
        
        @keyframes slide {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
    </style>
    
    <script>
        // Script para actualizar la barra de progreso usando jQuery
        $(document).ready(function() {
            console.log('Iniciando barra de progreso...');
            
            // Variables para el scroll fijo
            var $progressContainer = $('.progress-container');
            var progressOffset = $progressContainer.offset().top;
            var progressHeight = $progressContainer.outerHeight();
            var isFixed = false;
            
            // Función para manejar el scroll
            $(window).scroll(function() {
                var scrollTop = $(window).scrollTop();
                
                if (scrollTop > progressOffset - 70 && !isFixed) {
                    // Fijar la barra
                    $progressContainer.addClass('fixed');
                    // Agregar placeholder para evitar saltos
                    $progressContainer.after('<div class="progress-placeholder" style="height:' + progressHeight + 'px"></div>');
                    isFixed = true;
                } else if (scrollTop <= progressOffset - 70 && isFixed) {
                    // Desfijar la barra
                    $progressContainer.removeClass('fixed');
                    $('.progress-placeholder').remove();
                    isFixed = false;
                }
            });
            
            var $form = $('form');
            var $progressBarFill = $('#progressBarFill');
            var $progressPercentage = $('#progressPercentage');
            var $fieldsCompletedSpan = $('#fieldsCompleted');
            var $totalFieldsSpan = $('#totalFields');
            
            // Obtener todos los campos requeridos excluyendo botones y el campo qrInput (que se genera automáticamente)
            var $requiredFields = $form.find('[required]').not('button, [type="submit"], [type="button"], #qrInput');
            var totalFields = $requiredFields.length;
            
            console.log('Total de campos requeridos:', totalFields);
            $totalFieldsSpan.text(totalFields);
            
            // Función para calcular el progreso
            function updateProgress() {
                var completedFields = 0;
                
                $requiredFields.each(function() {
                    var $field = $(this);
                    var fieldType = $field.attr('type');
                    var tagName = $field.prop('tagName');
                    
                    if (fieldType === 'checkbox' || fieldType === 'radio') {
                        // Para checkboxes y radios
                        if ($field.is(':checked')) {
                            completedFields++;
                        }
                    } else if (tagName === 'SELECT') {
                        // Para selects
                        var value = $field.val();
                        if (value && value !== 'Seleccione' && value.trim() !== '') {
                            completedFields++;
                        }
                    } else if (fieldType === 'file') {
                        // Para archivos
                        if ($field[0].files && $field[0].files.length > 0) {
                            completedFields++;
                        }
                    } else {
                        // Para inputs de texto, date, email, password, etc.
                        var value = $field.val();
                        if (value && value.trim() !== '') {
                            completedFields++;
                        }
                    }
                });
                
                // Calcular porcentaje
                var percentage = Math.round((completedFields / totalFields) * 100);
                
                console.log('Campos completados:', completedFields, 'de', totalFields, '(' + percentage + '%)');
                
                // Actualizar la UI
                $progressBarFill.css('width', percentage + '%');
                $progressPercentage.text(percentage + '%');
                $fieldsCompletedSpan.text(completedFields);
                
                // Cambiar color según el progreso
                if (percentage < 30) {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #e74c3c, #c0392b)');
                } else if (percentage < 70) {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #f39c12, #e67e22)');
                } else {
                    $progressBarFill.css('background', 'linear-gradient(90deg, #27ae60, #2ecc71)');
                }
            }
            
            // Agregar listeners a todos los campos usando delegación de eventos
            $form.on('input change', '[required]', function() {
                updateProgress();
            });
            
            // También escuchar blur para asegurar que se actualice
            $form.on('blur', '[required]', function() {
                updateProgress();
            });
            
            // Calcular progreso inicial
            setTimeout(function() {
                updateProgress();
            }, 500);
            
            console.log('Barra de progreso inicializada correctamente');
        });
    </script>
    

    <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie and expiry time=1 minute
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>


<!-- Script para previsualizar la imagen -->
<script>
document.getElementById('fotoperfil').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('img-preview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    } else {
        preview.style.display = 'none';
    }
});
</script>




<!-- Script de generación QR modificado -->
<script>
    // Variable para almacenar el QR generado
    let currentQR = null;

    // Función para generar QR
    function generateQR() {
        const documento = document.querySelector('input[name="nhi"]').value;
        const nombre = document.querySelector('input[name="namp"]').value;
        const apellido = document.querySelector('input[name="apep"]').value;
        const tipoDoc = document.querySelector('select[name="tdocumento"]').value;


        if (!documento || !nombre || !apellido) {
            alert("Por favor complete documento, nombre y apellido primero");
            return;
        }

        document.getElementById('qrInput').value = documento;
        const qrContainer = document.getElementById("qrCode");
        qrContainer.innerHTML = "<p>Generando QR...</p>";

        QRCode.toDataURL(documento, {
            width: 150,
            margin: 1,
            color: { dark: "#000000", light: "#FFFFFF" }
        }, function(error, url) {
            if (error) {
                qrContainer.innerHTML = "<p style='color:red;'>Error al generar QR</p>";
                return;
            }

            currentQR = url; // Almacenamos el QR generado
            
            qrContainer.innerHTML = `
                <div style="border:1px solid #ddd;padding:10px;display:inline-block;background:white;">
                    <div style="text-align:left;margin-bottom:5px;">
                        <p style="margin:2px 0;font-size:14px;"><strong>Nombre:</strong> ${nombre} ${apellido}</p>
                        <p style="margin:2px 0;font-size:14px;"><strong>${tipoDoc}:</strong> ${documento}</p>
                    </div>
                    <img src="${url}" alt="Código QR" style="width:150px;">
                </div>`;
            
            // Mostrar botón de descarga
            document.getElementById('downloadQRBtn').style.display = 'inline-block';
        });
    }

// Función para descargar QR con foto del usuario
document.getElementById('downloadQRBtn').addEventListener('click', async function() {
    if (!currentQR) return;
    
    const nombre = document.querySelector('input[name="namp"]').value;
    const apellido = document.querySelector('input[name="apep"]').value;
    const documento = document.querySelector('input[name="nhi"]').value;
    const tipoDoc = document.querySelector('select[name="tdocumento"]').value;
    const modalidad = document.querySelector('select[name="modalidad"]')?.value || 'N/A';
    const imgPreview = document.getElementById('img-preview');
    const fotoInput = document.getElementById('fotoperfil');

    // Función para cargar una imagen (con CORS tolerante)
    function loadImage(src) {
        return new Promise((resolve, reject) => {
            const img = new Image();
            try { img.crossOrigin = 'anonymous'; } catch(e) {}
            img.onload = () => resolve(img);
            img.onerror = (err) => reject(err || new Error('IMAGE_LOAD_ERROR'));
            img.src = src;
        });
    }

    try {
        // Cargar las imágenes del carnet
        const [carnetFrontal, carnetPosterior] = await Promise.all([
            loadImage('../../backend/img/1-carnet.jpg'),
            loadImage('../../backend/img/2-carnet2.jpg')
        ]);

        // Crear canvas para la cara frontal
        const canvasFront = document.createElement('canvas');
        const ctxFront = canvasFront.getContext('2d');
        canvasFront.width = carnetFrontal.width;
        canvasFront.height = carnetFrontal.height;
        
        // Dibujar la imagen del carnet frontal
        ctxFront.drawImage(carnetFrontal, 0, 0);
        
        // Función para procesar y dibujar la foto
        async function procesarFoto() {
            let fotoUsuarioSrc = null;
            
            // Verificar si hay foto seleccionada
            if (fotoInput && fotoInput.files && fotoInput.files[0]) {
                fotoUsuarioSrc = await new Promise((resolve) => {
                    const reader = new FileReader();
                    reader.onload = (e) => resolve(e.target.result);
                    reader.readAsDataURL(fotoInput.files[0]);
                });
            } else if (imgPreview && imgPreview.src && imgPreview.src !== '' && imgPreview.style.display !== 'none') {
                // Si hay foto en el preview, usarla
                fotoUsuarioSrc = imgPreview.src;
            } else {
                // Si no hay foto, usar la predeterminada
                fotoUsuarioSrc = '../../backend/img/foto-perfil.png';
            }
            
            // Cargar la foto (seleccionada o predeterminada)
            let fotoUsuario = null;
            try {
                fotoUsuario = await loadImage(fotoUsuarioSrc);
            } catch (e) {
                console.warn('No se pudo cargar la foto, intentando con foto predeterminada.', e);
                try {
                    fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
                } catch (defaultError) {
                    console.warn('No se pudo cargar la foto predeterminada:', defaultError);
                    fotoUsuario = null;
                }
            }

            // Dibujar la foto del usuario centrada (solo si cargó correctamente)
            if (fotoUsuario) {
                    const targetWidth = 175;
                    const targetHeight = 175;
                    const centerX = canvasFront.width / 2;
                    const centerY = 215;

                    const imgAspect = fotoUsuario.width / fotoUsuario.height;
                    let drawWidth, drawHeight, drawX, drawY;

                    if (imgAspect > 1) {
                        drawHeight = targetHeight;
                        drawWidth = drawHeight * imgAspect;
                        if (drawWidth > targetWidth) {
                            drawWidth = targetWidth;
                            drawHeight = drawWidth / imgAspect;
                        }
                    } else {
                        drawWidth = targetWidth;
                        drawHeight = drawWidth / imgAspect;
                        if (drawHeight > targetHeight) {
                            drawHeight = targetHeight;
                            drawWidth = drawHeight * imgAspect;
                        }
                    }

                    drawX = centerX - (drawWidth / 2);
                    drawY = centerY - (drawHeight / 2);

                    ctxFront.drawImage(fotoUsuario, drawX, drawY, drawWidth, drawHeight);
                }
            }
            
            // Función para dividir texto en múltiples líneas
            function wrapText(context, text, x, y, maxWidth, lineHeight) {
                const words = text.split(' ');
                let line = '';
                let currentY = y;
                
                for (let n = 0; n < words.length; n++) {
                    const testLine = line + words[n] + ' ';
                    const metrics = context.measureText(testLine);
                    const testWidth = metrics.width;
                    
                    if (testWidth > maxWidth && n > 0) {
                        context.fillText(line, x, currentY);
                        line = words[n] + ' ';
                        currentY += lineHeight;
                    } else {
                        line = testLine;
                    }
                }
                context.fillText(line, x, currentY);
                return currentY;
            }
            
            // Agregar datos del usuario
            ctxFront.fillStyle = '#000000';
            
            const nombreCompleto = `${nombre} ${apellido}`.toUpperCase();
            let fontSize = 18;
            if (nombreCompleto.length > 30) {
                fontSize = 14;
            } else if (nombreCompleto.length > 25) {
                fontSize = 16;
            }
            
            ctxFront.font = `bold ${fontSize}px Arial`;
            ctxFront.textAlign = 'center';
            
            // Usar wrapText para dividir el nombre en múltiples líneas si es necesario
            const maxWidth = 320; // Ancho máximo disponible
            const lineHeight = fontSize + 4; // Espaciado entre líneas
            const startY = 340; // Posición Y inicial
            
            // wrapText retorna la última posición Y usada
            const lastNameY = wrapText(ctxFront, nombreCompleto, canvasFront.width / 2, startY, maxWidth, lineHeight);
            
            // Cédula centrada (con espacio dinámico después del nombre)
            const cedulaY = lastNameY + 30; // 30px de separación desde la última línea del nombre
            ctxFront.font = 'bold 16px Arial';
            ctxFront.fillStyle = '#000000';
            ctxFront.textAlign = 'center';
            ctxFront.fillText(`${tipoDoc.toUpperCase()}: ${documento}`, canvasFront.width / 2, cedulaY);
            
            // Modalidad debajo del documento - centrada (con espacio dinámico)
            const modalidadY = cedulaY + 25; // 25px de separación desde la cédula
            ctxFront.font = 'bold 14px Arial';
            ctxFront.fillStyle = '#000000';
            ctxFront.textAlign = 'center';
            ctxFront.fillText(`${modalidad.toUpperCase()}`, canvasFront.width / 2, modalidadY);
            
            // Crear canvas para la cara posterior
            const canvasBack = document.createElement('canvas');
            const ctxBack = canvasBack.getContext('2d');
            canvasBack.width = carnetPosterior.width;
            canvasBack.height = carnetPosterior.height;
            
            // Dibujar la imagen del carnet posterior
            ctxBack.drawImage(carnetPosterior, 0, 0);
            
            // Cargar y dibujar el QR
            const qrImg = await loadImage(currentQR);
            const qrSize = 180;
            const qrX = (canvasBack.width - qrSize) / 2;
            const qrY = (canvasBack.height - qrSize) / 2 - 50;
            ctxBack.drawImage(qrImg, qrX, qrY, qrSize, qrSize);
            
            // Crear canvas final para combinar ambas caras
            const finalCanvas = document.createElement('canvas');
            const ctxFinal = finalCanvas.getContext('2d');
            finalCanvas.width = canvasFront.width;
            finalCanvas.height = canvasFront.height * 2 + 20;
            
            // Dibujar ambas caras
            ctxFinal.drawImage(canvasFront, 0, 0);
            ctxFinal.drawImage(canvasBack, 0, canvasFront.height + 20);
            
            // Descargar el carnet (con protección ante errores de toDataURL)
            const link = document.createElement('a');
            link.download = `Carnet_${nombre}_${apellido}.png`;
            try {
                link.href = finalCanvas.toDataURL('image/png');
            } catch (e) {
                console.warn('Fallo toDataURL, intentando toBlob...', e);
                await new Promise((resolve) => finalCanvas.toBlob((blob) => {
                    if (blob) {
                        const url = URL.createObjectURL(blob);
                        link.href = url;
                    }
                    resolve();
                }));
            }
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        
        await procesarFoto();
        
    } catch (error) {
        console.error('Error al generar el carnet:', error);
        alert('Error al generar el carnet. Por favor, inténtelo de nuevo.');
    }
});
</script>

<style>
/* Convertir texto de todos los select a mayúsculas */
select, select option {
    text-transform: uppercase;
}
</style>

<script>
// Función de validación del formulario
function validacion() {
    // Objeto con los campos requeridos y sus etiquetas amigables
    const camposRequeridos = {
        'modalidad': 'Modalidad',
        'tusuario': 'Tipo de Usuario',
        'namp': 'Nombres del usuario',
        'apep': 'Apellido del usuario',
        'tdocumento': 'Tipo de Documento',
        'nhi': 'Documento de identidad',
        'fexpedicion': 'Fecha de Expedición',
        'lexpedicion': 'Lugar de Expedición',
        'cump': 'Fecha de nacimiento',
        // 'fotoperfil': 'Foto de Perfil', // OPCIONAL - Comentado para hacerlo opcional
        'grp': 'Grupo sanguíneo',
        'ecivil': 'Estado Civil',
        'gep': 'Género',
        'zona': 'Zona',
        'barrio': 'Barrio',
        'dip': 'Dirección',
        'telp': 'Teléfono',
        'tiene_whatsapp': '¿Tiene WhatsApp?',
        'correo': 'Correo electrónico',
        'sisben': 'Sisben',
        'rbono': 'Recibe Bono',
        'pensionado': 'Pensionado',
        'tsudadera': 'Talla sudadera',
        'tchaqueta': 'Talla chaqueta',
        'tzapatos': 'Talla zapatos',
        'talentof': 'Mayor fortaleza o talento',
        'vivecomp': '¿Con quién vive?',
        'redapoyo': '¿Posee red de apoyo?',
        'cuidador': 'Nombre del Cuidador',
        'pcuidador': 'Parentesco del Cuidador',
        'zcuidador': 'Zona del Cuidador',
        'bvccuidador': 'Barrio del Cuidador',
        'dcuidador': 'Dirección del Cuidador',
        'tcuidador': 'Teléfono del Cuidador',

        'sgsss': 'SGSSS',
        'eps': 'EPS',
        'etnia': 'Etnia',
        'educacion': 'Nivel Máximo Alcanzado',
        'leer': 'Sabe leer y escribir',
        'utecnologia': 'Uso de tecnologías',
        'poblaciond': 'Población diferencial',
        'poblacionoficio': 'Población diferencial por oficio',
        'qrInput': 'Código QR'
    };

    // Validar cada campo
    for (let campo in camposRequeridos) {
        const elemento = document.querySelector(`[name="${campo}"]`);
        
        if (!elemento) continue; // Si el elemento no existe, continuar
        
        const tipo = elemento.type;
        const etiqueta = camposRequeridos[campo];
        
        // Validar según el tipo de campo
        if (tipo === 'file') {
            // Para archivos, verificar si se seleccionó un archivo
            if (!elemento.files || elemento.files.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campo Requerido',
                    text: `Por favor, seleccione: ${etiqueta}`,
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Entendido'
                });
                elemento.focus();
                return false;
            }
        } else if (tipo === 'select-one' || elemento.tagName === 'SELECT') {
            // Para selects, verificar que no sea "Seleccione" o vacío
            const valor = elemento.value.trim();
            if (!valor || valor === 'Seleccione' || valor === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campo Requerido',
                    text: `Por favor, seleccione: ${etiqueta}`,
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Entendido'
                });
                elemento.focus();
                return false;
            }
        } else {
            // Para inputs de texto, date, etc.
            const valor = elemento.value.trim();
            if (!valor || valor === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campo Requerido',
                    text: `Por favor, complete: ${etiqueta}`,
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Entendido'
                });
                elemento.focus();
                return false;
            }
        }
    }
    
    // Validación especial para el QR
    const qrInput = document.getElementById('qrInput');
    if (!qrInput.value || qrInput.value.trim() === '') {
        Swal.fire({
            icon: 'warning',
            title: 'QR Requerido',
            text: 'Por favor, genere el código QR antes de guardar',
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'Entendido'
        });
        return false;
    }
    
    // Validación de formato de correo electrónico
    const correo = document.querySelector('[name="correo"]').value;
    const regexCorreo = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!regexCorreo.test(correo)) {
        Swal.fire({
            icon: 'warning',
            title: 'Correo Inválido',
            text: 'Por favor, ingrese un correo electrónico válido',
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'Entendido'
        });
        document.querySelector('[name="correo"]').focus();
        return false;
    }
    
    // Si todas las validaciones pasaron, mostrar mensaje de procesamiento
    Swal.fire({
        title: 'Guardando...',
        text: 'Por favor espere mientras se guarda el usuario',
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    return true; // Permitir el envío del formulario
}
</script>

</body>
</html>
