<?php
session_start();
require 'backend/bd/Conexion.php';

echo "<h1>Recargar Permisos en Sesión Actual</h1>";

if(!isset($_SESSION['id'])) {
    echo "<p style='color: red;'>No hay sesión activa</p>";
    exit();
}

echo "<h2>Usuario Actual:</h2>";
echo "<p>ID: {$_SESSION['id']}</p>";
echo "<p>Username: {$_SESSION['username']}</p>";

echo "<h2>Permisos ANTES de recargar:</h2>";
if(isset($_SESSION['menu_permissions'])) {
    echo "<pre>";
    print_r($_SESSION['menu_permissions']);
    echo "</pre>";
}

// Recargar permisos desde la base de datos
try {
    $permsStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
    $permsStmt->execute([$_SESSION['id']]);
    $menuPerms = $permsStmt->fetch(PDO::FETCH_ASSOC);
    
    if($menuPerms !== false) {
        $_SESSION['has_custom_permissions'] = true;
        $_SESSION['menu_permissions'] = $menuPerms;
        echo "<p style='color: green;'>✅ Permisos recargados desde la base de datos</p>";
    } else {
        $_SESSION['has_custom_permissions'] = false;
        $_SESSION['menu_permissions'] = [];
        echo "<p style='color: orange;'>⚠️ No se encontraron permisos personalizados</p>";
    }
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<h2>Permisos DESPUÉS de recargar:</h2>";
if(isset($_SESSION['menu_permissions'])) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Módulo</th><th>Valor</th><th>Estado</th></tr>";
    foreach($_SESSION['menu_permissions'] as $key => $value) {
        if($key != 'id' && $key != 'user_id') {
            $estado = $value == 1 ? '✅ Habilitado' : '❌ Deshabilitado';
            $color = $value == 1 ? 'lightgreen' : 'lightcoral';
            echo "<tr style='background: $color;'>";
            echo "<td><strong>$key</strong></td>";
            echo "<td>$value</td>";
            echo "<td>$estado</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
}

echo "<hr>";
echo "<h2>✅ Listo!</h2>";
echo "<p>Ahora recarga cualquier página del sistema y verás los permisos actualizados.</p>";
echo "<p><a href='frontend/profesionales/dashboard_enfermeria.php'>Ir al Dashboard</a></p>";
?>
