-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1:3306
-- Tiempo de generación: 26-01-2026 a las 14:32:45
-- Versión del servidor: 9.1.0
-- Versión de PHP: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `citas_medicas`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_cursos`
--

DROP TABLE IF EXISTS `asistencia_cursos`;
CREATE TABLE IF NOT EXISTS `asistencia_cursos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL COMMENT 'Documento del usuario',
  `nompa` varchar(100) DEFAULT NULL COMMENT 'Nombre del usuario',
  `apepa` varchar(100) DEFAULT NULL COMMENT 'Apellido del usuario',
  `idcurso` int NOT NULL COMMENT 'ID del curso',
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`),
  KEY `idx_fecha` (`fecha`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabla de asistencia exclusiva para cursos';

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_qr`
--

DROP TABLE IF EXISTS `asistencia_qr`;
CREATE TABLE IF NOT EXISTS `asistencia_qr` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL,
  `nompa` varchar(100) DEFAULT NULL,
  `apepa` varchar(100) DEFAULT NULL,
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `asistencia_qr`
--

INSERT INTO `asistencia_qr` (`id`, `documento`, `nompa`, `apepa`, `fecha`, `tipo`, `motivo`) VALUES
(1, '65564', 'JUAN', 'ASDS', '2026-01-23 19:28:41', 'ENTRADA', ''),
(2, '65564', 'JUAN', 'ASDS', '2026-01-23 19:29:15', 'SALIDA', 'Enfermo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `base`
--

DROP TABLE IF EXISTS `base`;
CREATE TABLE IF NOT EXISTS `base` (
  `idb` int NOT NULL AUTO_INCREMENT,
  `base` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cart`
--

DROP TABLE IF EXISTS `cart`;
CREATE TABLE IF NOT EXISTS `cart` (
  `idv` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `idprcd` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  PRIMARY KEY (`idv`),
  KEY `user_id` (`user_id`),
  KEY `idprcd` (`idprcd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `category`
--

DROP TABLE IF EXISTS `category`;
CREATE TABLE IF NOT EXISTS `category` (
  `idcat` int NOT NULL AUTO_INCREMENT,
  `nomcat` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idcat`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `consult`
--

DROP TABLE IF EXISTS `consult`;
CREATE TABLE IF NOT EXISTS `consult` (
  `idconslt` int NOT NULL AUTO_INCREMENT,
  `mtcl` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `signo_vital` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SV` varchar(22) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TMP` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `T` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `P` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `IMC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TV` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CB_CL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NEU` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TRX` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DOR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ABD` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PIE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GUN` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `EXT` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LIM` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idconslt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cursos`
--

DROP TABLE IF EXISTS `cursos`;
CREATE TABLE IF NOT EXISTS `cursos` (
  `idcurso` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `quien_lo_da` varchar(100) NOT NULL,
  `es_titulado` enum('sí','no') NOT NULL,
  `en_que` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`idcurso`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `doctor`
--

DROP TABLE IF EXISTS `doctor`;
CREATE TABLE IF NOT EXISTS `doctor` (
  `idodc` int NOT NULL AUTO_INCREMENT,
  `ceddoc` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nodoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apdoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomesp` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direcd` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sexd` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phd` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacd` date NOT NULL,
  `corr` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idodc`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `document`
--

DROP TABLE IF EXISTS `document`;
CREATE TABLE IF NOT EXISTS `document` (
  `iddoc` int NOT NULL AUTO_INCREMENT,
  `nomfi` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`iddoc`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `document`
--

INSERT INTO `document` (`iddoc`, `nomfi`, `foto`, `idpa`, `nompa`, `state`, `fere`) VALUES
(6, 'eps', '618916.png', 746, 'JUAN', '1', '2026-01-23 19:50:38'),
(7, 'SISBEN', '747515.png', 747, 'JHON RUBIANO', '1', '2026-01-26 12:22:34'),
(8, '', '961381.pdf', 747, 'JHON RUBIANO', '1', '2026-01-26 12:22:58'),
(9, 'cedula', '332876.png', 748, 'JUAN', '1', '2026-01-26 14:30:24'),
(10, 'eps', '266174.jpg', 748, 'JUAN', '1', '2026-01-26 14:30:52');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `events`
--

DROP TABLE IF EXISTS `events`;
CREATE TABLE IF NOT EXISTS `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `idodc` int NOT NULL,
  `idlab` int NOT NULL,
  `color` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `chec` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`),
  KEY `idodc` (`idodc`),
  KEY `idlab` (`idlab`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `fisioterapia`
--

DROP TABLE IF EXISTS `fisioterapia`;
CREATE TABLE IF NOT EXISTS `fisioterapia` (
  `id` int NOT NULL AUTO_INCREMENT,
  `idpa` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nompa` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fere` datetime NOT NULL,
  `sentarse_levantarse` text COLLATE utf8mb4_unicode_ci,
  `flexiones_brazo` text COLLATE utf8mb4_unicode_ci,
  `flexion_tronco` text COLLATE utf8mb4_unicode_ci,
  `juntar_manos_atras` text COLLATE utf8mb4_unicode_ci,
  `romberg` text COLLATE utf8mb4_unicode_ci,
  `ipaq` text COLLATE utf8mb4_unicode_ci,
  `alcance_funcional` text COLLATE utf8mb4_unicode_ci,
  `barthel` text COLLATE utf8mb4_unicode_ci,
  `funcionalidad` text COLLATE utf8mb4_unicode_ci,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `genogram`
--

DROP TABLE IF EXISTS `genogram`;
CREATE TABLE IF NOT EXISTS `genogram` (
  `idge` int NOT NULL AUTO_INCREMENT,
  `detage` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idge`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `idiom`
--

DROP TABLE IF EXISTS `idiom`;
CREATE TABLE IF NOT EXISTS `idiom` (
  `idoma` int NOT NULL AUTO_INCREMENT,
  `nomidi` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idoma`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `inscripciones`
--

DROP TABLE IF EXISTS `inscripciones`;
CREATE TABLE IF NOT EXISTS `inscripciones` (
  `idins` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT 'Relacionado con patients.numhs',
  `idcurso` int NOT NULL COMMENT 'Relacionado con cursos.idcurso',
  `fecha_inscripcion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '1' COMMENT '1=Activo, 0=Inactivo',
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idins`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `laboratory`
--

DROP TABLE IF EXISTS `laboratory`;
CREATE TABLE IF NOT EXISTS `laboratory` (
  `idlab` int NOT NULL AUTO_INCREMENT,
  `nomlab` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idlab`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `medicamentos`
--

DROP TABLE IF EXISTS `medicamentos`;
CREATE TABLE IF NOT EXISTS `medicamentos` (
  `id_medicamentos` int NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(30) NOT NULL,
  `tomam` varchar(30) NOT NULL,
  `cualm` varchar(30) NOT NULL,
  `prescripcion` varchar(30) NOT NULL,
  `automedicacion` varchar(30) NOT NULL,
  `quirurgicos` varchar(30) NOT NULL,
  `hospitalizacion` varchar(30) NOT NULL,
  `traumaticos` varchar(30) NOT NULL,
  `hipertencion` varchar(30) NOT NULL,
  `toxico` varchar(30) NOT NULL,
  `alergico` varchar(30) NOT NULL,
  `infeccioso` varchar(30) NOT NULL,
  `enfermedadr` varchar(30) NOT NULL,
  `ulcera` varchar(30) NOT NULL,
  `lepra` varchar(30) NOT NULL,
  `diabetes` varchar(30) NOT NULL,
  `asma` varchar(30) NOT NULL,
  `cancer` varchar(30) NOT NULL,
  `epoc` varchar(30) NOT NULL,
  `epilepsia` varchar(30) NOT NULL,
  `autoinmunes` varchar(30) NOT NULL,
  `ingresourgencias` varchar(30) NOT NULL,
  `otrom` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `menu_permissions`
--

DROP TABLE IF EXISTS `menu_permissions`;
CREATE TABLE IF NOT EXISTS `menu_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `dashboard` tinyint(1) DEFAULT '1',
  `remisiones` tinyint(1) DEFAULT '0',
  `usuarios` tinyint(1) DEFAULT '0',
  `cursos` tinyint(1) DEFAULT '0',
  `asistencia` tinyint(1) DEFAULT '0',
  `profesionales` tinyint(1) DEFAULT '0',
  `recursos` tinyint(1) DEFAULT '0',
  `ajustes` tinyint(1) DEFAULT '0',
  `acerca` tinyint(1) DEFAULT '1',
  `reportes` tinyint(1) DEFAULT '0',
  `remisiones_todas` tinyint(1) DEFAULT '0',
  `remisiones_nueva` tinyint(1) DEFAULT '0',
  `remisiones_calendario` tinyint(1) DEFAULT '0',
  `usuarios_lista` tinyint(1) DEFAULT '0',
  `usuarios_historial` tinyint(1) DEFAULT '0',
  `usuarios_documentos` tinyint(1) DEFAULT '0',
  `cursos_registro` tinyint(1) DEFAULT '0',
  `cursos_inscripcion` tinyint(1) DEFAULT '0',
  `cursos_asistencia` tinyint(1) DEFAULT '0',
  `profesionales_lista` tinyint(1) DEFAULT '0',
  `profesionales_historial` tinyint(1) DEFAULT '0',
  `recursos_enfermera` tinyint(1) DEFAULT '0',
  `recursos_laboratorios` tinyint(1) DEFAULT '0',
  `ajustes_config` tinyint(1) DEFAULT '0',
  `ajustes_idioma` tinyint(1) DEFAULT '0',
  `ajustes_base_datos` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_ver` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_oral_ver` tinyint(1) DEFAULT '0',
  `historia_salud_oral_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_mental_ver` tinyint(1) DEFAULT '0',
  `historia_salud_mental_modificar` tinyint(1) DEFAULT '0',
  `historia_medicamentos_ver` tinyint(1) DEFAULT '0',
  `historia_medicamentos_modificar` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_ver` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_modificar` tinyint(1) DEFAULT '0',
  `historia_diagnostico_ver` tinyint(1) DEFAULT '0',
  `historia_diagnostico_modificar` tinyint(1) DEFAULT '0',
  `historia_antecedentes_ver` tinyint(1) DEFAULT '0',
  `historia_antecedentes_modificar` tinyint(1) DEFAULT '0',
  `historia_examenes_ver` tinyint(1) DEFAULT '0',
  `historia_examenes_modificar` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_ver` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_modificar` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `menu_permissions`
--

INSERT INTO `menu_permissions` (`id`, `user_id`, `dashboard`, `remisiones`, `usuarios`, `cursos`, `asistencia`, `profesionales`, `recursos`, `ajustes`, `acerca`, `reportes`, `remisiones_todas`, `remisiones_nueva`, `remisiones_calendario`, `usuarios_lista`, `usuarios_historial`, `usuarios_documentos`, `cursos_registro`, `cursos_inscripcion`, `cursos_asistencia`, `profesionales_lista`, `profesionales_historial`, `recursos_enfermera`, `recursos_laboratorios`, `ajustes_config`, `ajustes_idioma`, `ajustes_base_datos`, `historia_riesgo_social_ver`, `historia_riesgo_social_modificar`, `historia_salud_oral_ver`, `historia_salud_oral_modificar`, `historia_salud_mental_ver`, `historia_salud_mental_modificar`, `historia_medicamentos_ver`, `historia_medicamentos_modificar`, `historia_signos_vitales_ver`, `historia_signos_vitales_modificar`, `historia_diagnostico_ver`, `historia_diagnostico_modificar`, `historia_antecedentes_ver`, `historia_antecedentes_modificar`, `historia_examenes_ver`, `historia_examenes_modificar`, `historia_fisioterapia_ver`, `historia_fisioterapia_modificar`) VALUES
(16, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `nurse`
--

DROP TABLE IF EXISTS `nurse`;
CREATE TABLE IF NOT EXISTS `nurse` (
  `idnur` int NOT NULL AUTO_INCREMENT,
  `numide` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomnur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apenur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacinur` date NOT NULL,
  `sexnur` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idnur`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `idord` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `nomcl` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `method` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_products` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `placed_on` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipc` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idord`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `patients`
--

DROP TABLE IF EXISTS `patients`;
CREATE TABLE IF NOT EXISTS `patients` (
  `idpa` int NOT NULL AUTO_INCREMENT,
  `numhs` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `nompa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apepa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direc` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sex` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `grup` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phon` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tiene_whatsapp` varchar(2) COLLATE utf8mb3_unicode_ci DEFAULT 'NO',
  `cump` date NOT NULL,
  `corr` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modalidad` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tusuario` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tdocumento` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `lexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ecivil` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zona` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `barrio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `correo` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rbono` varchar(39) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sisben` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pensionado` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tsudadera` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tchaqueta` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tzapatos` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `talentof` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `observacionsalida` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `vivecomp` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redapoyo` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `cuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `bvccuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sgsss` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `eps` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `etnia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `educacion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `leer` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `utecnologia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblaciond` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblacionoficio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qrInput` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `fotoperfil` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=749 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `patients`
--

INSERT INTO `patients` (`idpa`, `numhs`, `nompa`, `apepa`, `direc`, `sex`, `grup`, `phon`, `tiene_whatsapp`, `cump`, `corr`, `username`, `password`, `rol`, `state`, `fere`, `modalidad`, `tusuario`, `tdocumento`, `fexpedicion`, `lexpedicion`, `ecivil`, `zona`, `barrio`, `correo`, `rbono`, `sisben`, `pensionado`, `tsudadera`, `tchaqueta`, `tzapatos`, `talentof`, `observacionsalida`, `vivecomp`, `redapoyo`, `cuidador`, `pcuidador`, `zcuidador`, `bvccuidador`, `dcuidador`, `tcuidador`, `sgsss`, `eps`, `etnia`, `educacion`, `leer`, `utecnologia`, `poblaciond`, `poblacionoficio`, `qrInput`, `fotoperfil`) VALUES
(748, '1007863612', 'JUAN', 'ROJAS', 'DDSAD', 'MASCULINO', 'A-', '5456456412', 'NO', '2000-12-31', '', '', '', '', '1', '2026-01-26 13:34:31', 'CENTRO DíA LA PAZ', 'ANTIGUO', 'C.C', '31/12/2022', 'SBATE', 'CASADO', 'CENTRO POBLADO', 'LA RESERVA', 'ASDAS', 'NO', 'C1', 'SI', 'M', 'M', 'SADASD', 'SADASD', '', 'SAD', 'SI', 'lkjlj', 'CÓNYUGE y/o COMPAÑERO', 'Urbano', 'la paz', 'jhjg', 'kj54456', 'Contributivo', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'discapacidad', 'Reciclador', '1007863612', '1007863612_1769434471.jpg');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `product`
--

DROP TABLE IF EXISTS `product`;
CREATE TABLE IF NOT EXISTS `product` (
  `idprcd` int NOT NULL AUTO_INCREMENT,
  `codpro` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nompro` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idcat` int NOT NULL,
  `preprd` decimal(10,2) NOT NULL,
  `stock` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idprcd`),
  KEY `idcat` (`idcat`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `saludmental`
--

DROP TABLE IF EXISTS `saludmental`;
CREATE TABLE IF NOT EXISTS `saludmental` (
  `id_saludmental` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `maltrato` varchar(30) NOT NULL,
  `problemas` varchar(30) NOT NULL,
  `sentidomal` varchar(30) NOT NULL,
  `arrepentido` varchar(30) NOT NULL,
  `abandono` varchar(30) NOT NULL,
  `obligado` varchar(30) NOT NULL,
  `cuerpo` varchar(30) NOT NULL,
  `subido` varchar(30) NOT NULL,
  `vomito` varchar(30) NOT NULL,
  `apetito` varchar(30) NOT NULL,
  `reconocimiento` varchar(30) NOT NULL,
  `emborracho` varchar(30) NOT NULL,
  `sustancia` varchar(30) NOT NULL,
  `bebida` varchar(30) NOT NULL,
  `cigarrillo` varchar(30) NOT NULL,
  `aconsejado` varchar(30) NOT NULL,
  `bebidaalta` varchar(30) NOT NULL,
  `beberpodido` varchar(30) NOT NULL,
  `aburrido` varchar(30) NOT NULL,
  `frecuencia` varchar(30) NOT NULL,
  `actividadesf` varchar(30) NOT NULL,
  `tomardecisiones` varchar(30) NOT NULL,
  `agresividad` varchar(30) NOT NULL,
  `ptriste` varchar(30) NOT NULL,
  `ptemeroso` varchar(30) NOT NULL,
  `muerte` varchar(30) NOT NULL,
  `dano` varchar(30) NOT NULL,
  `aislado` varchar(30) NOT NULL,
  `motiva1` varchar(30) NOT NULL,
  `sentimiento` varchar(30) NOT NULL,
  `dificil` varchar(30) NOT NULL,
  `habilidad` varchar(30) NOT NULL,
  `alegreyanimo` varchar(30) NOT NULL,
  `relajadotranquilidad` varchar(30) NOT NULL,
  `activoenergia` varchar(30) NOT NULL,
  `biendescanso` varchar(30) NOT NULL,
  `momentointeresante` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `idse` int NOT NULL AUTO_INCREMENT,
  `nomem` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `toral`
--

DROP TABLE IF EXISTS `toral`;
CREATE TABLE IF NOT EXISTS `toral` (
  `id_oral` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(300) NOT NULL,
  `lavadientes` varchar(300) NOT NULL,
  `golpeb` varchar(300) NOT NULL,
  `sangred` varchar(300) NOT NULL,
  `protesisd` varchar(300) NOT NULL,
  `comesonrie` varchar(300) NOT NULL,
  `limpiab` varchar(300) NOT NULL,
  `dolorc` varchar(300) NOT NULL,
  `malolor` varchar(300) NOT NULL,
  `perdidadientes` varchar(300) NOT NULL,
  `maltratoprotesis` varchar(300) NOT NULL,
  `cicatriz` varchar(300) NOT NULL,
  `bocabano` varchar(300) NOT NULL,
  `consultaodont` varchar(300) NOT NULL,
  `observaciones` varchar(300) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `treatment`
--

DROP TABLE IF EXISTS `treatment`;
CREATE TABLE IF NOT EXISTS `treatment` (
  `idtra` int NOT NULL AUTO_INCREMENT,
  `nomtra` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idtra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ubicaciones_completas`
--

DROP TABLE IF EXISTS `ubicaciones_completas`;
CREATE TABLE IF NOT EXISTS `ubicaciones_completas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nompa` varchar(100) DEFAULT NULL,
  `documento` varchar(20) DEFAULT NULL,
  `correo` varchar(100) DEFAULT NULL,
  `latitud` decimal(9,6) DEFAULT NULL,
  `longitud` decimal(9,6) DEFAULT NULL,
  `fecha_registro` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `email` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `aprobado` enum('pendiente','aprobado','rechazado') COLLATE utf8mb3_unicode_ci DEFAULT 'pendiente',
  `fecha_aprobacion` datetime DEFAULT NULL,
  `aprobado_por` int DEFAULT NULL,
  `motivo_rechazo` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `users`
--

INSERT INTO `users` (`id`, `username`, `name`, `email`, `password`, `rol`, `created_at`, `aprobado`, `fecha_aprobacion`, `aprobado_por`, `motivo_rechazo`) VALUES
(1, 'admin', 'Administrador', 'adrianlujam91@gmail.com', 'e807f1fcf82d132f9bb018ca6738a19f', '1', '2025-10-20 21:50:22', 'aprobado', NULL, NULL, NULL),
(27, 'lizsuarez1', 'lizeth suarez', 'lizethsuarez12@gmail.com', '8c2d9f1f37632201ac8a927f00a6283e', '4', '2025-10-20 21:50:22', 'aprobado', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `user_permissions`
--

DROP TABLE IF EXISTS `user_permissions`;
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `view_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `edit_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `view_signos_vitales` tinyint(1) DEFAULT '0',
  `edit_signos_vitales` tinyint(1) DEFAULT '0',
  `view_medicamentos` tinyint(1) DEFAULT '0',
  `edit_medicamentos` tinyint(1) DEFAULT '0',
  `view_diagnostico` tinyint(1) DEFAULT '0',
  `edit_diagnostico` tinyint(1) DEFAULT '0',
  `view_antecedentes` tinyint(1) DEFAULT '0',
  `edit_antecedentes` tinyint(1) DEFAULT '0',
  `view_examenes` tinyint(1) DEFAULT '0',
  `edit_examenes` tinyint(1) DEFAULT '0',
  `view_salud_oral` tinyint(1) DEFAULT '0',
  `edit_salud_oral` tinyint(1) DEFAULT '0',
  `view_salud_mental` tinyint(1) DEFAULT '0',
  `edit_salud_mental` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `valoracionriesgo`
--

DROP TABLE IF EXISTS `valoracionriesgo`;
CREATE TABLE IF NOT EXISTS `valoracionriesgo` (
  `id_valoracion` int NOT NULL,
  `idpa` int NOT NULL,
  `enfermedadd` varchar(30) NOT NULL,
  `fuma` varchar(30) NOT NULL,
  `humo` varchar(30) NOT NULL,
  `consumo` varchar(30) NOT NULL,
  `sal` varchar(30) NOT NULL,
  `cocina` varchar(30) NOT NULL,
  `vestir` varchar(30) NOT NULL,
  `diahoy` varchar(30) NOT NULL,
  `meshoy` varchar(30) NOT NULL,
  `anohoy` varchar(30) NOT NULL,
  `municipio` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `fk_valoracionriesgo_patients` (`idpa`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `valoracionriesgo`
--

INSERT INTO `valoracionriesgo` (`id_valoracion`, `idpa`, `enfermedadd`, `fuma`, `humo`, `consumo`, `sal`, `cocina`, `vestir`, `diahoy`, `meshoy`, `anohoy`, `municipio`, `nompa`, `state`, `fere`) VALUES
(0, 748, 'No', 'No', 'No', 'Ni', 'No', 'No', 'No', 'No', 'No', 'No', 'No', 'JUAN', '1', '2026-01-26 13:49:33'),
(0, 748, 'No', 'No', 'No', 'Ni', 'No', 'No', 'No', 'No', 'No', 'No', 'No', 'JUAN', '1', '2026-01-26 13:49:36');

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `cart`
--
ALTER TABLE `cart`
  ADD CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `cart_ibfk_2` FOREIGN KEY (`idprcd`) REFERENCES `product` (`idprcd`);

--
-- Filtros para la tabla `events`
--
ALTER TABLE `events`
  ADD CONSTRAINT `events_ibfk_1` FOREIGN KEY (`idpa`) REFERENCES `patients` (`idpa`),
  ADD CONSTRAINT `events_ibfk_2` FOREIGN KEY (`idodc`) REFERENCES `doctor` (`idodc`),
  ADD CONSTRAINT `events_ibfk_3` FOREIGN KEY (`idlab`) REFERENCES `laboratory` (`idlab`);

--
-- Filtros para la tabla `menu_permissions`
--
ALTER TABLE `menu_permissions`
  ADD CONSTRAINT `menu_permissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `product`
--
ALTER TABLE `product`
  ADD CONSTRAINT `product_ibfk_1` FOREIGN KEY (`idcat`) REFERENCES `category` (`idcat`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
