<?php
/**
 * Script para activar el formulario completo de inscripción
 */

echo "<h1>Activando Formulario Completo...</h1>";

$dir = 'frontend/ciudadano/';
$archivoActual = $dir . 'inscripcion.php';
$archivoBackup = $dir . 'inscripcion_simple.php';
$archivoCompleto = $dir . 'inscripcion_full.php';

// Verificar que existe el archivo completo
if(!file_exists($archivoCompleto)) {
    die("<p style='color: red;'>❌ Error: No se encontró el archivo inscripcion_full.php</p>");
}

// Hacer backup del archivo actual
if(file_exists($archivoActual)) {
    if(rename($archivoActual, $archivoBackup)) {
        echo "<p style='color: green;'>✅ Backup creado: inscripcion_simple.php</p>";
    } else {
        die("<p style='color: red;'>❌ Error al crear backup</p>");
    }
}

// Renombrar el archivo completo
if(rename($archivoCompleto, $archivoActual)) {
    echo "<p style='color: green;'>✅ Formulario completo activado exitosamente!</p>";
    echo "<h2>El formulario ahora incluye TODOS los campos:</h2>";
    echo "<ul>";
    echo "<li>✅ Modalidad (12 opciones)</li>";
    echo "<li>✅ Tipo de Usuario</li>";
    echo "<li>✅ Zona y Barrio (33 barrios)</li>";
    echo "<li>✅ Sisben (A1-D21)</li>";
    echo "<li>✅ Tallas (Sudadera, Chaqueta, Zapatos)</li>";
    echo "<li>✅ Información del Cuidador</li>";
    echo "<li>✅ SGSSS, EPS, Etnia</li>";
    echo "<li>✅ Educación</li>";
    echo "<li>✅ Población Diferencial</li>";
    echo "<li>✅ Y muchos más...</li>";
    echo "</ul>";
    echo "<br><a href='frontend/ciudadano/inscripcion.php' style='padding: 15px 30px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; font-weight: 600;'>Ver Formulario Completo</a>";
} else {
    echo "<p style='color: red;'>❌ Error al activar el formulario completo</p>";
}
?>
