<?php
/**
 * Script completo para actualizar TODO el sistema de permisos
 * 1. Reemplaza validaciones antiguas por el nuevo sistema
 * 2. Reemplaza sidebars estáticos por dinámicos
 */

set_time_limit(600);
ini_set('memory_limit', '512M');

echo "<h2>🔄 Actualización Completa del Sistema de Permisos</h2>";

$archivosModificados = 0;
$errores = [];

// Mapeo de páginas y sus permisos requeridos
$paginasPermisos = [
    // Remisiones
    'citas/mostrar.php' => ['module' => 'remisiones', 'submenu' => 'remisiones_todas'],
    'citas/nuevo.php' => ['module' => 'remisiones', 'submenu' => 'remisiones_nueva'],
    'citas/calendario.php' => ['module' => 'remisiones', 'submenu' => 'remisiones_calendario'],
    'citas/info.php' => ['module' => 'remisiones', 'submenu' => 'remisiones_todas'],
    'citas/money.php' => ['module' => 'remisiones', 'submenu' => 'remisiones_todas'],
    
    // Usuarios/Pacientes
    'pacientes/mostrar.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/historial.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_historial'],
    'pacientes/documentos.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_documentos'],
    'pacientes/documentos_nuevo.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_documentos'],
    'pacientes/nuevo.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/crear.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/editar.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/info.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/pago.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/pagos.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    'pacientes/password.php' => ['module' => 'usuarios', 'submenu' => 'usuarios_lista'],
    
    // Cursos
    'cursos/registro_cursos.php' => ['module' => 'cursos', 'submenu' => 'cursos_registro'],
    'cursos/inscribir_curso.php' => ['module' => 'cursos', 'submenu' => 'cursos_inscripcion'],
    'cursos/Asistencia.php' => ['module' => 'cursos', 'submenu' => 'cursos_asistencia'],
    
    // Asistencia
    'asistencia/Asistencia.php' => ['module' => 'asistencia', 'submenu' => null],
    
    // Profesionales
    'medicos/mostrar.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_lista'],
    'medicos/historial.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_historial'],
    'medicos/crear.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_lista'],
    'medicos/nuevo.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_lista'],
    'medicos/info.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_lista'],
    'medicos/password.php' => ['module' => 'profesionales', 'submenu' => 'profesionales_lista'],
    
    // Recursos
    'recursos/enfermera.php' => ['module' => 'recursos', 'submenu' => 'recursos_enfermera'],
    'recursos/enfermera_nuevo.php' => ['module' => 'recursos', 'submenu' => 'recursos_enfermera'],
    'recursos/enfermera_editar.php' => ['module' => 'recursos', 'submenu' => 'recursos_enfermera'],
    'recursos/enfermera_info.php' => ['module' => 'recursos', 'submenu' => 'recursos_enfermera'],
    'recursos/laboratiorios.php' => ['module' => 'recursos', 'submenu' => 'recursos_laboratorios'],
    'recursos/laboratorios_nuevo.php' => ['module' => 'recursos', 'submenu' => 'recursos_laboratorios'],
    'recursos/laboratorios_editar.php' => ['module' => 'recursos', 'submenu' => 'recursos_laboratorios'],
    'recursos/laboratorios_info.php' => ['module' => 'recursos', 'submenu' => 'recursos_laboratorios'],
    
    // Ajustes
    'ajustes/mostrar.php' => ['module' => 'ajustes', 'submenu' => 'ajustes_config'],
    'ajustes/idioma.php' => ['module' => 'ajustes', 'submenu' => 'ajustes_idioma'],
    'ajustes/base.php' => ['module' => 'ajustes', 'submenu' => 'ajustes_base_datos'],
    
    // Acerca de
    'acerca/mostrar.php' => ['module' => 'acerca', 'submenu' => null],
    
    // Actividades
    'actividades/mostrar.php' => ['module' => 'dashboard', 'submenu' => null],
    'actividades/nuevo.php' => ['module' => 'dashboard', 'submenu' => null],
    'actividades/pagos.php' => ['module' => 'dashboard', 'submenu' => null],
];

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Procesando archivos...</h3>";

foreach($paginasPermisos as $archivo => $permisos) {
    $rutaCompleta = "frontend/$archivo";
    
    if(!file_exists($rutaCompleta)) {
        echo "<p style='color: #ffc107;'>⚠️ No encontrado: $rutaCompleta</p>";
        continue;
    }
    
    $content = file_get_contents($rutaCompleta);
    if($content === false) {
        $errores[] = "No se pudo leer: $rutaCompleta";
        continue;
    }
    
    $modificado = false;
    
    // 1. REEMPLAZAR VALIDACIÓN ANTIGUA
    $patronesAntiguos = [
        '/session_start\(\);\s*if\s*\(\s*!\s*isset\s*\(\s*\$_SESSION\[\'rol\'\]\s*\)\s*\|\|\s*\$_SESSION\[\'rol\'\]\s*!=\s*1\s*\)\s*\{\s*header\s*\([^)]+\);\s*(?:\$id\s*=\s*\$_SESSION\[\'id\'\];\s*)?\}/s',
        '/if\s*\(\s*!\s*isset\s*\(\s*\$_SESSION\[\'rol\'\]\s*\)\s*\|\|\s*\$_SESSION\[\'rol\'\]\s*!=\s*1\s*\)\s*\{\s*header\s*\([^)]+\);\s*exit;\s*\}/s',
    ];
    
    // Crear nuevo código de validación
    $module = $permisos['module'];
    $submenu = $permisos['submenu'];
    
    $nuevoCodigoValidacion = "// Incluir sistema de control de acceso\n    require '../../backend/php/check_access.php';\n    \n    // Verificar permisos\n    ";
    
    if($submenu) {
        $nuevoCodigoValidacion .= "if(!hasModulePermission('$module') && !hasSubmenuPermission('$submenu')){\n        header('location: ../acceso_denegado.php');\n        exit;\n    }";
    } else {
        $nuevoCodigoValidacion .= "if(!hasModulePermission('$module')){\n        header('location: ../acceso_denegado.php');\n        exit;\n    }";
    }
    
    foreach($patronesAntiguos as $patron) {
        if(preg_match($patron, $content)) {
            $content = preg_replace($patron, $nuevoCodigoValidacion, $content);
            $modificado = true;
            break;
        }
    }
    
    // También buscar session_start() solo y reemplazar
    if(preg_match('/^\s*session_start\(\);/m', $content) && !preg_match('/check_access\.php/', $content)) {
        $content = preg_replace('/^\s*session_start\(\);/m', $nuevoCodigoValidacion, $content, 1);
        $modificado = true;
    }
    
    // 2. REEMPLAZAR SIDEBAR ESTÁTICO
    if(strpos($content, '<section id="sidebar">') !== false && 
       strpos($content, "sidebar_menu.php") === false) {
        $pattern = '/<section id="sidebar">.*?<\/section>\s*(?:<!--\s*SIDEBAR\s*-->)?/s';
        $replacement = "<!-- SIDEBAR DINÁMICO -->\n    <?php include '../../backend/php/sidebar_menu.php'; ?>";
        $content = preg_replace($pattern, $replacement, $content, 1);
        $modificado = true;
    }
    
    if($modificado) {
        // Crear backup
        $backupFile = $rutaCompleta . '.backup_' . date('Ymd_His');
        copy($rutaCompleta, $backupFile);
        
        // Guardar archivo modificado
        if(file_put_contents($rutaCompleta, $content) !== false) {
            $archivosModificados++;
            echo "<p style='color: #28a745;'>✅ Actualizado: <code>$rutaCompleta</code></p>";
        } else {
            $errores[] = "No se pudo guardar: $rutaCompleta";
        }
    } else {
        echo "<p style='color: #6c757d;'>⏭️ Ya actualizado: <code>$rutaCompleta</code></p>";
    }
}

echo "</div>";

// Resumen
echo "<div style='background: " . (count($errores) > 0 ? '#fff3cd' : '#d4edda') . "; padding: 20px; border-radius: 8px; border-left: 4px solid " . (count($errores) > 0 ? '#ffc107' : '#28a745') . ";'>";
echo "<h3 style='margin-top: 0;'>📊 Resumen</h3>";
echo "<ul style='font-size: 16px;'>";
echo "<li><strong>✅ Archivos actualizados:</strong> $archivosModificados</li>";
echo "<li><strong>❌ Errores:</strong> " . count($errores) . "</li>";
echo "</ul>";

if(count($errores) > 0) {
    echo "<h4>Errores:</h4><ul>";
    foreach($errores as $error) {
        echo "<li style='color: #721c24;'>$error</li>";
    }
    echo "</ul>";
}
echo "</div>";

if($archivosModificados > 0) {
    echo "<div style='background: #e7f3ff; padding: 20px; border-radius: 8px; margin-top: 20px;'>";
    echo "<h3 style='color: #004085;'>🎉 ¡Actualización Completada!</h3>";
    echo "<p style='color: #004085;'>";
    echo "Se actualizaron <strong>$archivosModificados archivos</strong>.<br>";
    echo "Ahora TODAS las páginas usan el sistema de permisos personalizado.";
    echo "</p>";
    echo "<a href='frontend/admin/escritorio.php' style='padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 8px; display: inline-block; margin-top: 10px;'>Ir al Dashboard</a>";
    echo "</div>";
}
?>
