<?php
require 'backend/bd/Conexion.php';

echo "<h1>Agregando campo 'tiene_whatsapp' a la tabla patients...</h1>";

try {
    // Verificar si la columna ya existe
    $checkColumn = $connect->query("SHOW COLUMNS FROM patients LIKE 'tiene_whatsapp'");
    
    if($checkColumn->rowCount() > 0) {
        echo "<p style='color: orange;'>⚠️ La columna 'tiene_whatsapp' ya existe en la tabla patients</p>";
    } else {
        // Agregar la columna
        $alterTable = "ALTER TABLE `patients` ADD `tiene_whatsapp` VARCHAR(2) DEFAULT 'NO' AFTER `phon`";
        $connect->exec($alterTable);
        echo "<p style='color: green;'>✅ Columna 'tiene_whatsapp' agregada correctamente</p>";
    }
    
    // Mostrar estructura actualizada
    echo "<h2>Estructura de la tabla patients (campos relacionados):</h2>";
    $columns = $connect->query("SHOW COLUMNS FROM patients WHERE Field IN ('phon', 'tiene_whatsapp', 'correo')")->fetchAll(PDO::FETCH_ASSOC);
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Default</th></tr>";
    foreach($columns as $col) {
        echo "<tr>";
        echo "<td><strong>{$col['Field']}</strong></td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2 style='color: green;'>✅ ¡LISTO!</h2>";
    echo "<p>Ahora puedes usar el campo 'tiene_whatsapp' en los formularios.</p>";
    echo "<a href='frontend/pacientes/nuevo.php' style='display: inline-block; padding: 10px 20px; background: blue; color: white; text-decoration: none; border-radius: 5px; margin-right: 10px;'>Crear Usuario</a>";
    echo "<a href='frontend/pacientes/mostrar.php' style='display: inline-block; padding: 10px 20px; background: green; color: white; text-decoration: none; border-radius: 5px;'>Ver Usuarios</a>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
