<?php
require 'backend/bd/Conexion.php';

echo "<h2>Agregar Columnas de Submenús a menu_permissions</h2>";

$columnas = [
    'remisiones_todas',
    'remisiones_nueva',
    'remisiones_calendario',
    'usuarios_lista',
    'usuarios_historial',
    'usuarios_documentos',
    'cursos_registro',
    'cursos_inscripcion',
    'cursos_asistencia',
    'profesionales_lista',
    'profesionales_historial',
    'recursos_enfermera',
    'recursos_laboratorios',
    'ajustes_config',
    'ajustes_idioma',
    'ajustes_base_datos'
];

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Agregando columnas...</h3>";

$errores = [];
$exitosas = 0;

foreach($columnas as $columna) {
    try {
        $sql = "ALTER TABLE menu_permissions ADD COLUMN $columna TINYINT(1) DEFAULT 0";
        $connect->exec($sql);
        echo "<p style='color: #28a745;'>✅ Columna <strong>$columna</strong> agregada correctamente</p>";
        $exitosas++;
    } catch(PDOException $e) {
        if(strpos($e->getMessage(), 'Duplicate column') !== false) {
            echo "<p style='color: #ffc107;'>⚠️ Columna <strong>$columna</strong> ya existe</p>";
        } else {
            echo "<p style='color: #dc3545;'>❌ Error al agregar <strong>$columna</strong>: " . $e->getMessage() . "</p>";
            $errores[] = $columna;
        }
    }
}

echo "</div>";

if(count($errores) == 0) {
    echo "<div style='background: #d4edda; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745;'>";
    echo "<h3 style='color: #155724; margin-top: 0;'>🎉 ¡Proceso Completado!</h3>";
    echo "<p style='color: #155724;'><strong>$exitosas columnas</strong> agregadas exitosamente.</p>";
    echo "<p style='color: #155724;'>Ahora puedes configurar los permisos de submenús desde el panel de edición.</p>";
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='verificar_columnas_permisos.php' style='padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; display: inline-block; margin-right: 10px;'>Verificar Columnas</a>";
    echo "<a href='frontend/medicos/editar_menu.php?id=24' style='padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Editar Permisos de RABIT</a>";
    echo "</div>";
} else {
    echo "<div style='background: #f8d7da; padding: 20px; border-radius: 8px; border-left: 4px solid #dc3545;'>";
    echo "<h3 style='color: #721c24; margin-top: 0;'>⚠️ Hubo algunos errores</h3>";
    echo "<p style='color: #721c24;'>Columnas con error: " . implode(', ', $errores) . "</p>";
    echo "</div>";
}

// Mostrar estructura actualizada
echo "<h3>Estructura actualizada de la tabla:</h3>";
$columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_ASSOC);

echo "<table border='1' cellpadding='8' style='border-collapse: collapse; width: 100%; margin-top: 10px;'>";
echo "<tr style='background: #667eea; color: white;'>";
echo "<th>Columna</th><th>Tipo</th><th>Default</th>";
echo "</tr>";

foreach($columns as $col) {
    $esNueva = in_array($col['Field'], $columnas);
    $bgColor = $esNueva ? '#e6f7ee' : 'white';
    echo "<tr style='background: $bgColor;'>";
    echo "<td><strong>" . $col['Field'] . "</strong>" . ($esNueva ? " <span style='color: #28a745;'>✨ NUEVA</span>" : "") . "</td>";
    echo "<td>" . $col['Type'] . "</td>";
    echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
    echo "</tr>";
}

echo "</table>";
?>
