<?php
require 'backend/bd/Conexion.php';

echo "<h2>Agregar Permisos de Historia Clínica</h2>";

$columnas = [
    // Valoración del Riesgo Social
    'historia_riesgo_social_ver',
    'historia_riesgo_social_modificar',
    
    // Tamizaje Salud Oral
    'historia_salud_oral_ver',
    'historia_salud_oral_modificar',
    
    // Tamizaje Salud Mental
    'historia_salud_mental_ver',
    'historia_salud_mental_modificar',
    
    // Medicamentos
    'historia_medicamentos_ver',
    'historia_medicamentos_modificar',
    
    // Signos Vitales
    'historia_signos_vitales_ver',
    'historia_signos_vitales_modificar',
    
    // Diagnóstico Médico
    'historia_diagnostico_ver',
    'historia_diagnostico_modificar',
    
    // Antecedentes
    'historia_antecedentes_ver',
    'historia_antecedentes_modificar',
    
    // Exámenes
    'historia_examenes_ver',
    'historia_examenes_modificar',
    
    // Fisioterapia
    'historia_fisioterapia_ver',
    'historia_fisioterapia_modificar'
];

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Agregando columnas...</h3>";

$errores = [];
$exitosas = 0;

foreach($columnas as $columna) {
    try {
        $sql = "ALTER TABLE menu_permissions ADD COLUMN $columna TINYINT(1) DEFAULT 0";
        $connect->exec($sql);
        echo "<p style='color: #28a745;'>✅ Columna <strong>$columna</strong> agregada correctamente</p>";
        $exitosas++;
    } catch(PDOException $e) {
        if(strpos($e->getMessage(), 'Duplicate column') !== false) {
            echo "<p style='color: #ffc107;'>⚠️ Columna <strong>$columna</strong> ya existe</p>";
        } else {
            echo "<p style='color: #dc3545;'>❌ Error al agregar <strong>$columna</strong>: " . $e->getMessage() . "</p>";
            $errores[] = $columna;
        }
    }
}

echo "</div>";

if(count($errores) == 0) {
    echo "<div style='background: #d4edda; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745;'>";
    echo "<h3 style='color: #155724; margin-top: 0;'>🎉 ¡Proceso Completado!</h3>";
    echo "<p style='color: #155724;'><strong>$exitosas columnas</strong> agregadas exitosamente.</p>";
    echo "<p style='color: #155724;'>Ahora puedes configurar permisos detallados para cada sección de la historia clínica.</p>";
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='frontend/medicos/editar_menu.php?id=24' style='padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Configurar Permisos de RABIT</a>";
    echo "</div>";
} else {
    echo "<div style='background: #f8d7da; padding: 20px; border-radius: 8px; border-left: 4px solid #dc3545;'>";
    echo "<h3 style='color: #721c24; margin-top: 0;'>⚠️ Hubo algunos errores</h3>";
    echo "<p style='color: #721c24;'>Columnas con error: " . implode(', ', $errores) . "</p>";
    echo "</div>";
}

// Mostrar estructura actualizada
echo "<h3>Columnas de Historia Clínica agregadas:</h3>";
echo "<table border='1' cellpadding='8' style='border-collapse: collapse; width: 100%; margin-top: 10px;'>";
echo "<tr style='background: #667eea; color: white;'><th>Columna</th></tr>";

foreach($columnas as $col) {
    echo "<tr><td><strong>$col</strong></td></tr>";
}

echo "</table>";
?>
