<?php
require 'backend/bd/Conexion.php';

echo "<h1>Agregando permisos de submenús...</h1>";

try {
    // Agregar columnas para submenús
    $columns = [
        // Remisiones
        'remisiones_todas' => "ALTER TABLE menu_permissions ADD COLUMN remisiones_todas TINYINT(1) DEFAULT 0",
        'remisiones_nueva' => "ALTER TABLE menu_permissions ADD COLUMN remisiones_nueva TINYINT(1) DEFAULT 0",
        'remisiones_calendario' => "ALTER TABLE menu_permissions ADD COLUMN remisiones_calendario TINYINT(1) DEFAULT 0",
        
        // Usuarios
        'usuarios_lista' => "ALTER TABLE menu_permissions ADD COLUMN usuarios_lista TINYINT(1) DEFAULT 0",
        'usuarios_historial' => "ALTER TABLE menu_permissions ADD COLUMN usuarios_historial TINYINT(1) DEFAULT 0",
        'usuarios_documentos' => "ALTER TABLE menu_permissions ADD COLUMN usuarios_documentos TINYINT(1) DEFAULT 0",
        
        // Cursos
        'cursos_registro' => "ALTER TABLE menu_permissions ADD COLUMN cursos_registro TINYINT(1) DEFAULT 0",
        'cursos_inscripcion' => "ALTER TABLE menu_permissions ADD COLUMN cursos_inscripcion TINYINT(1) DEFAULT 0",
        'cursos_asistencia' => "ALTER TABLE menu_permissions ADD COLUMN cursos_asistencia TINYINT(1) DEFAULT 0",
        
        // Profesionales
        'profesionales_lista' => "ALTER TABLE menu_permissions ADD COLUMN profesionales_lista TINYINT(1) DEFAULT 0",
        'profesionales_historial' => "ALTER TABLE menu_permissions ADD COLUMN profesionales_historial TINYINT(1) DEFAULT 0",
        
        // Recursos
        'recursos_enfermera' => "ALTER TABLE menu_permissions ADD COLUMN recursos_enfermera TINYINT(1) DEFAULT 0",
        'recursos_laboratorios' => "ALTER TABLE menu_permissions ADD COLUMN recursos_laboratorios TINYINT(1) DEFAULT 0",
        
        // Ajustes
        'ajustes_config' => "ALTER TABLE menu_permissions ADD COLUMN ajustes_config TINYINT(1) DEFAULT 0",
        'ajustes_idioma' => "ALTER TABLE menu_permissions ADD COLUMN ajustes_idioma TINYINT(1) DEFAULT 0",
        'ajustes_base_datos' => "ALTER TABLE menu_permissions ADD COLUMN ajustes_base_datos TINYINT(1) DEFAULT 0"
    ];
    
    foreach($columns as $columnName => $sql) {
        try {
            $connect->exec($sql);
            echo "<p style='color: green;'>✅ Columna <strong>$columnName</strong> agregada</p>";
        } catch(PDOException $e) {
            if(strpos($e->getMessage(), 'Duplicate') !== false) {
                echo "<p style='color: orange;'>⚠️ Columna <strong>$columnName</strong> ya existe</p>";
            } else {
                echo "<p style='color: red;'>❌ Error en $columnName: " . $e->getMessage() . "</p>";
            }
        }
    }
    
    echo "<h2>Columnas actuales en menu_permissions:</h2>";
    $result = $connect->query("SHOW COLUMNS FROM menu_permissions");
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th></tr>";
    while($row = $result->fetch()) {
        echo "<tr><td><strong>{$row['Field']}</strong></td><td>{$row['Type']}</td></tr>";
    }
    echo "</table>";
    
    echo "<h2 style='color: green;'>✅ ¡LISTO!</h2>";
    echo "<p>Ahora puedes configurar permisos de submenús para cada usuario.</p>";
    echo "<a href='frontend/medicos/mostrar.php' style='display: inline-block; padding: 10px 20px; background: blue; color: white; text-decoration: none; border-radius: 5px;'>Ir a Profesionales</a>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
