<?php
/**
 * Script para agregar columnas de tipo y motivo a asistencia_qr
 * Ejecutar desde: http://localhost/hogar_abuelos/agregar_tipo_motivo_asistencia.php
 */

require 'backend/bd/Conexion.php';

echo "<!DOCTYPE html>";
echo "<html><head><meta charset='UTF-8'>";
echo "<style>
body { font-family: Arial; padding: 20px; background: #f5f5f5; }
.container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
h1 { color: #667eea; border-bottom: 3px solid #667eea; padding-bottom: 10px; }
.success { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 10px 0; }
.error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin: 10px 0; }
.info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 8px; margin: 10px 0; }
</style></head><body>";
echo "<div class='container'>";

echo "<h1>🔧 Actualizar Tabla asistencia_qr</h1>";

try {
    // 1. Agregar columna 'tipo'
    echo "<h3>1. Agregando columna 'tipo' (ENTRADA/SALIDA)</h3>";
    try {
        $sql1 = "ALTER TABLE `asistencia_qr` ADD COLUMN `tipo` ENUM('ENTRADA', 'SALIDA') NOT NULL DEFAULT 'ENTRADA' AFTER `fecha`";
        $connect->exec($sql1);
        echo "<div class='success'>✅ Columna 'tipo' agregada correctamente</div>";
    } catch(PDOException $e) {
        if(strpos($e->getMessage(), 'Duplicate column') !== false) {
            echo "<div class='info'>ℹ️ La columna 'tipo' ya existe</div>";
        } else {
            throw $e;
        }
    }
    
    // 2. Agregar columna 'motivo'
    echo "<h3>2. Agregando columna 'motivo' (para salidas)</h3>";
    try {
        $sql2 = "ALTER TABLE `asistencia_qr` ADD COLUMN `motivo` TEXT NULL AFTER `tipo`";
        $connect->exec($sql2);
        echo "<div class='success'>✅ Columna 'motivo' agregada correctamente</div>";
    } catch(PDOException $e) {
        if(strpos($e->getMessage(), 'Duplicate column') !== false) {
            echo "<div class='info'>ℹ️ La columna 'motivo' ya existe</div>";
        } else {
            throw $e;
        }
    }
    
    // 3. Verificar estructura
    echo "<h3>3. Verificando estructura final</h3>";
    $stmt = $connect->query("SHOW COLUMNS FROM asistencia_qr");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<div class='info'>";
    echo "<p><strong>Columnas en asistencia_qr:</strong></p>";
    echo "<ul>";
    foreach($columns as $col) {
        $highlight = ($col['Field'] == 'tipo' || $col['Field'] == 'motivo') ? 'style="color: green; font-weight: bold;"' : '';
        echo "<li $highlight>{$col['Field']} - {$col['Type']}</li>";
    }
    echo "</ul>";
    echo "</div>";
    
    echo "<div class='success'>";
    echo "<h3>✅ ¡Actualización Completada!</h3>";
    echo "<p>La tabla <code>asistencia_qr</code> ahora tiene:</p>";
    echo "<ul>";
    echo "<li>✅ Campo <strong>tipo</strong>: ENTRADA o SALIDA</li>";
    echo "<li>✅ Campo <strong>motivo</strong>: Texto libre para el motivo de salida</li>";
    echo "</ul>";
    echo "<p>Ahora puedes usar el sistema de asistencia actualizado.</p>";
    echo "</div>";
    
    echo "<div style='margin-top: 20px; text-align: center;'>";
    echo "<a href='frontend/asistencia/Asistencia.php' style='display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 6px;'>Ir a Asistencia</a>";
    echo "</div>";
    
} catch(PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Error</h3>";
    echo "<p>".$e->getMessage()."</p>";
    echo "</div>";
}

echo "</div></body></html>";
?>
