<?php
// Archivo para actualizar datos del ciudadano
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['actualizar_datos'])) {
    // Recibir datos del formulario
    $numhs = trim($_POST['nhi']);
    $nompa = strtoupper(trim($_POST['namp']));
    $apepa = strtoupper(trim($_POST['apep']));  
    $direc = strtoupper(trim($_POST['dip']));
    $sex = strtoupper(trim($_POST['gep']));
    $grup = strtoupper(trim($_POST['grp']));
    $phon = trim($_POST['telp']);
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $cump = trim($_POST['cump']);
    $ecivil = strtoupper(trim($_POST['ecivil']));
    $correo = trim($_POST['correo']);
    
    // Campos opcionales
    $modalidad = strtoupper(trim($_POST['modalidad'] ?? ''));
    $tusuario = strtoupper(trim($_POST['tusuario'] ?? ''));
    $fexpedicion_input = trim($_POST['fexpedicion'] ?? '');
    // Convertir fecha de YYYY-MM-DD a DD/MM/YYYY para mantener consistencia en BD
    if (!empty($fexpedicion_input) && strpos($fexpedicion_input, '-') !== false) {
        $fecha_parts = explode('-', $fexpedicion_input);
        if (count($fecha_parts) == 3) {
            $fexpedicion = $fecha_parts[2] . '/' . $fecha_parts[1] . '/' . $fecha_parts[0];
        } else {
            $fexpedicion = $fexpedicion_input;
        }
    } else {
        $fexpedicion = $fexpedicion_input;
    }
    $lexpedicion = strtoupper(trim($_POST['lexpedicion'] ?? ''));
    
    // Manejo de la foto de perfil
    $upload_dir = '../../uploads/fotos_perfil/';
    $fotoperfil = null;
    $actualizar_foto = false;

    if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['fotoperfil']['tmp_name'];
        $file_name = $_FILES['fotoperfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            $fotoperfil = $new_file_name;
            $actualizar_foto = true;
        }
    }

    // Actualizar en la base de datos
    try {
        if($actualizar_foto) {
            $query = "UPDATE patients SET
                nompa=:nompa, apepa=:apepa, direc=:direc, sex=:sex, grup=:grup, phon=:phon, 
                tiene_whatsapp=:tiene_whatsapp, cump=:cump, ecivil=:ecivil, correo=:correo,
                modalidad=:modalidad, tusuario=:tusuario, fexpedicion=:fexpedicion, 
                lexpedicion=:lexpedicion, fotoperfil=:fotoperfil
                WHERE numhs=:numhs LIMIT 1";
                
            $data = [
                ':nompa' => $nompa,
                ':apepa' => $apepa,
                ':direc' => $direc,
                ':sex' => $sex,
                ':grup' => $grup,
                ':phon' => $phon,
                ':tiene_whatsapp' => $tiene_whatsapp,
                ':cump' => $cump,
                ':ecivil' => $ecivil,
                ':correo' => $correo,
                ':modalidad' => $modalidad,
                ':tusuario' => $tusuario,
                ':fexpedicion' => $fexpedicion,
                ':lexpedicion' => $lexpedicion,
                ':fotoperfil' => $fotoperfil,
                ':numhs' => $numhs
            ];
        } else {
            $query = "UPDATE patients SET
                nompa=:nompa, apepa=:apepa, direc=:direc, sex=:sex, grup=:grup, phon=:phon, 
                tiene_whatsapp=:tiene_whatsapp, cump=:cump, ecivil=:ecivil, correo=:correo,
                modalidad=:modalidad, tusuario=:tusuario, fexpedicion=:fexpedicion, 
                lexpedicion=:lexpedicion
                WHERE numhs=:numhs LIMIT 1";
                
            $data = [
                ':nompa' => $nompa,
                ':apepa' => $apepa,
                ':direc' => $direc,
                ':sex' => $sex,
                ':grup' => $grup,
                ':phon' => $phon,
                ':tiene_whatsapp' => $tiene_whatsapp,
                ':cump' => $cump,
                ':ecivil' => $ecivil,
                ':correo' => $correo,
                ':modalidad' => $modalidad,
                ':tusuario' => $tusuario,
                ':fexpedicion' => $fexpedicion,
                ':lexpedicion' => $lexpedicion,
                ':numhs' => $numhs
            ];
        }

        $statement = $connect->prepare($query);
        $query_execute = $statement->execute($data);

        if($query_execute) {
            echo '<div class="alert alert-success">
                <strong>¡Éxito!</strong> Tus datos han sido actualizados correctamente.
            </div>';
            
            // Recargar los datos
            echo '<script>
                setTimeout(function() {
                    window.location.reload();
                }, 2000);
            </script>';
        } else {
            echo '<div class="alert alert-error">
                <strong>Error!</strong> No se pudieron actualizar tus datos. Por favor, intenta nuevamente.
            </div>';
        }

    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
    }
}
?>
