<?php
// Archivo para procesar matrícula pública (sin autenticación)
require_once('../../backend/bd/Conexion.php'); 
global $connect;

// Habilitar reporte de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar conexión a la base de datos
if (!$connect) {
    die('<div class="alert alert-error">Error de conexión a la base de datos</div>');
}

if(isset($_POST['add_patiens_public'])) {
    // Recibir y limpiar datos del formulario
    $numhs = trim($_POST['nhi']);
    $nompa = strtoupper(trim($_POST['namp']));
    $apepa = strtoupper(trim($_POST['apep']));  
    $direc = strtoupper(trim($_POST['dip']));
    $sex = strtoupper(trim($_POST['gep']));
    $grup = strtoupper(trim($_POST['grp']));
    $phon = trim($_POST['telp']);
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $cump = trim($_POST['cump']);
    $tdocumento = strtoupper(trim($_POST['tdocumento']));
    $ecivil = strtoupper(trim($_POST['ecivil']));
    $correo = trim($_POST['correo']);
    $observacionsalida = trim($_POST['observacionsalida'] ?? '');
    
    // Valores por defecto para campos no incluidos en el formulario público
    $modalidad = 'PENDIENTE';
    $tusuario = 'ADULTO MAYOR';
    $fexpedicion = '';
    $lexpedicion = '';
    $zona = '';
    $barrio = '';
    $rbono = '';
    $sisben = '';
    $pensionado = '';
    $tsudadera = '';
    $tchaqueta = '';
    $tzapatos = '';
    $talentof = '';
    $vivecomp = '';
    $redapoyo = '';
    $cuidador = '';
    $pcuidador = '';
    $zcuidador = '';
    $bvccuidador = '';
    $dcuidador = '';
    $tcuidador = '';
    $sgsss = '';
    $eps = '';
    $etnia = '';
    $educacion = '';
    $leer = '';
    $utecnologia = '';
    $poblaciond = '';
    $poblacionoficio = '';

    // Manejo de la foto de perfil
    $upload_dir = '../../uploads/fotos_perfil/';
    $fotoperfil = null;

    if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['fotoperfil']['tmp_name'];
        $file_name = $_FILES['fotoperfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        // Generar un nombre de archivo único
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        // Asegurarse de que el directorio exista
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            $fotoperfil = $new_file_name;
        } else {
            echo '<div class="alert alert-error"><strong>Error!</strong> No se pudo subir la foto de perfil.</div>';
            exit(0);
        }
    }

    // Verificar si el documento ya existe
    try {
        $stmt_check = $connect->prepare("SELECT COUNT(*) FROM patients WHERE numhs = :numhs");
        $stmt_check->execute([':numhs' => $numhs]);
        $count = $stmt_check->fetchColumn();

        if ($count > 0) {
            echo '<div class="alert alert-error"><strong>Error!</strong> Este número de documento ya está registrado en el sistema.</div>';
            exit(0);
        }
    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
        exit(0);
    }

    // Insertar en la base de datos
    try {
        $query = "INSERT INTO patients (
            numhs, nompa, apepa, direc, sex, grup, phon, tiene_whatsapp, cump, modalidad, tusuario, 
            tdocumento, fexpedicion, lexpedicion, ecivil, zona, barrio, correo, rbono, sisben, 
            pensionado, tsudadera, tchaqueta, tzapatos, talentof, observacionsalida, vivecomp, 
            redapoyo, cuidador, pcuidador, zcuidador, bvccuidador, dcuidador, tcuidador, sgsss, 
            eps, etnia, educacion, leer, utecnologia, poblaciond, poblacionoficio, fotoperfil
        ) VALUES (
            :numhs, :nompa, :apepa, :direc, :sex, :grup, :phon, :tiene_whatsapp, :cump, :modalidad, 
            :tusuario, :tdocumento, :fexpedicion, :lexpedicion, :ecivil, :zona, :barrio, :correo, 
            :rbono, :sisben, :pensionado, :tsudadera, :tchaqueta, :tzapatos, :talentof, 
            :observacionsalida, :vivecomp, :redapoyo, :cuidador, :pcuidador, :zcuidador, 
            :bvccuidador, :dcuidador, :tcuidador, :sgsss, :eps, :etnia, :educacion, :leer, 
            :utecnologia, :poblaciond, :poblacionoficio, :fotoperfil
        )";

        $statement = $connect->prepare($query);

        $data = [
            ':numhs' => $numhs,
            ':nompa' => $nompa,
            ':apepa' => $apepa,
            ':direc' => $direc,
            ':sex' => $sex,
            ':grup' => $grup,
            ':phon' => $phon,
            ':tiene_whatsapp' => $tiene_whatsapp,
            ':cump' => $cump,
            ':modalidad' => $modalidad,
            ':tusuario' => $tusuario,
            ':tdocumento' => $tdocumento,
            ':fexpedicion' => $fexpedicion,
            ':lexpedicion' => $lexpedicion,
            ':ecivil' => $ecivil,
            ':zona' => $zona,
            ':barrio' => $barrio,
            ':correo' => $correo,
            ':rbono' => $rbono,
            ':sisben' => $sisben,
            ':pensionado' => $pensionado,
            ':tsudadera' => $tsudadera,
            ':tchaqueta' => $tchaqueta,
            ':tzapatos' => $tzapatos,
            ':talentof' => $talentof,
            ':observacionsalida' => $observacionsalida,
            ':vivecomp' => $vivecomp,
            ':redapoyo' => $redapoyo,
            ':cuidador' => $cuidador,
            ':pcuidador' => $pcuidador,
            ':zcuidador' => $zcuidador,
            ':bvccuidador' => $bvccuidador,
            ':dcuidador' => $dcuidador,
            ':tcuidador' => $tcuidador,
            ':sgsss' => $sgsss,
            ':eps' => $eps,
            ':etnia' => $etnia,
            ':educacion' => $educacion,
            ':leer' => $leer,
            ':utecnologia' => $utecnologia,
            ':poblaciond' => $poblaciond,
            ':poblacionoficio' => $poblacionoficio,
            ':fotoperfil' => $fotoperfil
        ];

        $query_execute = $statement->execute($data);

        if($query_execute) {
            echo '<div class="alert alert-success">
                <strong>¡Éxito!</strong> Su matrícula ha sido enviada correctamente.<br>
                <strong>Nombre:</strong> ' . $nompa . ' ' . $apepa . '<br>
                <strong>Documento:</strong> ' . $numhs . '<br><br>
                Su solicitud está en estado <strong>PENDIENTE</strong> y será revisada por nuestro equipo.<br>
                Pronto nos pondremos en contacto con usted.
            </div>';
            
            // Limpiar el formulario
            echo '<script>
                setTimeout(function() {
                    document.getElementById("matriculaForm").reset();
                    document.getElementById("img-preview").style.display = "none";
                }, 3000);
            </script>';
        } else {
            echo '<div class="alert alert-error">
                <strong>Error!</strong> No se pudo procesar su matrícula. Por favor, intente nuevamente.
            </div>';
        }

    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
    }
}
?>
