<?php
require_once('../../backend/bd/Conexion.php');

if(isset($_POST['delete_docu'])) {
    ////////////// Obtener información del documento //////////
    $iddoc = trim($_POST['iddoc']);
    $foto = trim($_POST['foto']);
    
    ////////////// Eliminar el archivo físico del servidor /////////
    $upload_dir = '../../backend/img/subidas/';
    $file_path = $upload_dir . $foto;
    
    // Verificar si el archivo existe y eliminarlo
    if(file_exists($file_path)) {
        unlink($file_path);
    }
    
    ////////////// Eliminar el registro de la base de datos /////////
    $consulta = "DELETE FROM document WHERE iddoc=:iddoc";
    $sql = $connect->prepare($consulta);
    $sql->bindParam(':iddoc', $iddoc, PDO::PARAM_INT);
    $sql->execute();
    
    if($sql->rowCount() > 0) {
        echo '<script type="text/javascript">
        swal("¡Eliminado!", "Documento eliminado correctamente", "success").then(function() {
            window.location.replace(window.location.pathname + window.location.search);
        });
        </script>';
    } else {
        echo '<script type="text/javascript">
        swal("Error!", "No se pudo eliminar el documento", "error").then(function() {
            window.location.replace(window.location.pathname + window.location.search);
        });
        </script>';
        
        print_r($sql->errorInfo()); 
    }
}
?>
