<?php
session_start();
require '../bd/Conexion.php';

// Verificar que sea un ciudadano
if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 3) {
    header('location: ../../frontend/acceso_denegado.php');
    exit();
}

if(isset($_GET['id'])) {
    $docId = $_GET['id'];
    
    // Obtener información del documento y verificar permisos
    $stmt = $connect->prepare("
        SELECT pd.*, p.user_id 
        FROM patient_documents pd 
        JOIN patients p ON pd.patient_id = p.idpa 
        WHERE pd.id = ?
    ");
    $stmt->execute([$docId]);
    $doc = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($doc && $doc['user_id'] == $_SESSION['id']) {
        // Eliminar archivo físico
        $filePath = '../../uploads/documentos/' . $doc['file_name'];
        if(file_exists($filePath)) {
            unlink($filePath);
        }
        
        // Eliminar registro de base de datos
        $stmtDelete = $connect->prepare("DELETE FROM patient_documents WHERE id = ?");
        $stmtDelete->execute([$docId]);
        
        $_SESSION['success'] = "Documento eliminado exitosamente";
    } else {
        $_SESSION['error'] = "No tienes permiso para eliminar este documento";
    }
}

header('location: ../../frontend/profile/documentos.php');
exit();
?>
