<?php
// Archivo para procesar inscripción de ciudadanos autenticados
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

// Debug: Verificar si llegó algún POST
if($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_log("POST recibido - Keys: " . implode(', ', array_keys($_POST)));
    
    // Mostrar mensaje visible para debug
    echo '<div style="position: fixed; top: 100px; right: 20px; background: #17a2b8; color: white; padding: 10px; border-radius: 5px; z-index: 9999;">
        POST DETECTADO - ' . count($_POST) . ' campos
    </div>';
}

if(isset($_POST['inscripcion_ciudadano'])) {
    // Debug: verificar que llegó el POST
    error_log("Inscripción ciudadano - POST recibido");
    error_log("Documento: " . $_POST['nhi']);
    error_log("Nombre: " . $_POST['namp']);
    
    // Mostrar mensaje visible
    echo '<script>
        console.log("POST inscripcion_ciudadano detectado");
        console.log("Documento:", "' . $_POST['nhi'] . '");
        window.scrollTo(0, 0);
    </script>';
    echo '<div class="alert alert-info" style="position: fixed; top: 20px; left: 50%; transform: translateX(-50%); z-index: 9999; background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.3); max-width: 90%; text-align: center;">
        <strong>Procesando inscripción...</strong><br>
        Documento: ' . $_POST['nhi'] . '
    </div>';
    
    // Recibir datos del formulario
    $numhs = trim($_POST['nhi']);
    $nompa = strtoupper(trim($_POST['namp']));
    $apepa = strtoupper(trim($_POST['apep']));  
    $direc = strtoupper(trim($_POST['dip']));
    $sex = strtoupper(trim($_POST['gep']));
    $grup = strtoupper(trim($_POST['grp']));
    $phon = trim($_POST['telp']);
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $cump = trim($_POST['cump']);
    
    // Debug: Mostrar datos recibidos
    error_log("=== DATOS RECIBIDOS ===");
    error_log("Documento: " . $numhs);
    error_log("Nombre: " . $nompa);
    error_log("Apellido: " . $apepa);
    $tdocumento = strtoupper(trim($_POST['tdocumento']));
    $ecivil = strtoupper(trim($_POST['ecivil']));
    $correo = trim($_POST['correo']);
    $observacionsalida = trim($_POST['observacionsalida'] ?? '');
    
    // Recibir TODOS los campos del formulario
    $modalidad = strtoupper(trim($_POST['modalidad'] ?? ''));
    $tusuario = strtoupper(trim($_POST['tusuario'] ?? 'NUEVO'));
    $fexpedicion_input = trim($_POST['fexpedicion'] ?? '');
    // Convertir fecha de YYYY-MM-DD a DD/MM/YYYY para mantener consistencia en BD
    if (!empty($fexpedicion_input) && strpos($fexpedicion_input, '-') !== false) {
        $fecha_parts = explode('-', $fexpedicion_input);
        if (count($fecha_parts) == 3) {
            $fexpedicion = $fecha_parts[2] . '/' . $fecha_parts[1] . '/' . $fecha_parts[0];
        } else {
            $fexpedicion = $fexpedicion_input;
        }
    } else {
        $fexpedicion = $fexpedicion_input;
    }
    $lexpedicion = strtoupper(trim($_POST['lexpedicion'] ?? ''));
    $zona = strtoupper(trim($_POST['zona'] ?? ''));
    $barrio = strtoupper(trim($_POST['barrio'] ?? ''));
    $rbono = strtoupper(trim($_POST['rbono'] ?? ''));
    $sisben = strtoupper(trim($_POST['sisben'] ?? ''));
    $pensionado = strtoupper(trim($_POST['pensionado'] ?? ''));
    $tsudadera = strtoupper(trim($_POST['tsudadera'] ?? ''));
    $tchaqueta = strtoupper(trim($_POST['tchaqueta'] ?? ''));
    $tzapatos = trim($_POST['tzapatos'] ?? '');
    $talentof = strtoupper(trim($_POST['talentof'] ?? ''));
    $vivecomp = strtoupper(trim($_POST['vivecomp'] ?? ''));
    $redapoyo = strtoupper(trim($_POST['redapoyo'] ?? ''));
    $cuidador = strtoupper(trim($_POST['cuidador'] ?? ''));
    $pcuidador = strtoupper(trim($_POST['pcuidador'] ?? ''));
    $zcuidador = strtoupper(trim($_POST['zcuidador'] ?? ''));
    $bvccuidador = strtoupper(trim($_POST['bvccuidador'] ?? ''));
    $dcuidador = strtoupper(trim($_POST['dcuidador'] ?? ''));
    $tcuidador = trim($_POST['tcuidador'] ?? '');
    $sgsss = strtoupper(trim($_POST['sgsss'] ?? ''));
    $eps = strtoupper(trim($_POST['eps'] ?? ''));
    $etnia = strtoupper(trim($_POST['etnia'] ?? ''));
    $educacion = strtoupper(trim($_POST['educacion'] ?? ''));
    $leer = strtoupper(trim($_POST['leer'] ?? ''));
    $utecnologia = strtoupper(trim($_POST['utecnologia'] ?? ''));
    $poblaciond = strtoupper(trim($_POST['poblaciond'] ?? ''));
    $poblacionoficio = strtoupper(trim($_POST['poblacionoficio'] ?? ''));

    // Manejo de la foto de perfil
    $upload_dir = '../../uploads/fotos_perfil/';
    $fotoperfil = null;

    if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['fotoperfil']['tmp_name'];
        $file_name = $_FILES['fotoperfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            $fotoperfil = $new_file_name;
        }
    }

    // Verificar si el documento ya existe
    try {
        $stmt_check = $connect->prepare("SELECT COUNT(*) FROM patients WHERE numhs = :numhs");
        $stmt_check->execute([':numhs' => $numhs]);
        $count = $stmt_check->fetchColumn();

        if ($count > 0) {
            echo '<div class="alert alert-error"><strong>Error!</strong> Este número de documento ya está registrado en el sistema.</div>';
            exit(0);
        }
    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
        exit(0);
    }

    // Insertar en la base de datos
    try {
        $query = "INSERT INTO patients (
            numhs, nompa, apepa, direc, sex, grup, phon, tiene_whatsapp, cump, modalidad, tusuario, 
            tdocumento, fexpedicion, lexpedicion, ecivil, zona, barrio, correo, rbono, sisben, 
            pensionado, tsudadera, tchaqueta, tzapatos, talentof, observacionsalida, vivecomp, 
            redapoyo, cuidador, pcuidador, zcuidador, bvccuidador, dcuidador, tcuidador, sgsss, 
            eps, etnia, educacion, leer, utecnologia, poblaciond, poblacionoficio, fotoperfil,
            corr, username, password, rol, state
        ) VALUES (
            :numhs, :nompa, :apepa, :direc, :sex, :grup, :phon, :tiene_whatsapp, :cump, :modalidad, 
            :tusuario, :tdocumento, :fexpedicion, :lexpedicion, :ecivil, :zona, :barrio, :correo, 
            :rbono, :sisben, :pensionado, :tsudadera, :tchaqueta, :tzapatos, :talentof, 
            :observacionsalida, :vivecomp, :redapoyo, :cuidador, :pcuidador, :zcuidador, 
            :bvccuidador, :dcuidador, :tcuidador, :sgsss, :eps, :etnia, :educacion, :leer, 
            :utecnologia, :poblaciond, :poblacionoficio, :fotoperfil,
            :correo, '', '', '3', '1'
        )";

        $statement = $connect->prepare($query);
        
        error_log("Query preparado correctamente");

        $data = [
            ':numhs' => $numhs,
            ':nompa' => $nompa,
            ':apepa' => $apepa,
            ':direc' => $direc,
            ':sex' => $sex,
            ':grup' => $grup,
            ':phon' => $phon,
            ':tiene_whatsapp' => $tiene_whatsapp,
            ':cump' => $cump,
            ':modalidad' => $modalidad,
            ':tusuario' => $tusuario,
            ':tdocumento' => $tdocumento,
            ':fexpedicion' => $fexpedicion,
            ':lexpedicion' => $lexpedicion,
            ':ecivil' => $ecivil,
            ':zona' => $zona,
            ':barrio' => $barrio,
            ':correo' => $correo,
            ':rbono' => $rbono,
            ':sisben' => $sisben,
            ':pensionado' => $pensionado,
            ':tsudadera' => $tsudadera,
            ':tchaqueta' => $tchaqueta,
            ':tzapatos' => $tzapatos,
            ':talentof' => $talentof,
            ':observacionsalida' => $observacionsalida,
            ':vivecomp' => $vivecomp,
            ':redapoyo' => $redapoyo,
            ':cuidador' => $cuidador,
            ':pcuidador' => $pcuidador,
            ':zcuidador' => $zcuidador,
            ':bvccuidador' => $bvccuidador,
            ':dcuidador' => $dcuidador,
            ':tcuidador' => $tcuidador,
            ':sgsss' => $sgsss,
            ':eps' => $eps,
            ':etnia' => $etnia,
            ':educacion' => $educacion,
            ':leer' => $leer,
            ':utecnologia' => $utecnologia,
            ':poblaciond' => $poblaciond,
            ':poblacionoficio' => $poblacionoficio,
            ':fotoperfil' => $fotoperfil
        ];
        
        error_log("Datos preparados, ejecutando query...");
        error_log("Total de parámetros: " . count($data));

        $query_execute = $statement->execute($data);
        
        error_log("Query ejecutado. Resultado: " . ($query_execute ? 'TRUE' : 'FALSE'));

        if($query_execute) {
            echo '<div class="alert alert-success" style="position: relative; z-index: 10000;">
                <strong>¡Inscripción Completada!</strong><br>
                Tu inscripción al programa ha sido enviada correctamente.<br>
                <strong>Nombre:</strong> ' . $nompa . ' ' . $apepa . '<br>
                <strong>Documento:</strong> ' . $numhs . '<br><br>
                Serás redirigido al dashboard en 3 segundos...
            </div>';
            
            echo '<script>
                console.log("Inscripción exitosa, redirigiendo...");
                setTimeout(function() {
                    window.location.href = "dashboard.php";
                }, 3000);
            </script>';
        } else {
            $errorInfo = $statement->errorInfo();
            echo '<div class="alert alert-error" style="position: relative; z-index: 10000;">
                <strong>Error!</strong> No se pudo procesar tu inscripción.<br>
                Error SQL: ' . $errorInfo[2] . '
            </div>';
            error_log("Error SQL: " . print_r($errorInfo, true));
        }

    } catch (PDOException $e) {
        echo '<div class="alert alert-error" style="position: relative; z-index: 10000;">
            <strong>Error PDO!</strong> ' . $e->getMessage() . '<br>
            <strong>Código:</strong> ' . $e->getCode() . '
        </div>';
        error_log("Error PDO: " . $e->getMessage());
    }
}
?>
