<?php
/**
 * Script de migración para agregar la columna 'tipo' a la tabla 'document'
 * Ejecutar este script una sola vez para actualizar la base de datos
 */

require_once('../../backend/bd/Conexion.php');

try {
    // Verificar si la columna 'tipo' ya existe
    $check_column = $connect->query("SHOW COLUMNS FROM document LIKE 'tipo'");
    
    if($check_column->rowCount() == 0) {
        // La columna no existe, agregarla
        $sql = "ALTER TABLE document ADD COLUMN tipo VARCHAR(20) DEFAULT 'general' AFTER state";
        $connect->exec($sql);
        echo "✓ Columna 'tipo' agregada exitosamente a la tabla 'document'<br>";
        
        // Actualizar registros existentes para que tengan tipo 'general'
        $update = "UPDATE document SET tipo = 'general' WHERE tipo IS NULL OR tipo = ''";
        $connect->exec($update);
        echo "✓ Registros existentes actualizados con tipo 'general'<br>";
    } else {
        echo "✓ La columna 'tipo' ya existe en la tabla 'document'<br>";
    }
    
    echo "<br><strong>Migración completada exitosamente!</strong>";
    
} catch(PDOException $e) {
    echo "Error en la migración: " . $e->getMessage();
}
?>
