<?php
session_start();
require '../bd/Conexion.php';

// Verificar que sea admin o profesional
if(!isset($_SESSION['rol']) || ($_SESSION['rol'] != 1 && $_SESSION['rol'] != 2)) {
    header('location: ../../frontend/acceso_denegado.php');
    exit();
}

$userId = $_GET['user_id'] ?? $_POST['user_id'] ?? null;
$accion = $_GET['accion'] ?? $_POST['accion'] ?? null;

if(!$userId || !$accion) {
    $_SESSION['error'] = "Datos incompletos";
    header('location: ../../frontend/pacientes/aprobar_ciudadanos.php');
    exit();
}

$aprobadorId = $_SESSION['id'];

try {
    if($accion == 'aprobar') {
        // Aprobar ciudadano
        $stmt = $connect->prepare("
            UPDATE users 
            SET aprobado = 'aprobado', 
                fecha_aprobacion = NOW(), 
                aprobado_por = ?,
                motivo_rechazo = NULL
            WHERE id = ? AND rol = 3
        ");
        $stmt->execute([$aprobadorId, $userId]);
        
        $_SESSION['success'] = "Ciudadano aprobado exitosamente";
        
    } elseif($accion == 'rechazar') {
        // Rechazar ciudadano
        $motivoRechazo = $_POST['motivo_rechazo'] ?? 'No especificado';
        
        $stmt = $connect->prepare("
            UPDATE users 
            SET aprobado = 'rechazado', 
                fecha_aprobacion = NOW(), 
                aprobado_por = ?,
                motivo_rechazo = ?
            WHERE id = ? AND rol = 3
        ");
        $stmt->execute([$aprobadorId, $motivoRechazo, $userId]);
        
        $_SESSION['success'] = "Ciudadano rechazado";
        
    } elseif($accion == 'revocar') {
        // Revocar aprobación (volver a pendiente)
        $stmt = $connect->prepare("
            UPDATE users 
            SET aprobado = 'pendiente', 
                fecha_aprobacion = NULL, 
                aprobado_por = NULL,
                motivo_rechazo = NULL
            WHERE id = ? AND rol = 3
        ");
        $stmt->execute([$userId]);
        
        $_SESSION['success'] = "Aprobación revocada. El ciudadano vuelve a estado pendiente";
    }
    
} catch(PDOException $e) {
    $_SESSION['error'] = "Error al procesar: " . $e->getMessage();
}

header('location: ../../frontend/pacientes/aprobar_ciudadanos.php');
exit();
?>
