<?php  
// Asumiendo que $connect ya está definido y es tu conexión PDO
// include_once '../../config/dbcon.php'; // Asegúrate de que tu conexión a la DB esté incluida

if(isset($_POST['upd_patiens']))
{
    // Recibir y limpiar datos del formulario
    $idpa = isset($_POST['idpa']) ? trim($_POST['idpa']) : (isset($_GET['id']) ? trim($_GET['id']) : '');
    $numhs = trim($_POST['nhi']);
    $nompa = strtoupper(trim($_POST['namp']));
    $apepa = strtoupper(trim($_POST['apep']));  
    $direc = strtoupper(trim($_POST['dip']));
    $sex = strtoupper(trim($_POST['gep']));
    $grup = strtoupper(trim($_POST['grp']));
    $phon = trim($_POST['telp']);
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $cump = trim($_POST['cump']);
    $modalidad = strtoupper(trim($_POST['modalidad']));
    $tusuario = strtoupper(trim($_POST['tusuario']));
    $tdocumento = strtoupper(trim($_POST['tdocumento']));
    $fexpedicion_input = trim($_POST['fexpedicion']);
    // Convertir fecha de YYYY-MM-DD a DD/MM/YYYY para mantener consistencia en BD
    if (!empty($fexpedicion_input) && strpos($fexpedicion_input, '-') !== false) {
        $fecha_parts = explode('-', $fexpedicion_input);
        if (count($fecha_parts) == 3) {
            $fexpedicion = $fecha_parts[2] . '/' . $fecha_parts[1] . '/' . $fecha_parts[0];
        } else {
            $fexpedicion = $fexpedicion_input;
        }
    } else {
        $fexpedicion = $fexpedicion_input;
    }
    $lexpedicion = strtoupper(trim($_POST['lexpedicion']));
    $ecivil = strtoupper(trim($_POST['ecivil']));
    $zona = strtoupper(trim($_POST['zona']));
    $barrio = strtoupper(trim($_POST['barrio']));
    $correo = trim($_POST['correo']);
    $rbono = $_POST['rbono'];
    $sisben = $_POST['sisben'];
    $pensionado = $_POST['pensionado'];
    $tsudadera = $_POST['tsudadera'];
    $tchaqueta = $_POST['tchaqueta'];
    $tzapatos = $_POST['tzapatos'];
    $talentof = $_POST['talentof'];
    $observacionsalida = $_POST['observacionsalida'];
    $vivecomp = $_POST['vivecomp'];
    $redapoyo = $_POST['redapoyo'];
    $cuidador = $_POST['cuidador'];
    $pcuidador = $_POST['pcuidador'];
    $zcuidador = $_POST['zcuidador'];
    $bvccuidador = $_POST['bvccuidador'];
    $dcuidador = $_POST['dcuidador'];
    $tcuidador = $_POST['tcuidador'];
    $sgsss = $_POST['sgsss'];
    $eps = $_POST['eps'];
    $etnia = $_POST['etnia'];
    $educacion = $_POST['educacion'];
    $leer = $_POST['leer'];
    $utecnologia = $_POST['utecnologia'];
    $poblaciond = $_POST['poblaciond'];
    $poblacionoficio = $_POST['poblacionoficio'];
    
    $upload_dir = '../../uploads/fotos_perfil/'; // Directorio de subida de fotos

    // 1. Obtener el nombre de la foto actual del paciente desde la base de datos
    $fotoperfil = null; // Variable para almacenar el nombre de la foto (nueva o existente)
    $old_fotoperfil_name = null; // Para almacenar el nombre de la foto anterior

    try {
        $stmt_fetch_old_photo = $connect->prepare("SELECT fotoperfil FROM patients WHERE idpa = :idpa");
        $stmt_fetch_old_photo->execute([':idpa' => $idpa]);
        $result_old_photo = $stmt_fetch_old_photo->fetch(PDO::FETCH_ASSOC);
        if ($result_old_photo && !empty($result_old_photo['fotoperfil'])) {
            $old_fotoperfil_name = $result_old_photo['fotoperfil'];
            $fotoperfil = $old_fotoperfil_name; // Por defecto, conserva la foto existente
        }
    } catch (PDOException $e) {
        echo "Error de base de datos al obtener foto anterior: " . $e->getMessage();
        exit(0);
    }

    // 2. Manejar la subida de la nueva foto (si se ha seleccionado una)
    if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['fotoperfil']['tmp_name'];
        $file_name = $_FILES['fotoperfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        // Generar un nombre de archivo único para la nueva foto
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        // Asegurarse de que el directorio exista y sea escribible
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            // Se subió la nueva foto exitosamente
            $fotoperfil = $new_file_name;

            // 3. Eliminar la foto anterior del servidor si existe y es diferente a la nueva
            if ($old_fotoperfil_name && $old_fotoperfil_name !== $new_file_name) {
                $old_file_path = $upload_dir . $old_fotoperfil_name;
                if (file_exists($old_file_path)) {
                    unlink($old_file_path); // Elimina el archivo anterior
                    // echo "Foto anterior eliminada: " . $old_file_path . "<br>"; // Para depuración
                }
            }
        } else {
            // Error al subir la nueva foto
            echo '<div class="alert-error"><strong>Error!</strong> No se pudo subir la nueva foto de perfil.</div>';
            exit(0);
        }
    } 
    // Si no se selecciona una nueva foto, $fotoperfil ya contiene el nombre de la foto anterior o es null

    // 4. Actualizar la base de datos con el nombre de la foto (nueva o la existente)
    try {
        $query = "UPDATE patients SET 
        numhs=:numhs, nompa=:nompa, apepa=:apepa,direc=:direc,sex=:sex,grup=:grup,phon=:phon, tiene_whatsapp=:tiene_whatsapp, cump=:cump, modalidad=:modalidad, tusuario=:tusuario, tdocumento=:tdocumento,  fexpedicion=:fexpedicion,  lexpedicion=:lexpedicion,  ecivil=:ecivil,  zona=:zona,  barrio=:barrio,  correo=:correo,  rbono=:rbono,  sisben=:sisben,  pensionado=:pensionado,  tsudadera=:tsudadera,  tchaqueta=:tchaqueta,  tzapatos=:tzapatos,  talentof=:talentof,  observacionsalida=:observacionsalida,  vivecomp=:vivecomp,  redapoyo=:redapoyo,  cuidador=:cuidador,  pcuidador=:pcuidador,  zcuidador=:zcuidador,  bvccuidador=:bvccuidador,  dcuidador=:dcuidador,  tcuidador=:tcuidador,  sgsss=:sgsss,  eps=:eps,  etnia=:etnia,  educacion=:educacion,  leer=:leer,  utecnologia=:utecnologia,  poblaciond=:poblaciond,  poblacionoficio=:poblacionoficio, fotoperfil=:fotoperfil WHERE idpa=:idpa LIMIT 1";

        $statement = $connect->prepare($query);

        $data = [
            ':numhs' => $numhs,
            ':nompa' => $nompa,
            ':apepa' => $apepa,
            ':direc' => $direc,
            ':sex' => $sex,
            ':grup' => $grup,
            ':phon' => $phon,
            ':tiene_whatsapp' => $tiene_whatsapp,
            ':cump' => $cump,
            ':idpa' => $idpa,
            ':modalidad' => $modalidad,
            ':tusuario' => $tusuario,  
            ':tdocumento' => $tdocumento,  
            ':fexpedicion' => $fexpedicion,  
            ':lexpedicion' => $lexpedicion,  
            ':ecivil' => $ecivil,  
            ':zona' => $zona,  
            ':barrio' => $barrio,  
            ':correo' => $correo,  
            ':rbono' => $rbono,  
            ':sisben' => $sisben,  
            ':pensionado' => $pensionado,  
            ':tsudadera' => $tsudadera,  
            ':tchaqueta' => $tchaqueta,  
            ':tzapatos' => $tzapatos,  
            ':talentof' => $talentof,  
            ':observacionsalida' => $observacionsalida,  
            ':vivecomp' => $vivecomp,  
            ':redapoyo' => $redapoyo,  
            ':cuidador' => $cuidador,  
            ':pcuidador' => $pcuidador,  
            ':zcuidador' => $zcuidador,  
            ':bvccuidador' => $bvccuidador,  
            ':dcuidador' => $dcuidador,  
            ':tcuidador' => $tcuidador,  
            ':sgsss' => $sgsss,  
            ':eps' => $eps,  
            ':etnia' => $etnia,  
            ':educacion' => $educacion,  
            ':leer' => $leer,  
            ':utecnologia' => $utecnologia,  
            ':poblaciond' => $poblaciond,  
            ':poblacionoficio' => $poblacionoficio, 
            ':fotoperfil' => $fotoperfil // Utiliza la variable $fotoperfil que ya tiene el nombre correcto
        ];
        $query_execute = $statement->execute($data);

        if($query_execute)
        {
            $_SESSION['mensaje_actualizacion'] = 'Usuario actualizado correctamente';
            $_SESSION['tipo_mensaje'] = 'success';
            header('Location: ../../frontend/pacientes/mostrar.php');
            exit(0);
        }
        else
        {
            $_SESSION['mensaje_actualizacion'] = 'Error al actualizar el usuario';
            $_SESSION['tipo_mensaje'] = 'error';
            header('Location: editar.php?id=' . $idpa);
            exit(0);
        }

    } catch (PDOException $e) {
        echo $e->getMessage();
    }
}
?>