-- Tabla de permisos granulares por usuario
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL,
  `view_valoracion_riesgo` TINYINT(1) DEFAULT 0,
  `edit_valoracion_riesgo` TINYINT(1) DEFAULT 0,
  `view_signos_vitales` TINYINT(1) DEFAULT 0,
  `edit_signos_vitales` TINYINT(1) DEFAULT 0,
  `view_medicamentos` TINYINT(1) DEFAULT 0,
  `edit_medicamentos` TINYINT(1) DEFAULT 0,
  `view_diagnostico` TINYINT(1) DEFAULT 0,
  `edit_diagnostico` TINYINT(1) DEFAULT 0,
  `view_antecedentes` TINYINT(1) DEFAULT 0,
  `edit_antecedentes` TINYINT(1) DEFAULT 0,
  `view_examenes` TINYINT(1) DEFAULT 0,
  `edit_examenes` TINYINT(1) DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar permisos por defecto para rol de Enfermería (rol 6)
-- Estos se aplicarán automáticamente al crear un usuario con rol 6
