<?php
session_start();
require_once('backend/bd/Conexion.php');
global $connect;

$documento = '1072189014';

echo "<h1>Búsqueda de Documento: $documento</h1>";

try {
    $stmt = $connect->prepare("SELECT * FROM patients WHERE numhs = :documento");
    $stmt->execute([':documento' => $documento]);
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($resultado) {
        echo "<div style='background: #d4edda; color: #155724; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
        echo "<h2>✅ DOCUMENTO ENCONTRADO</h2>";
        echo "<p><strong>ID:</strong> " . $resultado['idpa'] . "</p>";
        echo "<p><strong>Documento:</strong> " . $resultado['numhs'] . "</p>";
        echo "<p><strong>Nombres:</strong> " . $resultado['nompa'] . "</p>";
        echo "<p><strong>Apellidos:</strong> " . $resultado['apepa'] . "</p>";
        echo "<p><strong>Correo:</strong> " . $resultado['correo'] . "</p>";
        echo "<p><strong>Modalidad:</strong> " . $resultado['modalidad'] . "</p>";
        echo "<p><strong>Fecha Registro:</strong> " . $resultado['fere'] . "</p>";
        echo "</div>";
        
        echo "<h3>Todos los datos:</h3>";
        echo "<pre>";
        print_r($resultado);
        echo "</pre>";
    } else {
        echo "<div style='background: #f8d7da; color: #721c24; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
        echo "<h2>❌ DOCUMENTO NO ENCONTRADO</h2>";
        echo "<p>El documento <strong>$documento</strong> no existe en la tabla patients.</p>";
        echo "</div>";
    }
    
    // Buscar documentos similares
    echo "<h2>Documentos similares (que contengan '1072189'):</h2>";
    $stmt2 = $connect->prepare("SELECT idpa, numhs, nompa, apepa FROM patients WHERE numhs LIKE :patron ORDER BY idpa DESC LIMIT 10");
    $stmt2->execute([':patron' => '1072189%']);
    $similares = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    
    if(count($similares) > 0) {
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%; background: white;'>";
        echo "<tr style='background: #667eea; color: white;'>
                <th>ID</th>
                <th>Documento</th>
                <th>Nombres</th>
                <th>Apellidos</th>
              </tr>";
        
        foreach($similares as $sim) {
            echo "<tr>";
            echo "<td>" . $sim['idpa'] . "</td>";
            echo "<td><strong>" . $sim['numhs'] . "</strong></td>";
            echo "<td>" . $sim['nompa'] . "</td>";
            echo "<td>" . $sim['apepa'] . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>No se encontraron documentos similares.</p>";
    }
    
} catch(PDOException $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 20px;'>";
    echo "<strong>Error:</strong> " . $e->getMessage();
    echo "</div>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
        background: #f5f5f5;
    }
    table {
        margin: 20px 0;
    }
    tr:nth-child(even) {
        background: #f9f9f9;
    }
</style>
