<?php
// Activar reporte de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h2>Verificación de Errores PHP</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";

// Verificar conexión a base de datos
echo "<h3>1. Verificando conexión a base de datos...</h3>";
try {
    require 'backend/bd/Conexion.php';
    echo "✅ Conexión a base de datos exitosa<br>";
} catch(Exception $e) {
    echo "❌ Error en conexión: " . $e->getMessage() . "<br>";
}

// Verificar sesión
echo "<h3>2. Verificando sesión...</h3>";
session_start();
echo "✅ Sesión iniciada correctamente<br>";
echo "Session ID: " . session_id() . "<br>";

// Verificar archivos críticos
echo "<h3>3. Verificando archivos críticos...</h3>";
$files = [
    'backend/php/login.php',
    'backend/php/check_access.php',
    'frontend/login.php',
    'frontend/admin/escritorio.php'
];

foreach($files as $file) {
    if(file_exists($file)) {
        echo "✅ $file existe<br>";
    } else {
        echo "❌ $file NO existe<br>";
    }
}

echo "<h3>4. Información del servidor</h3>";
echo "Server Software: " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "<br>";

echo "<h3>✅ Verificación completada</h3>";
?>
