<?php
/**
 * Script de Debug para verificar permisos de Enfermería
 * Ejecutar desde: http://localhost/hogar_abuelos/debug_permisos_enfermeria.php
 */

require 'backend/bd/Conexion.php';

echo "<!DOCTYPE html>";
echo "<html><head>";
echo "<meta charset='UTF-8'>";
echo "<style>
    body { font-family: Arial; padding: 20px; background: #f5f5f5; }
    .container { max-width: 1200px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    h1 { color: #667eea; border-bottom: 3px solid #667eea; padding-bottom: 10px; }
    h2 { color: #764ba2; margin-top: 30px; }
    .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #28a745; }
    .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #dc3545; }
    .warning { background: #fff3cd; color: #856404; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #ffc107; }
    .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #17a2b8; }
    table { width: 100%; border-collapse: collapse; margin: 15px 0; }
    th { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px; text-align: left; }
    td { padding: 10px; border-bottom: 1px solid #ddd; }
    tr:hover { background: #f8f9fc; }
    .btn { display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 6px; margin: 5px; }
    .btn:hover { background: #764ba2; }
    code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; font-family: monospace; }
</style>";
echo "</head><body>";
echo "<div class='container'>";

echo "<h1>🔍 Debug de Permisos - Rol Enfermería</h1>";

// 1. Verificar estructura de la tabla menu_permissions
echo "<h2>1. Estructura de la tabla menu_permissions</h2>";
try {
    $columnsStmt = $connect->query("SHOW COLUMNS FROM menu_permissions");
    $columns = $columnsStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<div class='success'>✅ Tabla menu_permissions existe</div>";
    echo "<p><strong>Total de columnas:</strong> " . count($columns) . "</p>";
    
    $requiredColumns = ['usuarios_lista', 'usuarios_historial', 'usuarios_documentos', 'profesionales_lista', 'profesionales_historial'];
    $missingColumns = [];
    
    $existingColumns = array_column($columns, 'Field');
    
    echo "<table>";
    echo "<tr><th>Columna Requerida</th><th>Estado</th></tr>";
    foreach($requiredColumns as $reqCol) {
        $exists = in_array($reqCol, $existingColumns);
        $status = $exists ? "<span style='color: green;'>✅ Existe</span>" : "<span style='color: red;'>❌ No existe</span>";
        echo "<tr><td><code>$reqCol</code></td><td>$status</td></tr>";
        if(!$exists) {
            $missingColumns[] = $reqCol;
        }
    }
    echo "</table>";
    
    if(!empty($missingColumns)) {
        echo "<div class='error'>";
        echo "<strong>⚠️ Columnas faltantes detectadas:</strong><br>";
        echo "Las siguientes columnas deben agregarse a la tabla menu_permissions:<br>";
        foreach($missingColumns as $col) {
            echo "- <code>$col</code><br>";
        }
        echo "</div>";
        
        echo "<div class='warning'>";
        echo "<strong>💡 Solución:</strong> Ejecuta el siguiente SQL en phpMyAdmin:<br><br>";
        echo "<textarea style='width: 100%; height: 150px; font-family: monospace; padding: 10px;'>";
        foreach($missingColumns as $col) {
            echo "ALTER TABLE menu_permissions ADD COLUMN $col TINYINT(1) DEFAULT 0;\n";
        }
        echo "</textarea>";
        echo "</div>";
    }
    
} catch(PDOException $e) {
    echo "<div class='error'>❌ Error: " . $e->getMessage() . "</div>";
}

// 2. Buscar usuarios con rol de Enfermería (rol = 6)
echo "<h2>2. Usuarios con Rol de Enfermería (rol = 6)</h2>";
try {
    $stmt = $connect->query("SELECT id, username, name, email, rol FROM users WHERE rol = 6");
    $nurses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if(count($nurses) > 0) {
        echo "<div class='success'>✅ Encontrados " . count($nurses) . " usuario(s) con rol de enfermería</div>";
        echo "<table>";
        echo "<tr><th>ID</th><th>Usuario</th><th>Nombre</th><th>Email</th><th>Acción</th></tr>";
        foreach($nurses as $nurse) {
            echo "<tr>";
            echo "<td>{$nurse['id']}</td>";
            echo "<td><strong>{$nurse['username']}</strong></td>";
            echo "<td>{$nurse['name']}</td>";
            echo "<td>{$nurse['email']}</td>";
            echo "<td><a href='#user_{$nurse['id']}' class='btn'>Ver Permisos</a></td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Mostrar permisos de cada enfermera
        foreach($nurses as $nurse) {
            echo "<div id='user_{$nurse['id']}' style='margin-top: 30px; padding: 20px; background: #f8f9fc; border-radius: 8px;'>";
            echo "<h3>👤 Permisos de: {$nurse['name']} (@{$nurse['username']})</h3>";
            
            $permsStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
            $permsStmt->execute([$nurse['id']]);
            $perms = $permsStmt->fetch(PDO::FETCH_ASSOC);
            
            if($perms) {
                echo "<div class='success'>✅ Tiene registro de permisos personalizados</div>";
                
                $relevantPerms = [
                    'usuarios' => 'Módulo Usuarios',
                    'usuarios_lista' => '→ Lista de Usuarios',
                    'usuarios_historial' => '→ Historial de Usuarios',
                    'usuarios_documentos' => '→ Documentos',
                    'profesionales' => 'Módulo Profesionales',
                    'profesionales_lista' => '→ Lista de Profesionales',
                    'profesionales_historial' => '→ Historial de Profesionales'
                ];
                
                echo "<table>";
                echo "<tr><th>Permiso</th><th>Valor</th><th>Estado</th></tr>";
                foreach($relevantPerms as $key => $label) {
                    $value = isset($perms[$key]) ? $perms[$key] : 'N/A';
                    $status = '';
                    $bgColor = '';
                    
                    if($value === 'N/A') {
                        $status = '⚠️ Columna no existe';
                        $bgColor = '#fff3cd';
                    } else if($value == 1) {
                        $status = '✅ Habilitado';
                        $bgColor = '#d4edda';
                    } else {
                        $status = '❌ Deshabilitado';
                        $bgColor = '#f8d7da';
                    }
                    
                    echo "<tr style='background: $bgColor;'>";
                    echo "<td><strong>$label</strong></td>";
                    echo "<td><code>$value</code></td>";
                    echo "<td>$status</td>";
                    echo "</tr>";
                }
                echo "</table>";
                
            } else {
                echo "<div class='error'>❌ NO tiene registro de permisos en menu_permissions</div>";
                echo "<div class='warning'>💡 Debes editar este usuario desde el panel de profesionales y asignarle permisos.</div>";
            }
            
            echo "</div>";
        }
        
    } else {
        echo "<div class='warning'>⚠️ No se encontraron usuarios con rol de enfermería (rol = 6)</div>";
    }
    
} catch(PDOException $e) {
    echo "<div class='error'>❌ Error: " . $e->getMessage() . "</div>";
}

// 3. Verificar archivos de control de acceso
echo "<h2>3. Verificación del Sistema de Control de Acceso</h2>";
$files = [
    'backend/php/check_access.php' => 'Sistema de control de acceso',
    'backend/php/login.php' => 'Script de login',
    'frontend/pacientes/mostrar.php' => 'Lista de usuarios',
    'frontend/pacientes/historial.php' => 'Historial de usuarios',
    'frontend/medicos/mostrar.php' => 'Lista de profesionales'
];

echo "<table>";
echo "<tr><th>Archivo</th><th>Descripción</th><th>Estado</th></tr>";
foreach($files as $file => $desc) {
    $exists = file_exists($file);
    $status = $exists ? "✅ Existe" : "❌ No encontrado";
    $bgColor = $exists ? '#d4edda' : '#f8d7da';
    echo "<tr style='background: $bgColor;'>";
    echo "<td><code>$file</code></td>";
    echo "<td>$desc</td>";
    echo "<td>$status</td>";
    echo "</tr>";
}
echo "</table>";

// 4. Instrucciones finales
echo "<h2>4. Instrucciones para Solucionar el Problema</h2>";
echo "<div class='info'>";
echo "<h3>📋 Pasos para corregir:</h3>";
echo "<ol>";
echo "<li><strong>Si faltan columnas en menu_permissions:</strong> Ejecuta el SQL proporcionado arriba en phpMyAdmin</li>";
echo "<li><strong>Asignar permisos al usuario de enfermería:</strong>";
echo "<ul>";
echo "<li>Ve a: <a href='frontend/medicos/mostrar.php' target='_blank'>Lista de Profesionales</a></li>";
echo "<li>Haz clic en 'Editar Permisos' del usuario de enfermería</li>";
echo "<li>Activa los siguientes permisos:</li>";
echo "<ul>";
echo "<li>☑️ Usuarios (módulo principal)</li>";
echo "<li>☑️ Usuarios - Lista de Usuarios</li>";
echo "<li>☑️ Usuarios - Historial de Usuarios</li>";
echo "</ul>";
echo "<li>Guarda los cambios</li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>Cerrar sesión y volver a iniciar:</strong> Esto cargará los nuevos permisos en la sesión</li>";
echo "<li><strong>Probar el acceso:</strong> Intenta acceder a las secciones permitidas</li>";
echo "</ol>";
echo "</div>";

echo "<div style='margin-top: 30px; text-align: center;'>";
echo "<a href='frontend/medicos/mostrar.php' class='btn'>Ir a Profesionales</a>";
echo "<a href='verificar_permisos.php' class='btn' style='background: #28a745;'>Verificar Permisos de Usuario</a>";
echo "<a href='debug_permisos_enfermeria.php' class='btn' style='background: #17a2b8;'>Recargar Debug</a>";
echo "</div>";

echo "</div>";
echo "</body></html>";
?>
