<?php
require 'backend/bd/Conexion.php';

echo "<h1>Debug - Profesionales y Usuarios</h1>";

// Ver datos de la tabla doctor
echo "<h2>Tabla DOCTOR:</h2>";
$doctors = $connect->query("SELECT * FROM doctor")->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($doctors);
echo "</pre>";

// Ver datos de la tabla users
echo "<h2>Tabla USERS:</h2>";
$users = $connect->query("SELECT * FROM users")->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($users);
echo "</pre>";

// Ver el JOIN
echo "<h2>JOIN (doctor + users) - CORRECTO:</h2>";
$join = $connect->query("SELECT d.*, u.id as user_id, COALESCE(u.rol, d.rol) as rol, u.username as user_username FROM doctor d LEFT JOIN users u ON d.username = u.username")->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($join);
echo "</pre>";

echo "<h2>¿Cuáles deberían tener botón de permisos?</h2>";
echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>Doctor</th><th>Username</th><th>Rol</th><th>User ID</th><th>¿Tiene botón?</th></tr>";
foreach($join as $j) {
    $tieneBoton = ($j['rol'] == 4 || $j['rol'] == 5 || $j['rol'] == 6) ? '✅ SÍ' : '❌ NO';
    $color = ($j['rol'] == 4 || $j['rol'] == 5 || $j['rol'] == 6) ? 'lightgreen' : 'lightcoral';
    echo "<tr style='background: $color;'>";
    echo "<td>{$j['nodoc']} {$j['apdoc']}</td>";
    echo "<td>{$j['username']}</td>";
    echo "<td><strong>{$j['rol']}</strong></td>";
    echo "<td>{$j['user_id']}</td>";
    echo "<td><strong>$tieneBoton</strong></td>";
    echo "</tr>";
}
echo "</table>";

// Ver permisos
echo "<h2>Tabla USER_PERMISSIONS:</h2>";
try {
    $perms = $connect->query("SELECT * FROM user_permissions")->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($perms);
    echo "</pre>";
} catch(Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>
